package org.gcube.portlets.user.td.expressionwidget.shared.model.leaf;

import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;

public class C_ColumnReferencePlaceholder extends C_Leaf {

	private static final long serialVersionUID = 275747262118236529L;
	protected String id = "ColumnReferencePlaceholder";
	protected String columnId;
	protected ColumnDataType dataType;

	public C_ColumnReferencePlaceholder() {

	}

	public C_ColumnReferencePlaceholder(ColumnDataType dataType, String columnId) {
		this.dataType = dataType;
		this.columnId = columnId;
		if (dataType != null && columnId != null) {
			this.readableExpression = "PlaceHolder("
					+ dataType.getColumnDataTypeLabel() +
					"," + columnId + ")";
		}

	}

	@Override
	public String getId() {
		return id;
	}

	public String getColumnId() {
		return columnId;
	}

	public void setColumnId(String columnId) {
		this.columnId = columnId;
	}

	public ColumnDataType getDataType() {
		return dataType;
	}

	public void setDataType(ColumnDataType dataType) {
		this.dataType = dataType;
	}

	@Override
	public String toString() {
		return "ColumnReferencePlaceholder [id=" + id + ", columnId="
				+ columnId + ", dataType=" + dataType + "]";
	}

}
