package org.gcube.portlets.user.td.expressionwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.expressionwidget.client.properties.ColumnDataPropertiesCombo;
import org.gcube.portlets.user.td.expressionwidget.client.properties.ReplaceElement;
import org.gcube.portlets.user.td.expressionwidget.client.properties.ReplaceElementProperties;
import org.gcube.portlets.user.td.expressionwidget.client.properties.ReplaceElementStore;
import org.gcube.portlets.user.td.expressionwidget.client.type.ReplaceColumnByExpressionType;
import org.gcube.portlets.user.td.expressionwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ReplaceTypeMapException;
import org.gcube.portlets.user.td.expressionwidget.shared.replace.ReplaceType;
import org.gcube.portlets.user.td.expressionwidget.shared.replace.ReplaceTypeMap;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFinalException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.BeforeShowEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceWidget extends SimpleContainer {

	private static final String EMPTY_TEXT_TO_STRING = "to string...";
	private static final String EMPTY_TEXT_FROM_STRING = "from string...";
	private static final String EMPTY_TEXT_TO_INDEX = "to index...";
	private static final String EMPTY_TEXT_FROM_INDEX = "from index...";
	private static final String EMPTY_TEXT_REGEXP = "regexp...";
	private static final String EMPTY_TEXT_INSERT_A_STRING = "insert a string...";
	private static final String EMPTY_TEXT_REPLACE_REGEXP = "regexp...";
	private static final String EMPTY_TEXT_REPLACE_REPLACING = "replacing...";

	private ReplaceWidget thisCont;

	private static final String HEIGHT = "210px";
	private static final String WIDTH = "832px";
	private static final String COMBO_WIDTH = "170px";

	private EventBus eventBus;
	private TRId trId;
	private ArrayList<ColumnData> columns;

	// private FieldLabel matchLabel;
	// private ToggleGroup groupMatch;

	private VerticalLayoutContainer vert;
	// protected ColumnData column;

	private String readableExpression;
	private String itemIdComboConcat;
	private String itemIdComboLeaf;
	private String itemIdComboColumns;
	private String itemIdFirstArg;
	private String itemIdSecondArg;
	private String itemIdHoriz;
	private ReplaceColumnByExpressionType replaceColumnByExpressionType;

	protected class ExpressionContainer {
		private C_Expression expression;
		private String readableExpression;

		public ExpressionContainer(C_Expression expression,
				String readableExpression) {
			super();
			this.expression = expression;
			this.readableExpression = readableExpression;
		}

		public C_Expression getExpression() {
			return expression;
		}

		public void setExpression(C_Expression expression) {
			this.expression = expression;
		}

		public String getReadableExpression() {
			return readableExpression;
		}

		public void setReadableExpression(String readableExpression) {
			this.readableExpression = readableExpression;
		}

	}

	public ReplaceWidget(ColumnData column, EventBus eventBus) {
		super();
		replaceColumnByExpressionType = ReplaceColumnByExpressionType.Replace;
		create(column.getTrId(), WIDTH, HEIGHT, eventBus);
		retrieveColumns();
	}

	public ReplaceWidget(ColumnData column, String width, String height,
			EventBus eventBus) {
		super();
		replaceColumnByExpressionType = ReplaceColumnByExpressionType.Replace;
		create(column.getTrId(), width, height, eventBus);
		retrieveColumns();
	}

	public ReplaceWidget(ColumnData column, ArrayList<ColumnData> columns,
			EventBus eventBus) {
		super();
		replaceColumnByExpressionType = ReplaceColumnByExpressionType.Template;
		this.columns = columns;
		create(column.getTrId(), WIDTH, HEIGHT, eventBus);
		setup();
	}

	public ReplaceWidget(ColumnData column, ArrayList<ColumnData> columns,
			String width, String height, EventBus eventBus) {
		super();
		replaceColumnByExpressionType = ReplaceColumnByExpressionType.Template;
		this.columns = columns;
		create(column.getTrId(), width, height, eventBus);
		setup();
	}

	protected void create(TRId trId, String width, String height,
			EventBus eventBus) {
		this.trId = trId;
		setBorders(true);
		setWidth(width);
		setHeight(height);
		forceLayoutOnResize = true;
		thisCont = this;

		addBeforeShowHandler(new BeforeShowEvent.BeforeShowHandler() {

			@Override
			public void onBeforeShow(BeforeShowEvent event) {
				forceLayout();

			}
		});

	}

	protected void retrieveColumns() {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.error("load combo failure:"
											+ caught.getLocalizedMessage());
									UtilsGXT3.alert("Error",
											"Error retrieving columns of tabular resource:"
													+ trId.getId());
								}
							}
						}
					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.trace("loaded " + result.size() + " ColumnData");
						columns = result;
						setup();
					}

				});
	}

	protected void setup() {
		itemIdComboConcat = "ComboConcat" + trId.getId();
		itemIdComboLeaf = "ComboLeaf" + trId.getId();
		itemIdComboColumns = "ComboColumns" + trId.getId();
		itemIdFirstArg = "FirstArg" + trId.getId();
		itemIdSecondArg = "SecondArg" + trId.getId();
		itemIdHoriz = "Horiz" + trId.getId();

		vert = new VerticalLayoutContainer();
		//vert.setScrollMode(ScrollMode.AUTO); Set in GXT 3.0.1

		final HBoxLayoutContainer horiz = new HBoxLayoutContainer();

		final TextField firstArg = new TextField();
		firstArg.setEmptyText("Insert a string");
		firstArg.setItemId(itemIdFirstArg);

		final TextField secondArg = new TextField();
		secondArg.setEmptyText("");
		secondArg.setItemId(itemIdSecondArg);

		// Combo Column
		ColumnDataPropertiesCombo propsColumnData = GWT
				.create(ColumnDataPropertiesCombo.class);
		ListStore<ColumnData> storeColumns = new ListStore<ColumnData>(
				propsColumnData.id());
		Log.debug("Store Columns: " + storeColumns);
		storeColumns.addAll(columns);

		final ComboBox<ColumnData> comboColumns = new ComboBox<ColumnData>(
				storeColumns, propsColumnData.label());

		Log.debug("Combo Columns created");

		comboColumns.setEmptyText("Select Column...");
		comboColumns.setItemId(itemIdComboColumns);
		comboColumns.setWidth(COMBO_WIDTH);
		comboColumns.setEditable(false);

		comboColumns.setTriggerAction(TriggerAction.ALL);

		// Replace Elemet Store
		ReplaceElementStore factory = new ReplaceElementStore();

		ReplaceElementProperties props = GWT
				.create(ReplaceElementProperties.class);
		Log.debug("Props: " + props);

		// Combo Leaf
		ListStore<ReplaceElement> storeReplaceElementsLeaf = new ListStore<ReplaceElement>(
				props.id());
		Log.debug("Store Leaf: " + storeReplaceElementsLeaf);
		storeReplaceElementsLeaf.addAll(factory.replaceElements);

		Log.debug("Store created");
		final ComboBox<ReplaceElement> comboReplaceElementsLeaf = new ComboBox<ReplaceElement>(
				storeReplaceElementsLeaf, props.label());

		Log.debug("Combo created");

		comboReplaceElementsLeaf
				.addSelectionHandler(new SelectionHandler<ReplaceElement>() {

					public void onSelection(SelectionEvent<ReplaceElement> event) {
						if (event.getSelectedItem() != null) {
							ReplaceElement re = event.getSelectedItem();
							Log.debug("Condition selected:" + re.toString());
							switch (re.getReplaceType()) {
							case Value:
								comboColumns.clear();
								comboColumns.setVisible(false);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_INSERT_A_STRING);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case ColumnValue:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(false);
								firstArg.setEmptyText("");
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case Concat:
								break;
							case SubstringByRegex:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REGEXP);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case SubstringByIndex:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_INDEX);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_INDEX);
								break;
							case SubstringByCharSeq:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_STRING);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_STRING);
								break;
							case TextReplaceMatchingRegex:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REPLACE_REGEXP);
								secondArg.setVisible(true);
								secondArg
										.setEmptyText(EMPTY_TEXT_REPLACE_REPLACING);
								break;
							default:
								break;
							}

							vert.forceLayout();
							thisCont.forceLayout();

						}
					}

				});

		comboReplaceElementsLeaf.setEmptyText("Select...");
		comboReplaceElementsLeaf.setItemId(itemIdComboLeaf);
		comboReplaceElementsLeaf.setWidth(COMBO_WIDTH);
		comboReplaceElementsLeaf.setEditable(false);

		comboReplaceElementsLeaf.setTriggerAction(TriggerAction.ALL);

		// ComboConcat
		ListStore<ReplaceElement> storeReplaceElementsConcat = new ListStore<ReplaceElement>(
				props.id());
		Log.debug("Store Concat: " + storeReplaceElementsConcat);
		storeReplaceElementsConcat.addAll(factory.replaceElementsConcat);

		Log.debug("Store created");
		final ComboBox<ReplaceElement> comboReplaceElementsConcat = new ComboBox<ReplaceElement>(
				storeReplaceElementsConcat, props.label());

		Log.debug("Combo created");

		comboReplaceElementsConcat
				.addSelectionHandler(new SelectionHandler<ReplaceElement>() {

					public void onSelection(SelectionEvent<ReplaceElement> event) {
						if (event.getSelectedItem() != null) {
							@SuppressWarnings("unchecked")
							ComboBox<ReplaceElement> source = (ComboBox<ReplaceElement>) event
									.getSource();
							ReplaceElement re = event.getSelectedItem();
							Log.debug("Condition selected:" + re.toString());
							switch (re.getReplaceType()) {
							case Value:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(false);
								firstArg.setEmptyText(EMPTY_TEXT_INSERT_A_STRING);
								firstArg.setVisible(true);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								removeConcat(source);
								break;
							case ColumnValue:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(false);
								firstArg.setEmptyText("");
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case Concat:
								if (!existConcat(source)) {
									comboReplaceElementsLeaf.clear();
									comboReplaceElementsLeaf.setVisible(true);
									comboColumns.clear();
									comboColumns.setVisible(false);
									firstArg.setVisible(false);
									firstArg.setEmptyText("");
									secondArg.setVisible(false);
									secondArg.setEmptyText("");
									addConcat();
								}
								break;
							case SubstringByRegex:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REGEXP);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								removeConcat(source);
								break;
							case SubstringByIndex:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_INDEX);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_INDEX);
								removeConcat(source);
								break;
							case SubstringByCharSeq:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_STRING);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_STRING);
								removeConcat(source);
								break;
							case TextReplaceMatchingRegex:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REPLACE_REGEXP);
								secondArg.setVisible(true);
								secondArg
										.setEmptyText(EMPTY_TEXT_REPLACE_REPLACING);
								removeConcat(source);
								break;
							default:
								break;
							}
							vert.forceLayout();
							thisCont.forceLayout();

						}
					}

				});

		comboReplaceElementsConcat.setEmptyText("Select...");
		comboReplaceElementsConcat.setItemId(itemIdComboConcat);
		comboReplaceElementsConcat.setWidth(COMBO_WIDTH);
		comboReplaceElementsConcat.setEditable(false);
		comboReplaceElementsConcat.setTriggerAction(TriggerAction.ALL);

		comboReplaceElementsConcat.setValue(storeReplaceElementsConcat.get(0),
				true);

		//
		horiz.add(comboReplaceElementsConcat, new BoxLayoutData(new Margins(0)));
		horiz.add(comboReplaceElementsLeaf, new BoxLayoutData(new Margins(0)));
		horiz.add(comboColumns, new BoxLayoutData(new Margins(0)));
		horiz.add(firstArg, new BoxLayoutData(new Margins(0)));
		horiz.add(secondArg, new BoxLayoutData(new Margins(0)));
		horiz.setItemId(itemIdHoriz);
		vert.add(horiz, new VerticalLayoutData(-1, -1, new Margins(1)));

		add(vert, new MarginData(0));

		firstArg.setVisible(true);
		secondArg.setVisible(false);
		comboColumns.setVisible(false);
		comboReplaceElementsLeaf.setVisible(false);
		comboReplaceElementsConcat.setVisible(true);
		forceLayout();
	}

	protected void addConcat() {
		final HBoxLayoutContainer horiz = new HBoxLayoutContainer();

		final TextField firstArg = new TextField();
		firstArg.setItemId(itemIdFirstArg);

		final TextField secondArg = new TextField();
		secondArg.setItemId(itemIdSecondArg);

		// Combo Column
		ColumnDataPropertiesCombo propsColumnData = GWT
				.create(ColumnDataPropertiesCombo.class);
		ListStore<ColumnData> storeColumns = new ListStore<ColumnData>(
				propsColumnData.id());
		Log.debug("Store Columns: " + storeColumns);
		storeColumns.addAll(columns);

		final ComboBox<ColumnData> comboColumns = new ComboBox<ColumnData>(
				storeColumns, propsColumnData.label());

		Log.debug("Combo Columns created");

		comboColumns.setEmptyText("Select Column...");
		comboColumns.setItemId(itemIdComboColumns);
		comboColumns.setWidth(COMBO_WIDTH);
		comboColumns.setEditable(false);

		comboColumns.setTriggerAction(TriggerAction.ALL);

		//
		ReplaceElementStore factory = new ReplaceElementStore();

		ReplaceElementProperties props = GWT
				.create(ReplaceElementProperties.class);
		Log.debug("Props: " + props);

		// Combo Leaf
		ListStore<ReplaceElement> storeReplaceElementsLeaf = new ListStore<ReplaceElement>(
				props.id());
		Log.debug("Store Leaf: " + storeReplaceElementsLeaf);
		storeReplaceElementsLeaf.addAll(factory.replaceElements);

		Log.debug("Store created");
		final ComboBox<ReplaceElement> comboReplaceElementsLeaf = new ComboBox<ReplaceElement>(
				storeReplaceElementsLeaf, props.label());

		Log.debug("Combo created");

		comboReplaceElementsLeaf
				.addSelectionHandler(new SelectionHandler<ReplaceElement>() {

					public void onSelection(SelectionEvent<ReplaceElement> event) {
						if (event.getSelectedItem() != null) {
							ReplaceElement re = event.getSelectedItem();
							Log.debug("Condition selected:" + re.toString());
							switch (re.getReplaceType()) {
							case Value:
								comboColumns.clear();
								comboColumns.setVisible(false);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_INSERT_A_STRING);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case ColumnValue:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(false);
								firstArg.setEmptyText("");
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case Concat:
								break;
							case SubstringByRegex:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REGEXP);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case SubstringByIndex:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_INDEX);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_INDEX);
								break;
							case SubstringByCharSeq:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_STRING);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_STRING);
								break;
							case TextReplaceMatchingRegex:
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REPLACE_REGEXP);
								secondArg.setVisible(true);
								secondArg
										.setEmptyText(EMPTY_TEXT_REPLACE_REPLACING);
								break;
							default:
								break;
							}
							vert.forceLayout();
							thisCont.forceLayout();

						}
					}

				});

		comboReplaceElementsLeaf.setEmptyText("Select...");
		comboReplaceElementsLeaf.setItemId(itemIdComboLeaf);
		comboReplaceElementsLeaf.setWidth(COMBO_WIDTH);
		comboReplaceElementsLeaf.setEditable(false);

		comboReplaceElementsLeaf.setTriggerAction(TriggerAction.ALL);

		// ComboConcat
		ListStore<ReplaceElement> storeReplaceElementsConcat = new ListStore<ReplaceElement>(
				props.id());
		Log.debug("Store Concat: " + storeReplaceElementsConcat);
		storeReplaceElementsConcat.addAll(factory.replaceElementsConcat);

		Log.debug("Store created");
		final ComboBox<ReplaceElement> comboReplaceElementsConcat = new ComboBox<ReplaceElement>(
				storeReplaceElementsConcat, props.label());

		Log.debug("Combo created");

		comboReplaceElementsConcat
				.addSelectionHandler(new SelectionHandler<ReplaceElement>() {

					public void onSelection(SelectionEvent<ReplaceElement> event) {

						if (event.getSelectedItem() != null) {
							@SuppressWarnings("unchecked")
							ComboBox<ReplaceElement> source = (ComboBox<ReplaceElement>) event
									.getSource();
							ReplaceElement re = event.getSelectedItem();
							Log.debug("Condition selected:" + re.toString());
							switch (re.getReplaceType()) {
							case Value:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(false);
								firstArg.setEmptyText(EMPTY_TEXT_INSERT_A_STRING);
								firstArg.setVisible(true);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								removeConcat(source);
								break;
							case ColumnValue:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(false);
								firstArg.setEmptyText("");
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								break;
							case Concat:
								if (!existConcat(source)) {
									comboReplaceElementsLeaf.clear();
									comboReplaceElementsLeaf.setVisible(true);
									comboColumns.clear();
									comboColumns.setVisible(false);
									firstArg.setVisible(false);
									firstArg.setEmptyText("");
									secondArg.setVisible(false);
									secondArg.setEmptyText("");
									addConcat();
								}
								break;
							case SubstringByRegex:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REGEXP);
								secondArg.setVisible(false);
								secondArg.setEmptyText("");
								removeConcat(source);
								break;
							case SubstringByIndex:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_INDEX);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_INDEX);
								removeConcat(source);
								break;
							case SubstringByCharSeq:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_FROM_STRING);
								secondArg.setVisible(true);
								secondArg.setEmptyText(EMPTY_TEXT_TO_STRING);
								removeConcat(source);
								break;
							case TextReplaceMatchingRegex:
								comboReplaceElementsLeaf.setVisible(false);
								comboColumns.clear();
								comboColumns.setVisible(true);
								firstArg.setVisible(true);
								firstArg.setEmptyText(EMPTY_TEXT_REPLACE_REGEXP);
								secondArg.setVisible(true);
								secondArg
										.setEmptyText(EMPTY_TEXT_REPLACE_REPLACING);
								removeConcat(source);
								break;
							default:
								break;
							}
							vert.forceLayout();
							thisCont.forceLayout();

						}

					}

				});

		comboReplaceElementsConcat.setEmptyText("Select...");
		comboReplaceElementsConcat.setItemId(itemIdComboConcat);
		comboReplaceElementsConcat.setWidth(COMBO_WIDTH);
		comboReplaceElementsConcat.setEditable(false);
		comboReplaceElementsConcat.setTriggerAction(TriggerAction.ALL);

		comboReplaceElementsConcat.setValue(storeReplaceElementsConcat.get(0),
				true);

		//
		horiz.add(comboReplaceElementsConcat, new BoxLayoutData(new Margins(0)));
		horiz.add(comboReplaceElementsLeaf, new BoxLayoutData(new Margins(0)));
		horiz.add(comboColumns, new BoxLayoutData(new Margins(0)));
		horiz.add(firstArg, new BoxLayoutData(new Margins(0)));
		horiz.add(secondArg, new BoxLayoutData(new Margins(0)));
		horiz.setItemId(itemIdHoriz);
		vert.add(horiz, new VerticalLayoutData(-1, -1, new Margins(1)));

		firstArg.setVisible(true);
		secondArg.setVisible(false);
		comboColumns.setVisible(false);
		comboReplaceElementsLeaf.setVisible(false);
		comboReplaceElementsConcat.setVisible(true);
		forceLayout();
	}

	private void removeConcat(ComboBox<ReplaceElement> source) {
		HBoxLayoutContainer horiz = (HBoxLayoutContainer) source.getParent();
		int index = vert.getWidgetIndex(horiz);
		Log.debug("No concat for index: " + index);
		index++;
		for (int i = index; i < vert.getWidgetCount();) {
			Log.debug("Remove horiz index: " + i);
			vert.remove(i);
		}
	}

	private boolean existConcat(ComboBox<ReplaceElement> source) {
		boolean exist = false;
		HBoxLayoutContainer horiz = (HBoxLayoutContainer) source.getParent();
		int index = vert.getWidgetIndex(horiz);
		Log.debug("No concat for index: " + index);
		index++;
		if (index < vert.getWidgetCount()) {
			exist = true;
		} else {
			exist = false;
		}
		return exist;
	}

	public C_Expression getExpression() throws ReplaceTypeMapException {
		ExpressionContainer expressionContainer = null;
		readableExpression = new String();
		C_Expression expression = null;

		if (vert.getWidgetCount() > 0) {
			int index = 0;
			expressionContainer = calcCExpression(index);
			if (expressionContainer != null) {
				readableExpression = expressionContainer
						.getReadableExpression();
				expression = expressionContainer.getExpression();
			} else {

			}
		}

		Log.debug("ReadableExpression: " + readableExpression);
		Log.debug("C_Expression:" + expression);
		return expression;
	}

	public String getReadableExpression() {
		return readableExpression;
	}

	protected ExpressionContainer calcCExpression(int index)
			throws ReplaceTypeMapException {
		ExpressionContainer expressionContainer = null;
		ExpressionContainer expContainerConcat = null;
		C_Expression exp = null;
		C_Expression expLeaf = null;
		String readableExp = "";
		String readableExpLeaf = "";
		TextField firstArg;
		TextField secondArg;
		HBoxLayoutContainer horiz;
		ReplaceTypeMap mapReplace = new ReplaceTypeMap();

		horiz = (HBoxLayoutContainer) vert.getWidget(index);
		@SuppressWarnings("unchecked")
		ComboBox<ReplaceElement> comboConcat = (ComboBox<ReplaceElement>) horiz
				.getItemByItemId(itemIdComboConcat);
		Log.debug("combo Concat: " + comboConcat.getCurrentValue());
		@SuppressWarnings("unchecked")
		ComboBox<ReplaceElement> comboLeaf = (ComboBox<ReplaceElement>) horiz
				.getItemByItemId(itemIdComboLeaf);
		Log.debug("combo Leaf: " + comboLeaf.getCurrentValue());

		@SuppressWarnings("unchecked")
		ComboBox<ColumnData> comboColumns = (ComboBox<ColumnData>) horiz
				.getItemByItemId(itemIdComboColumns);
		Log.debug("combo columns: " + comboColumns.getCurrentValue());
		ColumnData column = comboColumns.getCurrentValue();

		firstArg = (TextField) horiz.getItemByItemId(itemIdFirstArg);
		secondArg = (TextField) horiz.getItemByItemId(itemIdSecondArg);
		Log.debug("[column: " + column + ", firstArg: "
				+ firstArg.getCurrentValue() + ", secondArg: "
				+ secondArg.getCurrentValue() + "]");

		ReplaceType comboConcatReplaceType = null;
		ReplaceType comboLeafReplaceType = null;

		if (comboConcat.getCurrentValue() == null) {
			if (index == vert.getWidgetCount() - 1) {
				switch (replaceColumnByExpressionType) {
				case Replace:
					exp = mapReplace.map(
							column,
							ReplaceType.Null,
							firstArg == null ? null : firstArg
									.getCurrentValue(),
							secondArg == null ? null : secondArg
									.getCurrentValue(), false);
					break;
				case Template:
					exp = mapReplace.map(
							column,
							ReplaceType.Null,
							firstArg == null ? null : firstArg
									.getCurrentValue(),
							secondArg == null ? null : secondArg
									.getCurrentValue(), true);
					break;
				default:
					exp = mapReplace.map(
							column,
							ReplaceType.Null,
							firstArg == null ? null : firstArg
									.getCurrentValue(),
							secondArg == null ? null : secondArg
									.getCurrentValue(), false);
					break;

				}
				readableExp = mapReplace.getReadableExpression();
				expressionContainer = new ExpressionContainer(exp, readableExp);

			} else {
				throw new ReplaceTypeMapException("Fill all field!");
			}
		} else {
			comboConcatReplaceType = comboConcat.getCurrentValue()
					.getReplaceType();
			if (comboConcatReplaceType.compareTo(ReplaceType.Concat) == 0) {

				if (comboLeaf.getCurrentValue() == null) {
					switch (replaceColumnByExpressionType) {
					case Replace:
						expLeaf = mapReplace.map(
								column,
								ReplaceType.Null,
								firstArg == null ? null : firstArg
										.getCurrentValue(),
								secondArg == null ? null : secondArg
										.getCurrentValue(), false);
						break;
					case Template:
						expLeaf = mapReplace.map(
								column,
								ReplaceType.Null,
								firstArg == null ? null : firstArg
										.getCurrentValue(),
								secondArg == null ? null : secondArg
										.getCurrentValue(), true);
						break;
					default:
						expLeaf = mapReplace.map(
								column,
								ReplaceType.Null,
								firstArg == null ? null : firstArg
										.getCurrentValue(),
								secondArg == null ? null : secondArg
										.getCurrentValue(), false);
						break;

					}

					readableExpLeaf = mapReplace.getReadableExpression();

				} else {
					comboLeafReplaceType = comboLeaf.getCurrentValue()
							.getReplaceType();
					switch (replaceColumnByExpressionType) {
					case Replace:
						expLeaf = mapReplace.map(
								column,
								comboLeafReplaceType,
								firstArg == null ? null : firstArg
										.getCurrentValue(),
								secondArg == null ? null : secondArg
										.getCurrentValue(), false);
						break;
					case Template:
						expLeaf = mapReplace.map(
								column,
								comboLeafReplaceType,
								firstArg == null ? null : firstArg
										.getCurrentValue(),
								secondArg == null ? null : secondArg
										.getCurrentValue(), true);
						break;
					default:
						expLeaf = mapReplace.map(
								column,
								comboLeafReplaceType,
								firstArg == null ? null : firstArg
										.getCurrentValue(),
								secondArg == null ? null : secondArg
										.getCurrentValue(), false);
						break;

					}

					readableExpLeaf = mapReplace.getReadableExpression();
				}

				index++;
				if (index < vert.getWidgetCount()) {
					expContainerConcat = calcCExpression(index);
					if (expContainerConcat == null) {
						return null;
					} else {
						switch (replaceColumnByExpressionType) {
						case Replace:
							exp = mapReplace.map(
									column,
									comboConcatReplaceType,
									firstArg == null ? null : firstArg
											.getCurrentValue(),
									secondArg == null ? null : secondArg
											.getCurrentValue(), false, expLeaf,
									expContainerConcat.getExpression(),
									readableExpLeaf, expContainerConcat
											.getReadableExpression());
							break;
						case Template:
							exp = mapReplace.map(
									column,
									comboConcatReplaceType,
									firstArg == null ? null : firstArg
											.getCurrentValue(),
									secondArg == null ? null : secondArg
											.getCurrentValue(), true, expLeaf,
									expContainerConcat.getExpression(),
									readableExpLeaf, expContainerConcat
											.getReadableExpression());
							break;
						default:
							exp = mapReplace.map(
									column,
									comboConcatReplaceType,
									firstArg == null ? null : firstArg
											.getCurrentValue(),
									secondArg == null ? null : secondArg
											.getCurrentValue(), false, expLeaf,
									expContainerConcat.getExpression(),
									readableExpLeaf, expContainerConcat
											.getReadableExpression());
							break;
						
						}
						readableExp = mapReplace.getReadableExpression();
						expressionContainer = new ExpressionContainer(exp,
								readableExp);
					}
				} else {
					return null;
				}

			} else {
				switch (replaceColumnByExpressionType) {
				case Replace:
					exp = mapReplace.map(column, comboConcatReplaceType,
							firstArg == null ? null : firstArg.getCurrentValue(),
							secondArg == null ? null : secondArg.getCurrentValue(),
							false);
					break;
				case Template:
					exp = mapReplace.map(column, comboConcatReplaceType,
							firstArg == null ? null : firstArg.getCurrentValue(),
							secondArg == null ? null : secondArg.getCurrentValue(),
							true);
					break;
				default:
					exp = mapReplace.map(column, comboConcatReplaceType,
							firstArg == null ? null : firstArg.getCurrentValue(),
							secondArg == null ? null : secondArg.getCurrentValue(),
							false);
					break;
				
				}
				readableExp = mapReplace.getReadableExpression();
				expressionContainer = new ExpressionContainer(exp, readableExp);

			}
		}
		return expressionContainer;

	}
}
