package org.gcube.portlets.user.td.expressionwidget.shared.model.composite.comparable;

import org.gcube.portlets.user.td.expressionwidget.shared.model.C_OperatorType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class C_Equals extends C_Expression {
	protected String id="Equals";
	
	private static final long serialVersionUID = 3154667914317692836L;
	protected C_Expression leftArgument;
	protected C_Expression rightArgument;

	public C_Equals() {
		
	}
	
	public C_Equals(C_Expression leftArgument, C_Expression rightArgument) {
		this.leftArgument = leftArgument;
		this.rightArgument = rightArgument;
	}

	public C_OperatorType getOperator() {
		return C_OperatorType.EQUALS;
	}
	
	public String getReturnedDataType() {
		return "Boolean";
	}
	
	
	@Override
	public String getId() {
		return id;
	}


	public C_Expression getLeftArgument() {
		return leftArgument;
	}

	public void setLeftArgument(C_Expression leftArgument) {
		this.leftArgument = leftArgument;
	}

	public C_Expression getRightArgument() {
		return rightArgument;
	}

	public void setRightArgument(C_Expression rightArgument) {
		this.rightArgument = rightArgument;
	}

	@Override
	public String toString() {
		return "Equals [id=" + id + ", leftArgument=" + leftArgument
				+ ", rightArgument=" + rightArgument + "]";
	}
	
	

}