package org.gcube.portlets.user.td.expressionwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.client.type.ReplaceColumnByExpressionType;
import org.gcube.portlets.user.td.expressionwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsFinalException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTIsLockedException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialog;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialogListener;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceColumnByExpressionDialog extends Window implements
		MonitorDialogListener {
	private static final String WIDTH = "880px";
	private static final String HEIGHT = "490px";
	private static final String HEIGHT_REDUCE = "404px";

	private ReplaceColumnByExpressionPanel replaceColumnByExpressionPanel;
	private C_Expression cConditionExpression = null;
	
	private ColumnData column = null;
	private ArrayList<ColumnData> columns;
	
	//private String columnName = null;
	private EventBus eventBus;
	private ReplaceColumnByExpressionType replaceColumnByExpressionType;

	/**
	 * 
	 * Columns must have set columnId, label, columnTypeCode and ColumnDataType
	 * 
	 * @param column
	 *            The column selected
	 * @param columns
	 * @param eventBus
	 */
	public ReplaceColumnByExpressionDialog(ColumnData column,
			ArrayList<ColumnData> columns, EventBus eventBus) {
		this.eventBus = eventBus;
		this.column = column;
		this.columns = columns;
		replaceColumnByExpressionType = ReplaceColumnByExpressionType.Template;
		initWindow();
		create();

	}

	/**
	 * 
	 * @param trId
	 * @param columnName
	 * @param eventBus
	 */
	public ReplaceColumnByExpressionDialog(TRId trId, String columnName,
			EventBus eventBus) {
		this.eventBus = eventBus;
		replaceColumnByExpressionType = ReplaceColumnByExpressionType.Replace;
		initWindow();
		load(trId, columnName);

	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Replace Column By Expression");
		setClosable(true);
		getHeader().setIcon(
				ExpressionResources.INSTANCE.columnReplaceByExpression());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void create() {
		if (column == null) {
			UtilsGXT3.info("Attention ",
					"You must select a column!");
			hide();
			return;
		}

		if (column.isViewColumn()) {
			UtilsGXT3.info("Attention is View Column",
					"You can not make expressions on view column for now!");
			hide();
			return;
		}

		if (column.getDataTypeName().compareTo(ColumnDataType.Text.toString()) == 0) {
			setHeight(HEIGHT);
		} else {
			setHeight(HEIGHT_REDUCE);
		}

		if (column.getTypeCode()
				.compareTo(ColumnTypeCode.ANNOTATION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.ATTRIBUTE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODEDESCRIPTION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODENAME.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.MEASURE.toString()) == 0) {
			switch (replaceColumnByExpressionType) {
			case Replace:
				replaceColumnByExpressionPanel = new ReplaceColumnByExpressionPanel(
						this, column, eventBus);
				break;
			case Template:
				replaceColumnByExpressionPanel = new ReplaceColumnByExpressionPanel(
						this, column, columns, eventBus);

				break;
			default:
				break;
			}

			add(replaceColumnByExpressionPanel);

		} else {
			HTML errorMessage = new HTML(
					"This type of column is not supported for now!");
			add(errorMessage);
			UtilsGXT3.alert("Error",
					"This type of column is not supported for now!");
		}
	}

	public C_Expression getExpression() {
		return cConditionExpression;
	}

	protected void setExpression(C_Expression exp) {
		Log.debug("New Expression set:" + exp.toString());
		this.cConditionExpression = exp;
	}

	protected void applyReplaceColumnByExpression(
			C_Expression cConditionExpression, String replaceValue) {
		this.cConditionExpression = cConditionExpression;
		

		ReplaceColumnByExpressionSession replaceColumnByExpressionSession = new ReplaceColumnByExpressionSession(
				column, cConditionExpression, replaceValue);
		callApplyReplaceByExpression(replaceColumnByExpressionSession);
	}

	protected void applyReplaceColumnByExpression(
			C_Expression cConditionExpression, C_Expression cReplaceExpression) {
		this.cConditionExpression = cConditionExpression;
		//this.cReplaceExpression = cReplaceExpression;
		ReplaceColumnByExpressionSession replaceColumnByExpressionSession = new ReplaceColumnByExpressionSession(
				column, cConditionExpression, cReplaceExpression);
		callApplyReplaceByExpression(replaceColumnByExpressionSession);
	}

	protected void load(TRId trId, String columnName) {
		TDGWTServiceAsync.INSTANCE.getColumn(trId, columnName,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								Log.error("Error retrieving column: "
										+ caught.getMessage());
								UtilsGXT3.alert("Error retrieving column",
										caught.getMessage());
							}
						}
					}

					public void onSuccess(ColumnData result) {
						Log.debug("Retrived column: " + result);
						column = result;
						create();

					}

				});

	}

	protected void callApplyReplaceByExpression(
			ReplaceColumnByExpressionSession replaceColumnByExpressionSession) {
		Log.debug("Replace Column By Expression Session "
				+ replaceColumnByExpressionSession);

		ExpressionServiceAsync.INSTANCE.startReplaceColumnByExpression(
				replaceColumnByExpressionSession, new AsyncCallback<String>() {

					@Override
					public void onSuccess(String taskId) {
						Log.debug("Submitted replace column by expression");
						openMonitorDialog(taskId);

					}

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							if (caught instanceof TDGWTIsLockedException) {
								Log.error(caught.getLocalizedMessage());
								UtilsGXT3.alert("Error Locked",
										caught.getLocalizedMessage());
							} else {
								if (caught instanceof TDGWTIsFinalException) {
									Log.error(caught.getLocalizedMessage());
									UtilsGXT3.alert("Error Final",
											caught.getLocalizedMessage());
								} else {
									Log.error("Error submitting replace column by expression: "
											+ caught.getLocalizedMessage());
									caught.printStackTrace();
									UtilsGXT3
											.alert("Error submitting replace column by expression",
													caught.getLocalizedMessage());
								}
							}
						}

					}
				});

	}

	protected void close() {
		hide();
	}

	// /
	protected void openMonitorDialog(String taskId) {
		MonitorDialog monitorDialog = new MonitorDialog(taskId, eventBus);
		monitorDialog.addProgressDialogListener(this);
		monitorDialog.show();
	}

	@Override
	public void operationComplete(TRId trId) {
		ChangeTableWhy why = ChangeTableWhy.TABLEUPDATED;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.COLUMNFILTER, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();
	}

	@Override
	public void operationFailed(Throwable caught, String reason, String details) {
		UtilsGXT3.alert(reason, details);
		close();

	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.COLUMNFILTER, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();

	}

	@Override
	public void operationAborted() {
		close();

	}

	@Override
	public void operationPutInBackground() {
		close();

	}

}
