package org.gcube.portlets.user.td.expressionwidget.client;

import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialog;
import org.gcube.portlets.user.td.monitorwidget.client.MonitorDialogListener;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnDataType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.column.ColumnTypeCode;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ColumnFilterDialog extends Window implements MonitorDialogListener {
	protected String WIDTH = "660px";
	protected String HEIGHT = "400px";
	protected ColumnExpressionPanel columnExpressionPanel;
	protected C_Expression exp = null;
	protected ColumnData column = null;
	protected TRId trId;
	protected String columnName = null;
	protected EventBus eventBus;
	private FilterColumnSession filterColumnSession;

	public ColumnFilterDialog(String columnId, ColumnTypeCode columnTypeCode,
			ColumnDataType dataTypeName, EventBus eventBus) {
		initWindow();
		this.eventBus = eventBus;
		column = new ColumnData();
		column.setColumnId(columnId);
		column.setDataTypeName(dataTypeName.toString());
		column.setTypeCode(columnTypeCode.toString());
		create();

	}

	public ColumnFilterDialog(TRId trId, String columnName, EventBus eventBus) {
		initWindow();
		this.eventBus = eventBus;
		this.trId = trId;
		this.columnName = columnName;
		load(trId, columnName);

	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("New Filter");
		setClosable(true);
		getHeader().setIcon(ExpressionResources.INSTANCE.filter());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void create() {
		if (column.getTypeCode()
				.compareTo(ColumnTypeCode.ANNOTATION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.ATTRIBUTE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODE.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODEDESCRIPTION.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.CODENAME.toString()) == 0
				|| column.getTypeCode().compareTo(
						ColumnTypeCode.MEASURE.toString()) == 0) {
			columnExpressionPanel = new ColumnExpressionPanel(this, column,
					eventBus);
			add(columnExpressionPanel);

		} else {
			HTML errorMessage = new HTML(
					"This type of column is not supported for now!");
			add(errorMessage);
			UtilsGXT3.alert("Error",
					"This type of column is not supported for now!");
		}
	}

	public C_Expression getExpression() {
		return exp;
	}

	protected void setExpression(C_Expression exp) {
		Log.debug("New Expression set:" + exp.toString());
		this.exp = exp;
	}

	protected void applyFilter(C_Expression exp) {
		this.exp = exp;
		callApplyFilter();
	}

	protected void load(TRId trId, String columnName) {
		TDGWTServiceAsync.INSTANCE.getColumn(trId, columnName,
				new AsyncCallback<ColumnData>() {

					public void onFailure(Throwable caught) {
						Log.error("Error retrieving column: "
								+ caught.getMessage());
						UtilsGXT3.alert("Error retrieving column",
								caught.getMessage());
					}

					public void onSuccess(ColumnData result) {
						Log.debug("Retrived column: " + result);
						if (result.isViewColumn()) {
							UtilsGXT3
									.info("View Column",
											"You can not make expressions on view column for now");
							hide();
						} else {
							column = result;
							create();
						}
					}

				});

	}

	protected void callApplyFilter() {
		filterColumnSession = new FilterColumnSession(column, exp);
		Log.debug(filterColumnSession.toString());

		ExpressionServiceAsync.INSTANCE.startFilterColumn(filterColumnSession,
				new AsyncCallback<String>() {

					@Override
					public void onSuccess(String taskId) {
						Log.debug("Submitted column filter");
						openMonitorDialog(taskId);

					}

					@Override
					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("Error submitting the column filter: "
									+ caught.getLocalizedMessage());
							caught.printStackTrace();
							UtilsGXT3.alert(
									"Error submitting the column filter",
									caught.getLocalizedMessage());
						}

					}
				});

	}

	protected void close() {
		hide();
	}

	// /
	protected void openMonitorDialog(String taskId) {
		MonitorDialog monitorDialog = new MonitorDialog(taskId, eventBus);
		monitorDialog.addProgressDialogListener(this);
		monitorDialog.show();
	}

	@Override
	public void operationComplete(TRId trId) {
		ChangeTableWhy why = ChangeTableWhy.TABLEUPDATED;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.COLUMNFILTER, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();
	}

	@Override
	public void operationFailed(Throwable caught, String reason, String details) {
		UtilsGXT3.alert(reason, details);
		close();

	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.COLUMNFILTER, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		close();

	}

	@Override
	public void operationAborted() {
		close();

	}

	@Override
	public void operationPutInBackground() {
		close();

	}

}
