package org.gcube.portlets.user.td.expressionwidget.server;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.data.analysis.tabulardata.service.impl.TabularDataServiceFactory;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionService;
import org.gcube.portlets.user.td.expressionwidget.shared.exception.ExpressionServiceException;
import org.gcube.portlets.user.td.gwtservice.server.SessionUtil;
import org.gcube.portlets.user.td.gwtservice.server.TDGWTServiceImpl;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.OperationsId;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.FilterColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class ExpressionServiceImpl extends RemoteServiceServlet implements
		ExpressionService {

	private static final long serialVersionUID = 4632292751581364137L;

	protected static Logger logger = LoggerFactory
			.getLogger(ExpressionServiceImpl.class);

	protected static SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm");

	

	/**
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public String startFilterColumn(FilterColumnSession filterColumnSession)
			throws TDGWTServiceException {

		try {
			logger.debug("ExpressionService submitColumnFilter");
			HttpSession session = this.getThreadLocalRequest().getSession();
			logger.debug("Session: "+session);
			
			if(filterColumnSession==null){
				logger.error("FilterColumnSession is null");
				new ExpressionServiceException("FilterColumnSession is null");
			}
			ExpressionSession.setColumnFilterSession(session, filterColumnSession);
			
			C_ExpressionParser parser=new C_ExpressionParser();
			Expression expression=parser.parse(filterColumnSession.getCexpression());
			logger.debug("Service Expression:"+expression);
			
			
			TDGWTServiceImpl gwtService = new TDGWTServiceImpl();
			
			String taskId= gwtService.startFilterColumn(filterColumnSession, expression, session);
			
			return taskId;
		
		} catch (TDGWTSessionExpiredException e){
			throw e;
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Error in Client Library Request: "
							+ e.getLocalizedMessage());
		}
	}

//	/**
//	 * {@inheritDoc}
//	 */
//	public ColumnFilterMonitor getColumnFilterMonitor()
//			throws ExpressionServiceException {
//		try {
//			HttpSession session = this.getThreadLocalRequest().getSession();
//			FilterColumnSession columnFilterSession = ExpressionSession
//					.getColumnFilterSession(session);
//
//			Task task = ExpressionSession.getColumnFilterTask(session);
//			ColumnFilterMonitor columnFilterMonitor = new ColumnFilterMonitor();
//
//			if (task == null) {
//				logger.debug("Task null");
//				throw new ExpressionServiceException(
//						"Error in ColumnFilter task null");
//			} else {
//				TaskStatus status = task.getStatus();
//				if (status == null) {
//					logger.debug("Services TaskStatus : null");
//					throw new ExpressionServiceException(
//							"Error in ColumnFilter Status null");
//				} else {
//					logger.debug("Services TaskStatus: " + task.getStatus());
//
//					columnFilterMonitor.setStatus(TaskStateMap.map(task
//							.getStatus()));
//					switch (columnFilterMonitor.getStatus()) {
//					case FAILED:
//						if (task.getResult() != null) {
//							logger.debug("Task exception:"
//									+ task.getErrorCause());
//							task.getErrorCause().printStackTrace();
//							columnFilterMonitor.setError(new Throwable(task
//									.getErrorCause()));
//						} else {
//							logger.debug("Task exception: Error In Column Filter");
//							columnFilterMonitor.setError(new Throwable(
//									"Error In Column Filter"));
//						}
//						columnFilterMonitor.setProgress(task.getProgress());
//						break;
//					case SUCCEDED:
//						logger.debug("Task Result:" + task.getResult());
//						columnFilterMonitor.setProgress(task.getProgress());
//						Table table = task.getResult().getPrimaryTable();
//						logger.debug("Table retrived: " + table.toString());
//						TRId trId = new TRId();
//						trId.setId(columnFilterSession.getColumn().getTrId()
//								.getId());
//						
//						trId = retrieveTabularResourceBasicData(trId);
//						
//						columnFilterMonitor.setTrId(trId);
//						TabResource tabResource = SessionUtil
//								.getTabResource(session);
//						tabResource.setTrId(trId);
//						SessionUtil.setTabResource(session, tabResource);
//						SessionUtil.setTRId(session, trId);
//						break;
//					case IN_PROGRESS:
//						columnFilterMonitor.setProgress(task.getProgress());
//						break;
//					case VALIDATING_RULES:
//						columnFilterMonitor.setProgress(task.getProgress());
//						break;
//					case GENERATING_VIEW:
//						break;	
//					case ABORTED:
//						break;
//					case STOPPED:
//						logger.debug("Task Result:" + task.getResult());
//						columnFilterMonitor.setProgress(task.getProgress());
//						trId = new TRId();
//						trId.setId(columnFilterSession.getColumn().getTrId()
//								.getId());
//						trId = retrieveTabularResourceBasicData(trId);
//
//						columnFilterMonitor.setTrId(trId);
//						tabResource = SessionUtil.getTabResource(session);
//						tabResource.setTrId(trId);
//						SessionUtil.setTabResource(session, tabResource);
//						SessionUtil.setTRId(session, trId);
//						break;
//					case INITIALIZING:
//						break;
//					default:
//						break;
//					}
//				}
//				ExpressionSession.setColumnFilterTask(session, task);
//			}
//
//			logger.info("ColumnFilterMonitor(): " + columnFilterMonitor);
//			return columnFilterMonitor;
//		} catch (TDGWTSessionExpiredException e){
//			throw new ExpressionServiceException(e.getLocalizedMessage());
//		} catch (Throwable e) {
//			e.printStackTrace();
//			throw new ExpressionServiceException(
//					"Error applying column filter: " + e.getLocalizedMessage());
//
//		}
//
//	}
	
	
	/**
	 * Retrieve and set Tabular Resource Type
	 * 
	 * @param trId
	 * @return
	 * @throws TDGWTServiceException
	 */
	protected TRId retrieveTabularResourceBasicData(TRId trId)
			throws TDGWTServiceException {
		try {
			HttpSession session = this.getThreadLocalRequest().getSession();
			ASLSession aslSession = SessionUtil.getAslSession(session);

			AuthorizationProvider.instance.set(new AuthorizationToken(
					aslSession.getUsername(), aslSession.getScope()));
			TabularDataService service = TabularDataServiceFactory.getService();
			TabularResourceId tabularResourceId = new TabularResourceId(
					new Long(trId.getId()));

			TabularResource tr = service.getTabularResource(tabularResourceId);
			Table table = service.getLastTable(tabularResourceId);

			Table viewTable = null;

			if (table.contains(DatasetViewTableMetadata.class)) {
				DatasetViewTableMetadata dwm = table
						.getMetadata(DatasetViewTableMetadata.class);
				try {
					viewTable = service.getTable(dwm
							.getTargetDatasetViewTableId());
				} catch (Exception e) {
					logger.error("view table not found");
				}
			}

			TRId newTRId;
			if (viewTable == null) {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(table.getId()
								.getValue()), table.getTableType().getName());

			} else {
				newTRId = new TRId(String.valueOf(tr.getId().getValue()),
						tr.getTableType(), String.valueOf(viewTable.getId()
								.getValue()), viewTable.getTableType()
								.getName(), String.valueOf(table.getId()
								.getValue()), true);

			}

			logger.debug("Retrieved TRId basic info:" + newTRId.toString());
			return newTRId;

		} catch (TDGWTSessionExpiredException e) {
			throw e;
		} catch (SecurityException e) {
			e.printStackTrace();
			throw new TDGWTServiceException(
					"Security exception, you haven't rights!");
		} catch (Throwable e) {
			e.printStackTrace();
			throw new TDGWTServiceException("Error in Client Library Request: "
					+ e.getLocalizedMessage());
		}
	}

}