/**
 * 
 */
package org.gcube.portlets.user.td.expressionwidget.client.rpc;



import org.gcube.portlets.user.td.expressionwidget.shared.exception.ExpressionServiceException;
import org.gcube.portlets.user.td.expressionwidget.shared.session.ColumnFilterMonitor;
import org.gcube.portlets.user.td.expressionwidget.shared.session.ColumnFilterSession;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * 
 * Implements the basic interfaces generate and submit Expression on service.
 * 
 * <p>
 * Allows:  
 * <ul>
 * <li>Generate Expression</li>
 * <ul>
 * </p>
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
@RemoteServiceRelativePath("ExpressionService")
public interface ExpressionService extends RemoteService {

	/**
	 * Submit Column Filter Operation
	 * 
	 * @param columnFilterSession
	 * @throws ExpressionServiceException
	 */
	public void submitColumnFilter(ColumnFilterSession columnFilterSession) throws ExpressionServiceException;
	
	/**
	 * Get Operation Monitor during the applying Column Filter operation
	 * 
	 * 
	 * @return
	 * @throws ExpressionServiceException
	 */
	public ColumnFilterMonitor getColumnFilterMonitor()
			throws ExpressionServiceException;

	

}
