package org.gcube.portlets.user.td.expressionwidget.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.gcube.portlets.user.td.expressionwidget.client.custom.IconButton;
import org.gcube.portlets.user.td.expressionwidget.client.operation.Operation;
import org.gcube.portlets.user.td.expressionwidget.client.operation.OperationProperties;
import org.gcube.portlets.user.td.expressionwidget.client.operation.OperationsStore;
import org.gcube.portlets.user.td.expressionwidget.client.resources.ExpressionResources;
import org.gcube.portlets.user.td.expressionwidget.shared.model.OperatorTypeMap;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.core.client.util.ToggleGroup;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.BeforeShowEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.DateField;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.Radio;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ConditionWidget extends SimpleContainer {

	private ConditionWidget thisCont;
	protected static final String HEIGHT = "210px";
	protected static final String WIDTH = "612px";
	protected FieldLabel matchLabel;
	protected ToggleGroup groupMatch;

	protected String itemIdCombo;
	protected String itemIdFirstArg;
	protected String itemIdSecondArg;
	protected String itemIdFirstArgDate;
	protected String itemIdSecondArgDate;
	protected String itemIdBtnAdd;
	protected String itemIdBtnDel;
	protected VerticalLayoutContainer vert;
	protected ColumnData column;

	protected String readableExpression;

	public ConditionWidget(ColumnData column) {
		super();
		create(column, WIDTH, HEIGHT);
	}

	public ConditionWidget(ColumnData column, String width, String height) {
		super();
		create(column, width, height);
	}

	protected void create(ColumnData column, String width, String height) {
		this.column = column;
		setBorders(true);
		setWidth(width);
		setHeight(height);
		forceLayoutOnResize = true;

		thisCont = this;

		itemIdCombo = "ComboConditions" + column.getName();
		itemIdFirstArg = "FirstArg" + column.getName();
		itemIdSecondArg = "SecondArg" + column.getName();
		itemIdFirstArgDate = "FirstArgDate" + column.getName();
		itemIdSecondArgDate = "SecondArgDate" + column.getName();
		itemIdBtnAdd = "BtnAdd" + column.getName();
		itemIdBtnDel = "BtnDel" + column.getName();

		VerticalLayoutContainer baseLayout = new VerticalLayoutContainer();

		Radio radioAll = new Radio();
		radioAll.setName("All");
		radioAll.setBoxLabel("All conditions");
		radioAll.setValue(true);

		Radio radioAny = new Radio();
		radioAny.setName("Any");
		radioAny.setBoxLabel("Any condition");

		HorizontalPanel matchPanel = new HorizontalPanel();
		matchPanel.add(radioAll);
		matchPanel.add(radioAny);

		matchLabel = new FieldLabel(matchPanel, "Match");
		matchLabel.setVisible(false);

		baseLayout.add(matchLabel, new VerticalLayoutData(-1, -1, new Margins(
				2, 1, 2, 1)));

		groupMatch = new ToggleGroup();
		groupMatch.add(radioAll);
		groupMatch.add(radioAny);
		groupMatch.setValue(radioAll);

		vert = new VerticalLayoutContainer();
		vert.setScrollMode(ScrollMode.AUTO);
		vert.setAdjustForScroll(true);

		setup();

		baseLayout.add(vert, new VerticalLayoutData(1, 1, new Margins(0)));

		add(baseLayout);

	}

	protected void setup() {
		final HBoxLayoutContainer horiz = new HBoxLayoutContainer();

		final TextField firstArg = new TextField();
		firstArg.setItemId(itemIdFirstArg);
		firstArg.setVisible(false);

		final DateField firstArgDate = new DateField();
		firstArgDate.setItemId(itemIdFirstArgDate);
		firstArgDate.setVisible(false);

		final HTML andText = new HTML(
				"<div style='vertical-align:middle; margin-left:2px;margin-right:2px;margin-top:4px;'>and</div>");
		andText.setVisible(false);

		final TextField secondArg = new TextField();
		secondArg.setItemId(itemIdSecondArg);
		secondArg.setVisible(false);

		final DateField secondArgDate = new DateField();
		secondArgDate.setItemId(itemIdSecondArgDate);
		secondArgDate.setVisible(false);

		final IconButton btnAdd = new IconButton();
		btnAdd.setItemId(itemIdBtnAdd);
		btnAdd.setIcon(ExpressionResources.INSTANCE.add());
		btnAdd.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				Log.debug("Clicked btnAdd");
				matchLabel.setVisible(true);
				addCondition();
				thisCont.forceLayout();
				vert.forceLayout();

			}
		});
		btnAdd.setVisible(false);

		final IconButton btnDel = new IconButton();
		btnDel.setItemId(itemIdBtnDel);
		btnDel.setIcon(ExpressionResources.INSTANCE.delete());
		btnDel.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				Log.debug("Clicked btnDel");
				vert.remove(horiz);
				if (vert.getWidgetCount() == 0) {
					setup();
					matchLabel.setVisible(false);
				} else {
					if (vert.getWidgetCount() == 1) {
						matchLabel.setVisible(false);
					}
				}
				thisCont.forceLayout();
				vert.forceLayout();

			}
		});
		btnDel.setVisible(false);

		OperationProperties props = GWT.create(OperationProperties.class);
		Log.debug("Props: " + props);
		ListStore<Operation> storeOp = new ListStore<Operation>(props.id());
		Log.debug("Store: " + storeOp);
		OperationsStore factory = new OperationsStore();
		storeOp.addAll(factory.getAll(column.getDataTypeName()));

		Log.debug("Store created");
		ComboBox<Operation> comboOp = new ComboBox<Operation>(storeOp,
				props.label());

		Log.debug("Combo created");

		comboOp.addSelectionHandler(new SelectionHandler<Operation>() {

			public void onSelection(SelectionEvent<Operation> event) {
				if (event.getSelectedItem() != null) {
					Operation op = event.getSelectedItem();
					Log.debug("Condition selected:" + op.toString());
					switch (op.getOperatorType()) {
					case EQUALS:
					case GREATER:
					case GREATER_OR_EQUALS:
					case LESSER:
					case LESSER_OR_EQUALS:
					case NOT_EQUALS:
					case NOT_GREATER:
					case NOT_LESSER:
					case BEGINS_WITH:
					case ENDS_WITH:
					case MATCH_REGEX:
					case CONTAINS:
					case NOT_BEGINS_WITH:
					case NOT_ENDS_WITH:
					case NOT_CONTAINS:
					case NOT_MATCH_REGEX:
					case IN:
					case NOT_IN:
						if (column.getDataTypeName().compareTo("Date") == 0) {
							firstArgDate.setVisible(true);
							andText.setVisible(false);
							secondArgDate.setVisible(false);
						} else {
							firstArg.setVisible(true);
							andText.setVisible(false);
							secondArg.setVisible(false);
						}
						btnAdd.setVisible(true);
						btnDel.setVisible(true);
						break;
					case BETWEEN:
					case NOT_BETWEEN:
						if (column.getDataTypeName().compareTo("Date") == 0) {
							firstArgDate.setVisible(false);
							andText.setVisible(false);
							secondArgDate.setVisible(false);
						} else {
							firstArg.setVisible(true);
							andText.setVisible(true);
							secondArg.setVisible(true);
						}
						btnAdd.setVisible(true);
						btnDel.setVisible(true);
						break;
					case IS_NULL:
					case IS_NOT_NULL:
						if (column.getDataTypeName().compareTo("Date") == 0) {
							firstArgDate.setVisible(false);
							andText.setVisible(false);
							secondArgDate.setVisible(false);
						} else {
							firstArg.setVisible(false);
							andText.setVisible(false);
							secondArg.setVisible(false);
						}
						btnAdd.setVisible(true);
						btnDel.setVisible(true);
						break;
					default:
						break;
					}

					thisCont.forceLayout();

				}
			}

		});

		comboOp.setEmptyText("Select a condition...");
		comboOp.setItemId(itemIdCombo);
		comboOp.setWidth("230px");
		comboOp.setEditable(false);
		comboOp.setTriggerAction(TriggerAction.ALL);

		horiz.add(comboOp, new BoxLayoutData(new Margins(0)));
		if (column.getDataTypeName().compareTo("Date") == 0) {
			horiz.add(firstArgDate, new BoxLayoutData(new Margins(0)));
			horiz.add(andText, new BoxLayoutData(new Margins(0)));
			horiz.add(secondArgDate, new BoxLayoutData(new Margins(0)));
		} else {
			horiz.add(firstArg, new BoxLayoutData(new Margins(0)));
			horiz.add(andText, new BoxLayoutData(new Margins(0)));
			horiz.add(secondArg, new BoxLayoutData(new Margins(0)));
		}
		horiz.add(btnAdd, new BoxLayoutData(new Margins(2, 0, 2, 0)));
		horiz.add(btnDel, new BoxLayoutData(new Margins(2, 0, 2, 0)));

		vert.add(horiz, new VerticalLayoutData(-1, -1, new Margins(1)));

		addBeforeShowHandler(new BeforeShowEvent.BeforeShowHandler() {

			@Override
			public void onBeforeShow(BeforeShowEvent event) {
				forceLayout();

			}
		});

	}

	protected void addCondition() {
		final HBoxLayoutContainer horiz = new HBoxLayoutContainer();

		
		final TextField firstArg = new TextField();
		firstArg.setItemId(itemIdFirstArg);
		firstArg.setVisible(false);

		final DateField firstArgDate = new DateField();
		firstArgDate.setItemId(itemIdFirstArgDate);
		firstArgDate.setVisible(false);

		
		final HTML andText = new HTML(
				"<div style='vertical-align:middle; margin-left:2px;margin-right:2px;margin-top:4px;'>and</div>");
		andText.setVisible(false);

		final TextField secondArg = new TextField();
		secondArg.setItemId(itemIdSecondArg);
		secondArg.setVisible(false);

		final DateField secondArgDate = new DateField();
		secondArgDate.setItemId(itemIdSecondArgDate);
		secondArgDate.setVisible(false);

		final IconButton btnAdd = new IconButton();
		btnAdd.setItemId(itemIdBtnAdd);
		btnAdd.setIcon(ExpressionResources.INSTANCE.add());
		btnAdd.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				Log.debug("Clicked btnAdd");
				matchLabel.setVisible(true);
				addCondition();
				thisCont.forceLayout();
				vert.forceLayout();
			}
		});
		btnAdd.setVisible(false);

		final IconButton btnDel = new IconButton();
		btnAdd.setItemId(itemIdBtnDel);
		btnDel.setIcon(ExpressionResources.INSTANCE.delete());
		btnDel.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				Log.debug("Clicked btnDel");
				vert.remove(horiz);
				if (vert.getWidgetCount() == 0) {
					setup();
					matchLabel.setVisible(false);
				} else {
					if (vert.getWidgetCount() == 1) {
						matchLabel.setVisible(false);
					}
				}
				thisCont.forceLayout();
				vert.forceLayout();
			}
		});

		OperationProperties props = GWT.create(OperationProperties.class);
		Log.debug("Props: " + props);
		ListStore<Operation> storeOp = new ListStore<Operation>(props.id());
		Log.debug("Store: " + storeOp);
		OperationsStore factory = new OperationsStore();
		storeOp.addAll(factory.getAll(column.getDataTypeName()));

		Log.trace("Store created");

		final ComboBox<Operation> comboOp = new ComboBox<Operation>(storeOp,
				props.label());

		Log.trace("ComboOperation created");

		comboOp.addSelectionHandler(new SelectionHandler<Operation>() {

			public void onSelection(SelectionEvent<Operation> event) {
				if (event.getSelectedItem() != null) {
					Operation op = event.getSelectedItem();
					Log.debug("Condition selected:" + op.toString());
					switch (op.getOperatorType()) {
					case EQUALS:
					case GREATER:
					case GREATER_OR_EQUALS:
					case LESSER:
					case LESSER_OR_EQUALS:
					case NOT_EQUALS:
					case NOT_GREATER:
					case NOT_LESSER:
					case BEGINS_WITH:
					case ENDS_WITH:
					case MATCH_REGEX:
					case CONTAINS:
					case NOT_BEGINS_WITH:
					case NOT_ENDS_WITH:
					case NOT_CONTAINS:
					case NOT_MATCH_REGEX:
					case IN:
					case NOT_IN:
						if (column.getDataTypeName().compareTo("Date") == 0) {
							firstArgDate.setVisible(true);
							andText.setVisible(false);
							secondArgDate.setVisible(false);
						} else {
							firstArg.setVisible(true);
							andText.setVisible(false);
							secondArg.setVisible(false);
						}
						btnAdd.setVisible(true);
						btnDel.setVisible(true);
						break;
					case BETWEEN:
					case NOT_BETWEEN:
						if (column.getDataTypeName().compareTo("Date") == 0) {
							firstArgDate.setVisible(false);
							andText.setVisible(false);
							secondArgDate.setVisible(false);
						} else {
							firstArg.setVisible(true);
							andText.setVisible(true);
							secondArg.setVisible(true);
						}
						btnAdd.setVisible(true);
						btnDel.setVisible(true);
						break;
					case IS_NULL:
					case IS_NOT_NULL:
						if (column.getDataTypeName().compareTo("Date") == 0) {
							firstArgDate.setVisible(false);
							andText.setVisible(false);
							secondArgDate.setVisible(false);
						} else {
							firstArg.setVisible(false);
							andText.setVisible(false);
							secondArg.setVisible(false);
						}
						btnAdd.setVisible(true);
						btnDel.setVisible(true);
						break;
					default:
						break;
					}

					thisCont.forceLayout();

				}

			}

		});
		comboOp.setEmptyText("Select a condition...");
		comboOp.setItemId(itemIdCombo);
		comboOp.setWidth("230px");
		comboOp.setEditable(false);
		comboOp.setTriggerAction(TriggerAction.ALL);

		horiz.add(comboOp, new BoxLayoutData(new Margins(0)));
		if (column.getDataTypeName().compareTo("Date") == 0) {
			horiz.add(firstArgDate, new BoxLayoutData(new Margins(0)));
			horiz.add(andText, new BoxLayoutData(new Margins(0)));
			horiz.add(secondArgDate, new BoxLayoutData(new Margins(0)));
		} else {
			horiz.add(firstArg, new BoxLayoutData(new Margins(0)));
			horiz.add(andText, new BoxLayoutData(new Margins(0)));
			horiz.add(secondArg, new BoxLayoutData(new Margins(0)));
		}
		horiz.add(btnAdd, new BoxLayoutData(new Margins(2, 0, 2, 0)));
		horiz.add(btnDel, new BoxLayoutData(new Margins(2, 0, 2, 0)));

		vert.add(horiz, new VerticalLayoutData(-1, -1, new Margins(1)));

	}

	public C_Expression getExpression() {
		C_Expression exp = null;
		readableExpression = new String();
		List<C_Expression> arguments = new ArrayList<C_Expression>();
		List<String> readableExpressionList = new ArrayList<String>();
		TextField firstArg;
		TextField secondArg;
		DateField firstArgDate;
		DateField secondArgDate;
		C_Expression expression;
		// yyyy/MM/dd HH:mm:ss
		DateTimeFormat sdf = DateTimeFormat.getFormat("yyyy-MM-dd");
		
		OperatorTypeMap mapOp = new OperatorTypeMap();
		Iterator<Widget> iteratorVert = vert.iterator();
		HBoxLayoutContainer horiz;
		while (iteratorVert.hasNext()) {
			horiz = (HBoxLayoutContainer) iteratorVert.next();
			@SuppressWarnings("unchecked")
			ComboBox<Operation> comboOp = (ComboBox<Operation>) horiz
					.getItemByItemId(itemIdCombo);
			Log.debug("combo: " + comboOp.getCurrentValue().toString());

			if (column.getDataTypeName().compareTo("Date") == 0) {
				firstArgDate = (DateField) horiz
						.getItemByItemId(itemIdFirstArgDate);
				secondArgDate = (DateField) horiz
						.getItemByItemId(itemIdSecondArgDate);
				Log.debug("argLeft: " + firstArgDate + " argRight:"
						+  secondArgDate);
				Date firstDate=firstArgDate.getCurrentValue();
				Date secondDate=secondArgDate.getCurrentValue();
				expression = mapOp.map(
						column,
						comboOp.getCurrentValue().getOperatorType(),
						firstDate == null ? null : sdf.format(firstDate),
						secondDate == null ? null : sdf.format(secondDate));
			} else {

				firstArg = (TextField) horiz.getItemByItemId(itemIdFirstArg);
				secondArg = (TextField) horiz.getItemByItemId(itemIdSecondArg);
				Log.debug("argLeft: " + firstArg.getCurrentValue() + " argRight: " + secondArg.getCurrentValue());

				expression = mapOp.map(column, comboOp.getCurrentValue()
						.getOperatorType(),
						firstArg == null ? null : firstArg.getCurrentValue(),
						secondArg == null ? null : secondArg.getCurrentValue());
			}
			readableExpressionList.add(mapOp.getReadableExpression());
			Log.debug(expression.toString());
			arguments.add(expression);
		}
		Log.debug("Expression Arguments Calculated: " + arguments.size());
		if (arguments.size() > 0) {
			if (arguments.size() == 1) {
				exp = arguments.get(0);
				readableExpression = readableExpressionList.get(0);
			} else {
				Radio radio = (Radio) groupMatch.getValue();
				Log.debug("Match:" + radio);
				if (radio.getName().compareTo("All") == 0) {
					exp = mapOp.createC_And(arguments);
					readableExpression = "And(";
					boolean first = true;
					for (String read : readableExpressionList) {
						if (first) {
							readableExpression += read;
						} else {
							readableExpression += ", " + read;
						}
					}
					readableExpression += ")";

				} else {
					if (radio.getName().compareTo("Any") == 0) {
						exp = mapOp.createC_Or(arguments);
						readableExpression = "Or(";
						boolean first = true;
						for (String read : readableExpressionList) {
							if (first) {
								readableExpression += read;
							} else {
								readableExpression += ", " + read;
							}
						}
						readableExpression += ")";
					} else {
						Log.error("No All or Any set!");
					}
				}
			}

		}
		Log.debug("C_Expression:" + exp.toString());
		return exp;
	}

	public String getReadableExpression() {
		return readableExpression;
	}
}
