package org.gcube.portlets.user.td.expressionwidget.shared.model.logical;

import java.util.Arrays;
import java.util.List;

import org.gcube.portlets.user.td.expressionwidget.shared.model.C_OperatorType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.expression.C_Expression;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class C_And extends C_Expression {
	private static final long serialVersionUID = -4462616033767138280L;
	protected List<C_Expression> arguments;
	protected String id = "And";
	
	public C_And(){
		
	}
	
	public C_And(C_Expression... arguments) {
		this.arguments = Arrays.asList(arguments);
	}

	public C_And(List<C_Expression> arguments) {
		this.arguments = arguments;
	}

	public C_OperatorType getOperator() {
		return C_OperatorType.AND;
	}
	
	public String getReturnedDataType() {		
		return "Boolean";
	}

	public List<C_Expression> getArguments() {
		return arguments;
	}

	public void setArguments(List<C_Expression> arguments) {
		this.arguments = arguments;
	}
	
	@Override
	public String getId() {
		return id;
	}


	@Override
	public String toString() {
		return "C_And [arguments=" + arguments + ", id=" + id + "]";
	}
	
	
}
