/**
 * 
 */
package org.gcube.portlets.user.td.expressionwidget.client.progress;

import java.util.ArrayList;

import org.gcube.portlets.user.td.expressionwidget.client.rpc.ExpressionServiceAsync;
import org.gcube.portlets.user.td.expressionwidget.shared.session.ColumnFilterMonitor;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;


/**
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ColumnFilterProgressUpdater extends Timer {

	protected ArrayList<ColumnFilterProgressListener> listeners = new ArrayList<ColumnFilterProgressListener>();

	/**
	 * {@inheritDoc}
	 */ 
	@Override
	public void run() {
		Log.debug("requesting operation progress");
		ExpressionServiceAsync.INSTANCE
				.getColumnFilterMonitor(new AsyncCallback<ColumnFilterMonitor>() {

					
					public void onFailure(Throwable caught) {
						cancel();
						Log.error("Error retrieving the operation state",
								caught);
						String message = getStack(caught);
						fireOperationFailed(caught,
								"Failed getting operation updates", message);
					}

					public void onSuccess(ColumnFilterMonitor result) {
						Log.info("retrieved ColumnFilterMonitor: "
								+ result.getStatus());
						switch (result.getStatus()) {
						case INITIALIZING:
							Log.info("Column Filter Initializing...");
							fireOperationInitializing();
							break;
						case ABORTED:
							cancel();
							Log.info("Column Filter Operation Aborted");
							break;
						case IN_PROGRESS:
							fireOperationUpdate(result.getProgress());
							break;
						case VALIDATING_RULES:
							fireOperationValidate(result.getProgress());
							break;	
						case GENERATING_VIEW:
							Log.info("Generating View...");
							fireOperationGeneratingView();
							break;		
						case STOPPED:
							cancel();
							stopMessage(result);
							break;		
						case FAILED:
							cancel();
							errorMessage(result);
							break;
						case SUCCEDED:
							cancel();
							Log.info("Column Filter fisnish TableId :"
									+ result.getTrId());
							fireOperationComplete(result.getTrId());
							break;
						default:
							Log.info("Unknow State");
							break;
						}

					}

					

				});

	}

	protected void errorMessage(ColumnFilterMonitor result) {
		Log.info("Apply column filter failed");
		Throwable th = null;
		String failure = null;
		String details = null;
		if (result.getError() != null) {
			th = result.getError();
			failure = "Failed Client Library applying column filter";
			details = result.getError().getLocalizedMessage();
		} else {
			th = new Throwable("Failed");
			failure = "Failed Client Library applying column filter";
			details = "Apply column filter failed";
		}
		
	
		fireOperationFailed(th, failure, details);
	}
	
	protected void stopMessage(ColumnFilterMonitor result) {
		Log.info("Apply column filter Stopped");
		String failure = null;
		String details = null;
		if (result.getError() != null) {	
			failure = "Stopped";
			details = result.getError().getLocalizedMessage();
		} else {
			failure = "Stopped";
			details = "Stopped applying the column filter ";
		}
	
		fireOperationStopped(result.getTrId(),failure, details);
	}
	

	protected String getStack(Throwable e) {
		String message = e.getLocalizedMessage() + " -> <br>";
		Throwable c = e.getCause();
		if (c != null)
			message += getStack(c);
		return message;
	}

	protected void fireOperationInitializing() {
		for (ColumnFilterProgressListener listener : listeners)
			listener.operationInitializing();
	}
	
	protected void fireOperationGeneratingView() {
		for (ColumnFilterProgressListener listener : listeners)
			listener.operationGeneratingView();
	}

	protected void fireOperationUpdate(float elaborated) {
		for (ColumnFilterProgressListener listener : listeners)
			listener.operationUpdate(elaborated);
	}
	
	protected void fireOperationValidate(float elaborated) {
		for (ColumnFilterProgressListener listener : listeners)
			listener.operationValidate(elaborated);
	}
	

	protected void fireOperationComplete(TRId trId) {
		for (ColumnFilterProgressListener listener : listeners)
			listener.operationComplete(trId);
	}

	protected void fireOperationFailed(Throwable caught, String failure,
			String failureDetails) {
		for (ColumnFilterProgressListener listener : listeners)
			listener.operationFailed(caught, failure, failureDetails);
	}

	protected void fireOperationStopped(TRId trId, String reason, String details) {
		for (ColumnFilterProgressListener listener : listeners)
			listener.operationStopped(trId,reason, details);
	}
	/**
	 * Add a new {@link ColumnFilterProgressListener} to this
	 * {@link ColumnFilterProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to add.
	 */
	public void addListener(ColumnFilterProgressListener listener) {
		listeners.add(listener);
	}

	/**
	 * Removes the specified {@link ColumnFilterProgressListener} from this
	 * {@link ColumnFilterProgressUpdater}.
	 * 
	 * @param listener
	 *            the listener to remove.
	 */
	public void removeListener(ColumnFilterProgressListener listener) {
		listeners.remove(listener);
	}
	

}
