package org.gcube.portlets.user.td.columnwidget.client.mapping;

import org.gcube.portlets.user.td.columnwidget.client.custom.IconButton;
import org.gcube.portlets.user.td.columnwidget.client.dimension.DimensionRowSelectionListener;
import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.DimensionRow;
import org.gcube.portlets.user.td.gwtservice.shared.tr.TabResource;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.form.TextField;

/**
 * 
 * @author "Giancarlo Panichi"
 * email: <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class ColumnMappingPanel extends FramedPanel implements
		DimensionRowSelectionListener {
	protected String WIDTH = "560px";
	protected String HEIGHT = "520px";
	
	protected ColumnMappingPanel thisPanel;
	
	protected ColumnMappingDialog parent;
	protected TRId trId;
	protected ColumnData selectedColumn;
	protected TabResource dimensionTR;
	protected ColumnData columnReference;
	protected EventBus eventBus;
	
	protected VerticalLayoutContainer vert;
	protected String itemIdSourceValueArg;
	protected String itemIdTargetValueArg;
	protected String itemIdBtnAdd;
	protected String itemIdBtnDel;
	
	protected ColumnMappingList columnMappingList;
	
	/**
	 * 
	 * 
	 * @param parent
	 * @param trId
	 * @param selectedColumn
	 * @param dimensionTR
	 * @param columnReference
	 * @param eventBus
	 */
	public ColumnMappingPanel(ColumnMappingDialog parent, TRId trId,
			ColumnData selectedColumn, TabResource dimensionTR,
			ColumnData columnReference, EventBus eventBus) {
		this.parent = parent;
		this.trId = trId;
		this.selectedColumn = selectedColumn;
		this.dimensionTR = dimensionTR;
		this.columnReference = columnReference;
		this.eventBus = eventBus;
		thisPanel=this;
		Log.debug("ColumnMappingPanel: [parent:" + parent + " , trId:" + trId
				+ ", selectedColumn:" + selectedColumn + ", dimensionTR:"
				+ dimensionTR + ", columnReference:" + columnReference
				+ ", eventBus:" + eventBus
				+ "]");
		columnMappingList=new ColumnMappingList();
		
		
	}
	
	
	protected void setup(){
		itemIdSourceValueArg = "SourceArg" + selectedColumn.getName();
		itemIdTargetValueArg = "TargetArg" + selectedColumn.getName();
		
		
		vert = new VerticalLayoutContainer();
		vert.setScrollMode(ScrollMode.AUTO);
		vert.setAdjustForScroll(true);
		
		final HBoxLayoutContainer horiz = new HBoxLayoutContainer();
		
		
		
		final TextField sourceValueArg = new TextField();
		sourceValueArg.setItemId(itemIdSourceValueArg);
		
		
		final TextField targetValueArg = new TextField();
		targetValueArg.setItemId(itemIdTargetValueArg);
		
		final IconButton btnAdd = new IconButton();
		btnAdd.setItemId(itemIdBtnAdd);
		btnAdd.setIcon(ResourceBundle.INSTANCE.add());
		btnAdd.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				Log.debug("Clicked btnAdd");
				addColumnMappingData();
				thisPanel.forceLayout();
				vert.forceLayout();

			}
		});
		btnAdd.setVisible(false);

		final IconButton btnDel = new IconButton();
		btnDel.setItemId(itemIdBtnDel);
		btnDel.setIcon(ResourceBundle.INSTANCE.delete());
		btnDel.addClickHandler(new ClickHandler() {

			public void onClick(ClickEvent event) {
				Log.debug("Clicked btnDel");
				vert.remove(horiz);
				if (vert.getWidgetCount() == 0) {
					setup();
				} else {
					
				}
				thisPanel.forceLayout();
				vert.forceLayout();

			}
		});
		btnDel.setVisible(false);
		
		
		add(vert);
	}
	
	protected void addColumnMappingData(){
		
	}
	

	@Override
	public void selectedDimensionRow(DimensionRow dimensionRow) {
		// TODO Auto-generated method stub

	}

	@Override
	public void abortedDimensionRowSelection() {
		// TODO Auto-generated method stub

	}

	@Override
	public void failedDimensionRowSelection(String reason, String detail) {
		// TODO Auto-generated method stub

	}

	

}
