package org.gcube.portlets.user.td.columnwidget.client.create;

import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * Edit Row
 * 
 * @author "Giancarlo Panichi"
 * 
 */
public class AddColumnDialog extends Window {
	protected String WIDTH = "650px";
	protected String HEIGHT = "530px";
	protected EventBus eventBus;
	protected AddColumnPanel addColumnPanel;
	protected TRId trId;

	public AddColumnDialog(TRId trId, EventBus eventBus) {
		super();
		Log.debug("AddColumnDialog");
		this.eventBus = eventBus;
		this.trId=trId;
		initWindow();
		addColumnPanel = new AddColumnPanel(this, trId,eventBus);
		add(addColumnPanel);
	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);

		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ResourceBundle.INSTANCE.columnValue());
		setHeadingText("Add Column");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	public void close() {
		hide();

	}

	

}
