package org.gcube.portlets.user.td.columnwidget.client.progress;

import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

public interface ResumeDialogListener {
	
	
	/**
	 * Called when the resume of task is complete.
	 */
	public void resumeComplete(TRId trId);

	/**
	 * Called when the resume of task is failed.
	 * @param caught the failure exception.
	 * @param reason the failure reason.
	 */
	public void resumeFailed(Throwable caught, String reason);
	
	

	/**
	 * Called when the resume of task is stopped
	 * 
	 * @param trId
	 * @param reason
	 * @param details
	 */
	public void resumeStopped(TRId trId, String reason, String details);
	
	
	
}
