package org.gcube.portlets.user.td.columnwidget.client.batch;

import org.gcube.portlets.user.td.columnwidget.client.progress.ProgressDialogListener;
import org.gcube.portlets.user.td.columnwidget.client.progress.ReplaceBatchColumnProgressDialog;
import org.gcube.portlets.user.td.columnwidget.client.progress.ResumeDialogListener;
import org.gcube.portlets.user.td.columnwidget.client.progress.TaskResumeProgressDialog;
import org.gcube.portlets.user.td.columnwidget.client.resources.ResourceBundle;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.Constants;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.task.TaskResumeSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.batch.ReplaceBatchColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.ChangeTableRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.ChangeTableWhy;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.RequestProperties;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.Window;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;

/**
 * 
 * @author "Giancarlo Panichi" <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class ReplaceBatchDialog extends Window implements
		ProgressDialogListener, ResumeDialogListener {
	protected String WIDTH = "650px";
	protected String HEIGHT = "530px";
	protected TRId trId;
	protected String columnName = null;
	protected RequestProperties requestProperties;
	protected EventBus eventBus;
	protected String taskId;

	public ReplaceBatchDialog(TRId trId, String columnName, EventBus eventBus) {
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus = eventBus;
		taskId = null;
		initWindow();
		ReplaceBatchPanel batchRepalcePanel = new ReplaceBatchPanel(this, trId,
				columnName, eventBus);
		add(batchRepalcePanel);
	}

	public ReplaceBatchDialog(TRId trId, RequestProperties requestProperties,
			EventBus eventBus) {
		Log.debug("ReplaceBatchDialog: " + trId + ", RequestProperties:"
				+ requestProperties);
		this.trId = trId;
		this.requestProperties = requestProperties;
		this.eventBus = eventBus;
		taskId = (String) requestProperties.getMap().get(
				Constants.REQUEST_PROPERTIES_TASKID);
		Log.debug("Resume TaskId:" + taskId);
		initWindow();

		ReplaceBatchPanel batchRepalcePanel = new ReplaceBatchPanel(this, trId,
				requestProperties, eventBus);
		add(batchRepalcePanel);
	}

	protected void initWindow() {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setBodyBorder(false);
		setResizable(false);
		setHeadingText("Replace Batch");
		setClosable(true);
		setModal(true);
		forceLayoutOnResize = true;
		getHeader().setIcon(ResourceBundle.INSTANCE.replaceBatch());

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initTools() {
		super.initTools();

		closeBtn.addSelectHandler(new SelectHandler() {

			public void onSelect(SelectEvent event) {
				close();
			}
		});

	}

	protected void close() {
		hide();

	}

	protected void startBatchReplace(
			ReplaceBatchColumnSession replaceBatchColumnSession) {
		TDGWTServiceAsync.INSTANCE.startReplaceBatchColumn(
				replaceBatchColumnSession, new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("Start Replace Batch failed:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error on batch replace",
									"Error on batch replace");
						}
						close();

					}

					public void onSuccess(Void v) {
						Log.trace("Started batch replace ");
						callReplaceBatchColumnProgressDialog();

					}

				});

	}

	protected void callReplaceBatchColumnProgressDialog() {
		ReplaceBatchColumnProgressDialog dialog = new ReplaceBatchColumnProgressDialog(
				eventBus);
		dialog.addProgressDialogListener(this);
		dialog.show();

	}

	@Override
	public void operationComplete(TRId trId) {
		if (taskId == null) {
			ChangeTableWhy why = ChangeTableWhy.TABLEUPDATED;
			ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
					ChangeTableRequestType.COLUMNREPLACEBATCH, trId, why);
			eventBus.fireEvent(changeTableRequestEvent);
			hide();
		} else {
			 this.trId=trId;
			 StartTaskResume();
		}

	}

	@Override
	public void operationFailed(Throwable caught, String reason) {
		UtilsGXT3.alert("Error in Replace Batch", reason);
		hide();
	}

	@Override
	public void operationStopped(TRId trId, String reason, String details) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.COLUMNREPLACEBATCH, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		hide();

	}

	protected void StartTaskResume(){
		TaskResumeSession taskResumeSession=new TaskResumeSession(trId,taskId);
		TDGWTServiceAsync.INSTANCE.startTaskResume(taskResumeSession,  new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("Task Resume failed:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error on task resume",
									"Error on task resume (taskId="+taskId+")");
						}
						close();

					}

					public void onSuccess(Void v) {
						Log.trace("Started task resume");
						callForTaskResume();

					}

				});
	}
	
	
	protected void callForTaskResume(){
		TaskResumeProgressDialog dialog = new TaskResumeProgressDialog(
				eventBus);
		dialog.addResumeDialogListener(this);
		dialog.show();
	
	}

	
	@Override
	public void resumeComplete(TRId trId) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.COLUMNREPLACEBATCH, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		hide();
		
	}

	@Override
	public void resumeFailed(Throwable caught, String reason) {
		UtilsGXT3.alert("Error in Task Resume", reason);
		hide();
		
	}

	@Override
	public void resumeStopped(TRId trId, String reason, String details) {
		ChangeTableWhy why = ChangeTableWhy.TABLECURATION;
		ChangeTableRequestEvent changeTableRequestEvent = new ChangeTableRequestEvent(
				ChangeTableRequestType.COLUMNREPLACEBATCH, trId, why);
		eventBus.fireEvent(changeTableRequestEvent);
		hide();
		
	}

}
