package org.gcube.portlets.user.td.columnwidget.client;

import java.util.ArrayList;

import org.gcube.portlets.user.td.columnwidget.client.progress.LabelColumnProgressDialog;
import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataProperties;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.LabelColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadConfigBean;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.box.AlertMessageBox;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.event.HideEvent;
import com.sencha.gxt.widget.core.client.event.HideEvent.HideHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.info.Info;

/**
 * 
 * ChangeColumnTypePanel is the panel for change column type
 * 
 * 
 * @author "Giancarlo Panichi" 
 * <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class LabelColumnPanel extends FramedPanel {
	protected String WIDTH = "640px";
	protected String HEIGHT = "520px";
	protected EventBus eventBus;
	protected ChangeColumnTypeDialog parent;
	protected TextField label = null;
	protected TRId trId;
	protected String columnName;
	protected ColumnData column;
	protected ComboBox<ColumnData> comboColumn = null;
	protected ListLoader<ListLoadConfig, ListLoadResult<ColumnData>> loader;

	protected TextButton change;

	protected LabelColumnSession labelColumnSession;
	protected LabelColumnProgressDialog labelColumnProgressDialog;

	public LabelColumnPanel(TRId trId, String columnName, EventBus eventBus) {
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus = eventBus;
		Log.debug("LabelColumnPanel(): [" + trId.toString()
				+ " columnName: " + columnName + "]");

		// Column Data
		ColumnDataProperties propsColumnData = GWT
				.create(ColumnDataProperties.class);
		ListStore<ColumnData> storeCombo = new ListStore<ColumnData>(
				propsColumnData.id());

		Log.trace("StoreCombo created");

		RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>>() {

			public void load(ListLoadConfig loadConfig,
					final AsyncCallback<ListLoadResult<ColumnData>> callback) {
				loadData(loadConfig, callback);
			}
		};

		loader = new ListLoader<ListLoadConfig, ListLoadResult<ColumnData>>(
				proxy) {
			@Override
			protected ListLoadConfig newLoadConfig() {
				return (ListLoadConfig) new ListLoadConfigBean();
			}

		};

		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, ColumnData, ListLoadResult<ColumnData>>(
				storeCombo));
		Log.trace("LoaderCombo created");

		comboColumn = new ComboBox<ColumnData>(storeCombo,
				propsColumnData.label()) {

			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					public void execute() {
						loader.load();
					}
				});
			}
		};
		Log.trace("Combo ColumnData created");

		addHandlersForComboColumn(propsColumnData.label());

		comboColumn.setLoader(loader);
		comboColumn.setEmptyText("Select a column...");
		comboColumn.setWidth(150);
		comboColumn.setTypeAhead(false);
		comboColumn.setEditable(false);
		comboColumn.setTriggerAction(TriggerAction.ALL);
		
		label= new TextField();
		label.setAllowBlank(false);
		 
		change=new TextButton("Change");
		change.addSelectHandler(new SelectHandler() {
			
			public void onSelect(SelectEvent event) {
				onLabelColumn();
				
			}
		});
		
		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.add(new FieldLabel(comboColumn, "Column"), new VerticalLayoutData(1,
				-1));
		v.add(new FieldLabel(label, "Label"), new VerticalLayoutData(1, -1));
		v.add(change, new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));
		add(v, new VerticalLayoutData(-1, -1, new Margins()));

	}

	protected void addHandlersForComboColumn(
			final LabelProvider<ColumnData> labelProvider) {
		comboColumn.addSelectionHandler(new SelectionHandler<ColumnData>() {
			public void onSelection(SelectionEvent<ColumnData> event) {
				Info.display(
						"Column Selected",
						"You selected "
								+ (event.getSelectedItem() == null ? "nothing"
										: labelProvider.getLabel(event
												.getSelectedItem()) + "!"));
				Log.debug("ComboColumn selected: " + event.getSelectedItem());
				ColumnData columnData = event.getSelectedItem();
				updateComboStatus(columnData);
			}

		});
	}

	

	protected void loadData(ListLoadConfig loadConfig,
			final AsyncCallback<ListLoadResult<ColumnData>> callback) {
		TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						Log.error("load combo failure:"
								+ caught.getLocalizedMessage());
						AlertMessageBox d = new AlertMessageBox("Error",
								"Error retrieving columns of tabular resource:"
										+ trId.getId());
						d.addHideHandler(new HideHandler() {

							public void onHide(HideEvent event) {

							}
						});
						d.show();
						callback.onFailure(caught);
					}

					public void onSuccess(ArrayList<ColumnData> result) {
						Log.trace("loaded " + result.size() + " ColumnData");
						setComboStatus(result);
						callback.onSuccess(new ListLoadResultBean<ColumnData>(
								result));

					}

				});

	}

	protected void setComboStatus(ArrayList<ColumnData> result) {
		Log.debug("ColumnName:" + columnName);
		if (columnName != null) {
			for (ColumnData cd : result) {
				Log.debug("ColumnData name:" + cd.getName());
				if (cd.getName().compareTo(columnName) == 0) {
					updateComboStatus(cd);
				}
			}
		}
	}

	protected void updateComboStatus(ColumnData cd) {
		Log.debug("ColumnData: " + cd.toString());
		labelColumnSession = new LabelColumnSession();
		labelColumnSession.setColumnData(cd);
		labelColumnSession.setLabel(cd.getLabel());
		comboColumn.setValue(cd);
		label.setValue(cd.getLabel());
	}

	public void update(TRId trId, String columnName) {
		this.trId = trId;
		this.columnName = columnName;
		loader.load();
	}

	protected void onLabelColumn() {

		ColumnData columnData = comboColumn.getCurrentValue();
		if(columnData!=null){
			String lab= label.getCurrentValue();
			if(lab!=null && !lab.isEmpty()){
				callLabelColumn();
			} else {
				alert("Attention", "Insert a valid label!");
			}
		} else {
			alert("Attention", "Select a column!");
		}
	}

	private void callLabelColumn() {
		TDGWTServiceAsync.INSTANCE.startLabelColumn(
				labelColumnSession, new AsyncCallback<Void>() {

					public void onFailure(Throwable caught) {
						Log.debug("Change The Column Label Error: "
								+ caught.getLocalizedMessage());
						alert("Error Changing The Column Label",
								"Error in invocation of Change The Column Label operation!");

					}

					public void onSuccess(Void result) {
						labelColumnProgressDialog= new LabelColumnProgressDialog(labelColumnSession, eventBus);
					}

				});

	}

	protected void alert(String title, String message) {
		final AlertMessageBox d = new AlertMessageBox(title, message);
		d.addHideHandler(new HideHandler() {

			public void onHide(HideEvent event) {

			}
		});
		d.show();

	}

}
