/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class ClusterCommonNameDataSource<T extends FetchingElement>
implements Serializable {
    private static final long serialVersionUID = -4602671242562941238L;
    private HashMap<String, ArrayList<String>> hashMapCommonNameDataSources = new HashMap();
    private ArrayList<String> listDataSourcesFound = new ArrayList();

    public void updateHashCommonNamesDataSources(T item) {
        if (item instanceof ResultRow) {
            this.updateHashCommonNamesDataSources((ResultRow)item);
        } else if (item instanceof TaxonomyRow) {
            this.updateHashCommonNamesDataSources((TaxonomyRow)item);
        }
    }

    private void updateHashCommonNamesDataSources(TaxonomyRow row) {
        this.addDataSourceIfNotExists(row.getDataProviderName());
        this.updateHashCommonNamesDataSources(row.getDataProviderName(), row.getCommonNames());
    }

    private void updateHashCommonNamesDataSources(ResultRow row) {
        this.addDataSourceIfNotExists(row.getDataSourceName());
        this.updateHashCommonNamesDataSources(row.getDataSourceName(), row.getCommonNames());
    }

    private void addDataSourceIfNotExists(String dataSourceName) {
        if (this.listDataSourcesFound.indexOf(dataSourceName) == -1) {
            this.listDataSourcesFound.add(dataSourceName);
        }
    }

    private void updateHashCommonNamesDataSources(String dataProviderName, List<CommonName> listCommonName) {
        if (listCommonName != null) {
            for (CommonName comName : listCommonName) {
                String commonNameKey = comName.getName() + " (" + comName.getLanguage() + ")";
                ArrayList<String> dataSources = (ArrayList<String>)this.hashMapCommonNameDataSources.get(NormalizeString.lowerCaseUpFirstChar((String)commonNameKey));
                if (dataSources == null) {
                    dataSources = new ArrayList<String>();
                    dataSources.add(dataProviderName);
                    this.hashMapCommonNameDataSources.put(NormalizeString.lowerCaseUpFirstChar((String)commonNameKey), dataSources);
                    continue;
                }
                if (dataSources.contains(dataProviderName)) continue;
                dataSources.add(dataProviderName);
                this.hashMapCommonNameDataSources.put(NormalizeString.lowerCaseUpFirstChar((String)commonNameKey), dataSources);
            }
        }
    }

    public HashMap<String, ArrayList<String>> getHashMapCommonNameDataSources() {
        return this.hashMapCommonNameDataSources;
    }

    public ArrayList<String> getListDataSourcesFound() {
        return this.listDataSourcesFound;
    }
}

