/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Aggregator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;

public class AggregatorIterator<I>
implements CloseableIterator<I> {
    protected CloseableIterator<I> source;
    protected Map<String, Aggregator<I, ?>> aggregators;

    public AggregatorIterator(CloseableIterator<I> source) {
        this.source = source;
        this.aggregators = new HashMap();
    }

    public void addAggregator(Aggregator<I, ?> aggregator) {
        this.aggregators.put(aggregator.getName(), aggregator);
    }

    public Aggregator<I, ?> getAggregator(String name) {
        return (Aggregator)this.aggregators.get(name);
    }

    public boolean hasNext() {
        return this.source.hasNext();
    }

    public I next() {
        Object input = this.source.next();
        for (Aggregator aggregator : this.aggregators.values()) {
            aggregator.aggregate(input);
        }
        return (I)input;
    }

    public void remove() {
        this.source.remove();
    }

    public void close() throws IOException {
        this.source.close();
    }
}

