/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.AbstractDaoBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.session.SelectableFetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.shared.SelectableElement;

public abstract class AbstractSelectableDaoBuffer<T extends SelectableElement>
extends AbstractDaoBuffer<T>
implements SelectableFetchingBuffer<T> {
    protected String idField;
    protected String selectionField;

    public AbstractSelectableDaoBuffer(AbstractPersistence<T> dao, String idField, String selectionField) {
        super(dao);
        this.idField = idField;
        this.selectionField = selectionField;
    }

    public List<T> getSelected() throws SQLException {
        List selectedItems = new ArrayList();
        try {
            CriteriaBuilder queryBuilder = this.dao.getCriteriaBuilder();
            CriteriaQuery cq = queryBuilder.createQuery();
            Predicate pr1 = queryBuilder.equal((Expression)this.dao.rootFrom(cq).get(this.selectionField), (Object)true);
            cq.where((Expression)pr1);
            selectedItems = this.dao.executeCriteriaQuery(cq);
        }
        catch (Exception e) {
            this.logger.error((Object)"an erro occurred in get selected", (Throwable)e);
        }
        this.logger.trace((Object)("get selected return size: " + selectedItems.size()));
        return selectedItems;
    }

    public void updateSelection(int id, boolean selection) throws Exception {
        SelectableElement item = (SelectableElement)this.dao.getItemByKey(Integer.valueOf(id));
        item.setSelected(selection);
        this.dao.update((Object)item);
    }

    public abstract void updateAllSelection(boolean var1) throws Exception;

    public int sizeSelected() throws Exception {
        return this.getSelected().size();
    }
}

