/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;

public class TaxonomyRowPersistence
extends AbstractPersistence<TaxonomyRow> {
    public TaxonomyRowPersistence(EntityManagerFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAll() throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM TaxonomyRow").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("DELETE FROM TaxonomyRow " + removed + " items"));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyRow> getList() throws DatabaseServiceException {
        ArrayList<TaxonomyRow> listTaxonomy = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from TaxonomyRow t");
            listTaxonomy = query.getResultList();
        }
        return listTaxonomy;
    }

    public int countItems() throws DatabaseServiceException {
        HashMap<String, String> filterAndMap = new HashMap<String, String>();
        filterAndMap.put("isParent", "false");
        return this.getList(filterAndMap, -1, -1).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyRow getItemByKey(Integer id) throws DatabaseServiceException {
        this.logger.trace((Object)("getItemByKey id:  " + id));
        TaxonomyRow row = null;
        try (EntityManager em = super.createNewManager();){
            row = (TaxonomyRow)em.getReference(TaxonomyRow.class, (Object)id);
        }
        if (row != null) {
            this.logger.trace((Object)("getItemByKey return row:  " + row.getId() + ", service id: " + row.getServiceId()));
        } else {
            this.logger.trace((Object)"getItemByKey return null");
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyRow> executeCriteriaQuery(CriteriaQuery<Object> criteriaQuery) throws DatabaseServiceException {
        ArrayList<TaxonomyRow> listTaxonomyRow = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            TypedQuery query = em.createQuery(criteriaQuery);
            listTaxonomyRow = query.getResultList();
        }
        return listTaxonomyRow;
    }

    public CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException {
        return this.createNewManager().getCriteriaBuilder();
    }

    public Root<TaxonomyRow> rootFrom(CriteriaQuery<Object> cq) {
        return cq.from(TaxonomyRow.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyRow> getList(int startIndex, int offset) throws DatabaseServiceException {
        List<Object> listTaxonomyRow = new ArrayList<TaxonomyRow>();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from TaxonomyRow t");
            query.setFirstResult(startIndex);
            query.setMaxResults(offset);
            listTaxonomyRow = query.getResultList();
        }
        return listTaxonomyRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyRow> getList(Map<String, String> filterMap, int startIndex, int offset) throws DatabaseServiceException {
        List<Object> listTaxonomyRow = new ArrayList<TaxonomyRow>();
        try (EntityManager em = super.createNewManager();){
            String queryString = "select t from TaxonomyRow t";
            if (filterMap != null && filterMap.size() > 0) {
                queryString = queryString + " where ";
                for (String param : filterMap.keySet()) {
                    String value = filterMap.get(param);
                    queryString = queryString + " t." + param + "=" + value;
                    queryString = queryString + "AND";
                }
                queryString = queryString.substring(0, queryString.lastIndexOf("AND"));
            }
            Query query = em.createQuery(queryString);
            if (startIndex > -1) {
                query.setFirstResult(startIndex);
            }
            if (offset > -1) {
                query.setMaxResults(offset);
            }
            listTaxonomyRow = query.getResultList();
        }
        return listTaxonomyRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonomyRow> executeTypedQuery(CriteriaQuery cq, int startIndex, int offset) throws DatabaseServiceException {
        List<Object> listOJ = new ArrayList<TaxonomyRow>();
        try (EntityManager em = super.createNewManager();){
            TypedQuery typedQuery = em.createQuery(cq);
            if (startIndex > -1) {
                typedQuery.setFirstResult(startIndex);
            }
            if (offset > -1) {
                typedQuery.setMaxResults(offset);
            }
            listOJ = typedQuery.getResultList();
        }
        return listOJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteItemByIdField(String idField) throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM TaxonomyRow t WHERE t.id='" + idField + "'").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("Item " + idField + " was deleted from TaxonomyRow"));
        }
        return removed;
    }
}

