/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.streams.Stream;
import org.gcube.portlets.user.speciesdiscovery.client.util.TaxonomyGridField;
import org.gcube.portlets.user.speciesdiscovery.server.asl.SessionUtil;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.DaoSession;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.service.SpeciesService;
import org.gcube.portlets.user.speciesdiscovery.server.service.TaxonomyItemConverter;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.StreamExtend;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaxonomyRowTable
extends HttpServlet {
    protected static final String UTF_8 = "UTF-8";
    private static final long serialVersionUID = 9157876104914505028L;
    public static final String TEXT_HTML = "text/html; charset=UTF-8";
    public static final String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
    public static final String HTML = "<HTML>";
    public static final String HTMLCLOSE = "</HTML>";
    public static final String HEAD = "<HEAD>";
    public static final String HEADCLOSE = "</HEAD>";
    public static final String TITLE = "<TITLE>";
    public static final String TITLECLOSE = "</TITLE>";
    public static final String BODY = "<BODY>";
    public static final String BODYCLOSE = "</BODY>";
    protected Logger logger = Logger.getLogger(TaxonomyRowTable.class);

    public static String headWithTitle(String title) {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<TITLE>" + title + "</TITLE>" + "\n" + "</HEAD>" + "\n";
    }

    protected ASLSession getASLSession(HttpServletRequest req) {
        return SessionUtil.getAslSession((HttpSession)req.getSession());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.retrieveTaxonomyRowAsHtmlTable(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.retrieveTaxonomyRowAsHtmlTable(req, resp);
    }

    private void retrieveTaxonomyRowAsHtmlTable(HttpServletRequest req, HttpServletResponse resp) {
        String taxonomyServiceRowID = "";
        resp.setContentType("text/html; charset=UTF-8");
        TaxonomyRow row = null;
        PrintWriter out = null;
        try {
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8"), true);
            out.println(TaxonomyRowTable.headWithTitle((String)""));
            out.println("<BODY>");
            taxonomyServiceRowID = req.getParameter("oid");
            ASLSession aslSession = this.getASLSession(req);
            if (taxonomyServiceRowID == null || taxonomyServiceRowID.isEmpty()) {
                out.println(this.error("Parameter oid not found"));
            } else {
                this.logger.trace((Object)("doGet found oid " + taxonomyServiceRowID));
                try {
                    TaxonomyRowPersistence persistence = SessionUtil.getCurrentEJBTaxonomyItem((ASLSession)aslSession);
                    if (persistence == null) {
                        this.logger.trace((Object)"TaxonomyRowPersistence not found in session, creating it");
                        persistence = new TaxonomyRowPersistence(DaoSession.getEntityManagerFactory((ASLSession)aslSession));
                    }
                    CriteriaBuilder queryBuilder = persistence.getCriteriaBuilder();
                    CriteriaQuery cq = queryBuilder.createQuery();
                    Predicate pr1 = queryBuilder.equal((Expression)persistence.rootFrom(cq).get("serviceIdField"), (Object)taxonomyServiceRowID);
                    cq.where((Expression)pr1);
                    Iterator iterator = persistence.executeCriteriaQuery(cq).iterator();
                    if (iterator.hasNext()) {
                        row = (TaxonomyRow)iterator.next();
                    }
                    if (row == null) {
                        this.logger.trace((Object)("Taxonomy Row with id " + taxonomyServiceRowID + " not found in database"));
                        row = this.findingTaxonomyInCaches(taxonomyServiceRowID, this.getASLSession(req));
                        if (row != null) {
                            this.logger.trace((Object)("Taxonomy Row with id " + taxonomyServiceRowID + " found into hash map caches"));
                            this.logger.trace((Object)"converting taxonomy row to html table");
                            String table = this.getHTMLTableForTaxonomy(row);
                            this.logger.trace((Object)("table for ResultRowPersistence is empty? " + table.isEmpty()));
                            out.println(table);
                            out.close();
                            return;
                        }
                        this.logger.trace((Object)("Taxonomy Row with id " + taxonomyServiceRowID + " doesn't found into hash map caches"));
                        this.logger.trace((Object)("Tentative recovering taxonomy with id " + taxonomyServiceRowID + " from service"));
                        SpeciesService service = this.getSpeciesService(req);
                        StreamExtend streamIds = new StreamExtend(Arrays.asList(taxonomyServiceRowID).iterator());
                        CloseableIterator streamIterator = service.retrieveTaxonomyById((Stream)streamIds);
                        TaxonomyItemConverter taxonomyItemConverter = new TaxonomyItemConverter(aslSession);
                        if (streamIterator.hasNext()) {
                            TaxonomyItem tax = (TaxonomyItem)streamIterator.next();
                            this.logger.trace((Object)("Taxonomy with id " + taxonomyServiceRowID + " found on service, converting"));
                            row = taxonomyItemConverter.convert(tax);
                        }
                        streamIterator.close();
                        if (row == null) {
                            out.println(this.error("Sorry, taxonomy with " + taxonomyServiceRowID + " doesn't found in service"));
                            out.close();
                            return;
                        }
                    }
                    this.logger.trace((Object)"converting taxonomy row to html table");
                    String table = this.getHTMLTableForTaxonomy(row);
                    this.logger.trace((Object)("table for ResultRowPersistence is empty? " + table.isEmpty()));
                    out.println(table);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error in TaxonomyRowTable servlet ", (Throwable)e);
                    throw new Exception("Error in ResultRowTable servlet ", e);
                }
            }
            out.println("</BODY>");
            out.println("</HTML>");
            out.close();
        }
        catch (Exception e) {
            String error = "Sorry an error occurred when creating the table for taxonomy row with id: " + taxonomyServiceRowID;
            if (out == null) {
                try {
                    out = resp.getWriter();
                }
                catch (IOException e1) {
                    this.logger.error((Object)"Error on get Writer into servlet ", (Throwable)e);
                }
            }
            out.println(error);
            out.println("</BODY>");
            out.println("</HTML>");
            out.close();
        }
    }

    protected TaxonomyRow findingTaxonomyInCaches(String taxonomyServiceRowID, ASLSession session) {
        TaxonomyRow row;
        HashMap hashChildrenTaxa = SessionUtil.getHashMapChildrenTaxonomyCache((ASLSession)session);
        if (hashChildrenTaxa != null) {
            this.logger.trace((Object)("Finding Taxonomy Row with id " + taxonomyServiceRowID + " into hash map children"));
            row = (TaxonomyRow)hashChildrenTaxa.get(taxonomyServiceRowID);
            if (row != null) {
                this.logger.trace((Object)("Taxonomy Row with id " + taxonomyServiceRowID + " found into hash map children"));
                return row;
            }
        }
        if ((hashChildrenTaxa = SessionUtil.getHashMapSynonymsTaxonomyCache((ASLSession)session)) != null) {
            this.logger.trace((Object)("Finding Taxonomy Row with id " + taxonomyServiceRowID + " into hash map synonyms"));
            row = (TaxonomyRow)hashChildrenTaxa.get(taxonomyServiceRowID);
            if (row != null) {
                this.logger.trace((Object)("Taxonomy Row with id " + taxonomyServiceRowID + " found into hash map synonyms"));
                return row;
            }
        }
        if ((hashChildrenTaxa = SessionUtil.getHashMapTaxonomyByIdsCache((ASLSession)session)) != null) {
            this.logger.trace((Object)("Finding Taxonomy Row with id " + taxonomyServiceRowID + " into hash map ByIds"));
            row = (TaxonomyRow)hashChildrenTaxa.get(taxonomyServiceRowID);
            if (row != null) {
                this.logger.trace((Object)("Taxonomy Row with id " + taxonomyServiceRowID + " found into hash map ByIds"));
                return row;
            }
        }
        return null;
    }

    protected SpeciesService getSpeciesService(HttpServletRequest req) throws SearchServiceException {
        try {
            ASLSession session = this.getASLSession(req);
            return SessionUtil.getService((ASLSession)session);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"An error occurred when contacting the species service", (Throwable)e);
            throw new SearchServiceException("contacting the species service.");
        }
    }

    public String error(String message) {
        String errorPage = "";
        errorPage = errorPage + "<p>Error: " + message + "</p>";
        return errorPage;
    }

    public String getHTMLTableForTaxonomy(TaxonomyRow row) {
        String dataProviderName = "";
        String dataSetCitation = "";
        String matchingAccordionTo = "";
        String rank = "";
        String statusName = "";
        String dateModified = "";
        String statusRemark = "";
        String scientificNameAuthorship = "";
        String lsid = "";
        String credits = "";
        String propertiesHtml = "";
        if (row.getDataProviderName() != null) {
            dataProviderName = row.getDataProviderName();
        }
        if (row.getStatusName() != null) {
            statusName = row.getStatusName();
        }
        if (row.getDateModified() != null) {
            dateModified = row.getDateModified();
        }
        if (row.getDataSetCitation() != null) {
            dataSetCitation = row.getDataSetCitation();
        }
        if (row.getRank() != null) {
            rank = row.getRank();
        }
        if (row.getAccordingTo() != null) {
            matchingAccordionTo = row.getAccordingTo();
        }
        if (row.getStatusRemarks() != null) {
            statusRemark = row.getStatusRemarks();
        }
        if (row.getScientificNameAuthorship() != null) {
            scientificNameAuthorship = row.getScientificNameAuthorship();
        }
        if (row.getLsid() != null) {
            lsid = row.getLsid();
        }
        if (row.getCredits() != null) {
            credits = row.getCredits();
        }
        if (row.getProperties() != null) {
            List hashProperties = row.getProperties();
            Collections.sort(hashProperties, ItemParameter.COMPARATOR);
            propertiesHtml = propertiesHtml + "<table class=\"parameters\">";
            for (ItemParameter itemParameter : hashProperties) {
                propertiesHtml = propertiesHtml + "<tr>\t<td class=\"title\">" + itemParameter.getKey() + "</td>" + "\t<td>" + itemParameter.getValue() + "</td>" + "</tr>";
            }
            propertiesHtml = propertiesHtml + "</table>";
        }
        String commonNames = "";
        if (row.getCommonNames() != null) {
            for (CommonName comName : row.getCommonNames()) {
                commonNames = commonNames + "<b>" + comName.getName() + "</b>" + " (" + comName.getLanguage() + ") - ";
            }
        }
        String table = "<table class=\"imagetable\">";
        table = table + "<tr>\t<td class=\"title\">" + TaxonomyGridField.COMMON_NAMES.getName() + " (Language)</td>" + "\t<td>" + commonNames + "</td>" + "</tr>";
        table = table + "<tr>\t<td class=\"title\">" + TaxonomyGridField.DATASOURCE.getName() + "</td>" + "\t<td>" + dataProviderName + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.DATEMODIFIED.getName() + "</td>" + "\t<td>" + dateModified + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.MATCHING_RANK.getName() + "</td>" + "\t<td>" + rank + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.CITATION.getName() + "</td>" + "\t<td>" + dataSetCitation + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.LSID.getName() + "</td>" + "\t<td>" + lsid + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.SCIENTIFICNAMEAUTHORSHIP.getName() + "</td>" + "\t<td>" + scientificNameAuthorship + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.CREDITS.getName() + "</td>" + "\t<td>" + credits + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.PROPERTIES.getName() + "</td>" + "\t<td>" + propertiesHtml + "</td>" + "</tr>" + "</table>";
        return table;
    }
}

