/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.dataaccess.spql.ParserException;
import org.gcube.dataaccess.spql.SPQLQueryParser;
import org.gcube.portlets.user.speciesdiscovery.server.service.QueryBuilder;
import org.gcube.portlets.user.speciesdiscovery.shared.Coordinate;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryBuilder {
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    protected static Logger logger = Logger.getLogger(QueryBuilder.class);

    public static String buildQuery(String searchTerm, SearchType searchType, SearchFilters searchFilters) {
        List conditions;
        DataSourceModel ds;
        Iterator dsIterator;
        logger.trace((Object)"query building...");
        StringBuilder query = new StringBuilder();
        query.append("SEARCH BY ");
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SearchType[searchType.ordinal()]) {
            case 1: {
                query.append("SN ");
                break;
            }
            case 2: {
                query.append("CN ");
                break;
            }
        }
        query.append('\'');
        query.append(searchTerm);
        query.append("' ");
        if (searchType == SearchType.BY_SCIENTIFIC_NAME && searchFilters.getListDataSourcesForUnfold() != null && searchFilters.getListDataSourcesForUnfold().size() > 0) {
            query.append("UNFOLD WITH ");
            dsIterator = searchFilters.getListDataSourcesForUnfold().iterator();
            while (dsIterator.hasNext()) {
                ds = (DataSourceModel)dsIterator.next();
                query.append(ds.getId());
                if (dsIterator.hasNext()) {
                    query.append(", ");
                    continue;
                }
                query.append(" ");
            }
        }
        if (searchType == SearchType.BY_COMMON_NAME) {
            query.append("RESOLVE ");
        }
        if (searchFilters.getListDataSourcesForSynonyms() != null && searchFilters.getListDataSourcesForSynonyms().size() > 0) {
            query.append("EXPAND WITH ");
            dsIterator = searchFilters.getListDataSourcesForSynonyms().iterator();
            while (dsIterator.hasNext()) {
                ds = (DataSourceModel)dsIterator.next();
                query.append(ds.getId());
                if (dsIterator.hasNext()) {
                    query.append(", ");
                    continue;
                }
                query.append(" ");
            }
        }
        if (searchFilters.getListDataSources() != null && searchFilters.getListDataSources().size() > 0) {
            query.append("IN ");
            dsIterator = searchFilters.getListDataSources().iterator();
            while (dsIterator.hasNext()) {
                ds = (DataSourceModel)dsIterator.next();
                query.append(ds.getId());
                if (dsIterator.hasNext()) {
                    query.append(", ");
                    continue;
                }
                query.append(" ");
            }
        }
        if ((conditions = QueryBuilder.createFilterProperties((SearchFilters)searchFilters)).size() > 0) {
            query.append("WHERE ");
            Iterator conditionsIterator = conditions.iterator();
            while (conditionsIterator.hasNext()) {
                String condition = (String)conditionsIterator.next();
                query.append(condition);
                if (conditionsIterator.hasNext()) {
                    query.append(" AND ");
                    continue;
                }
                query.append(" ");
            }
        }
        query.append("RETURN ");
        if (searchFilters.getResultType() != null) {
            switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SpeciesCapability[searchFilters.getResultType().ordinal()]) {
                case 1: {
                    query.append("Product HAVING xpath(\"//product[type='Occurrence' and count>0]\")");
                    break;
                }
                case 2: {
                    query.append("Taxon");
                }
            }
        } else {
            query.append("Product HAVING xpath(\"//product[type='Occurrence' and count>0]\")");
        }
        String builtQuery = query.toString();
        logger.trace((Object)("built query: " + builtQuery));
        try {
            SPQLQueryParser.parse((String)builtQuery);
        }
        catch (ParserException e) {
            System.out.println("error parsing");
            e.printStackTrace();
        }
        return builtQuery;
    }

    protected static List<String> createFilterProperties(SearchFilters searchFilters) {
        Coordinate coordinate;
        ArrayList<String> conditions = new ArrayList<String>();
        if (searchFilters.getUpperBound() != null) {
            coordinate = searchFilters.getUpperBound();
            conditions.add("coordinate <= " + coordinate.getLatitude() + " , " + coordinate.getLongitude());
        }
        if (searchFilters.getLowerBound() != null) {
            coordinate = searchFilters.getLowerBound();
            conditions.add("coordinate >= " + coordinate.getLatitude() + " , " + coordinate.getLongitude());
        }
        if (searchFilters.getFromDate() != null) {
            conditions.add("eventDate >= '" + DATE_FORMAT.format(searchFilters.getFromDate()) + "'");
        }
        if (searchFilters.getToDate() != null) {
            conditions.add("eventDate <= '" + DATE_FORMAT.format(searchFilters.getToDate()) + "'");
        }
        return conditions;
    }
}

