/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.SelectableElement;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyProvider;

@Entity
public class ResultRow
implements FetchingElement,
SelectableElement,
Serializable,
TaxonomyProvider {
    private static final long serialVersionUID = 1028839024130840026L;
    public static final String ID_FIELD = "id";
    public static final String SERVICE_ID_FIELD = "serviceIdField";
    public static final String PARENT_FOREIGN_KEY_TAXON = "matchingTaxon";
    public static final String DATAPROVIDER_NAME = "dataProviderName";
    public static final String DATASOURCE_NAME = "dataSourceName";
    public static final String SELECTED = "selected";
    public static final String DATASET_NAME = "dataSetName";
    public static final String DATASET_ID = "dataSetId";
    public static final String DATASET_CITATION = "dataSetCitation";
    public static final String MATCHING_CREDITS = "matchingCredits";
    public static final String EXISTS_COMMONNAME = "existsCommonName";
    public static final String IMAGE_COUNT = "imagesCount";
    public static final String IMAGE_KEY = "imagesKey";
    public static final String LAYERS_COUNT = "layersCount";
    public static final String LAYERS_KEY = "layersKey";
    public static final String OCCURRENCES_COUNT = "occurencesCount";
    public static final String OCCURRENCES_KEY = "occurencesKey";
    public static final String MAP_COUNT = "mapsCount";
    public static final String MAP_KEY = "mapsKey";
    public static final String BASE_TAXON_VALUE = "baseTaxonValue";
    public static final String DATAPROVIDER_ID = "dataProviderId";
    public static final String DATASOURCE_ID = "dataSourceId";
    public static final String KINGDOM_ID = "kingdomID";
    public static final String PHYLUM_ID = "phylumID";
    public static final String CLASS_ID = "classID";
    public static final String ORDER_ID = "orderID";
    public static final String FAMILY_ID = "familyID";
    public static final String GENUS_ID = "genusID";
    public static final String SPECIES_ID = "speciesID";
    public static final String AUTHOR = "author";
    public static final String CREDITS = "credits";
    public static final String LSID = "lsid";
    public static final String PROPERTIES = "properties";
    public static final String EXISTS_PROPERTIES = "existsProperties";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected int id;
    protected boolean selected = false;
    protected String dataSourceId;
    protected String dataSourceName;
    protected String dataProviderId;
    protected String dataProviderName;
    protected String serviceIdField;
    protected String dataSetId;
    protected String dataSetName;
    protected String dataSetCitation;
    protected String matchingCredits;
    protected boolean existsCommonName = false;
    @OneToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    protected List<CommonName> commonNames = new ArrayList();
    @OneToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    protected List<Taxon> matchingTaxon = new ArrayList();
    @OneToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    protected List<ItemParameter> properties = new ArrayList();
    protected int imagesCount;
    protected String imagesKey;
    protected int layersCount;
    protected String layersKey;
    protected int occurencesCount;
    protected String occurencesKey;
    protected int mapsCount;
    protected String mapsKey;
    protected String baseTaxonValue;
    protected String kingdomID;
    protected String phylumID;
    protected String classID;
    protected String orderID;
    protected String familyID;
    protected String genusID;
    protected String speciesID;
    protected String author;
    protected String credits;
    protected String lsid;
    protected boolean existsProperties = false;

    protected ResultRow() {
    }

    public ResultRow(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getIdToString() {
        return String.valueOf(this.id);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataProviderId() {
        return this.dataProviderId;
    }

    public void setDataProviderId(String dataProviderId) {
        this.dataProviderId = dataProviderId;
    }

    public String getDataProviderName() {
        return this.dataProviderName;
    }

    public void setDataProviderName(String dataProviderName) {
        this.dataProviderName = dataProviderName;
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public String getDataSetCitation() {
        return this.dataSetCitation;
    }

    public void setDataSetCitation(String dataSetCitation) {
        this.dataSetCitation = dataSetCitation;
    }

    public int getImagesCount() {
        return this.imagesCount;
    }

    public void setImagesCount(int imagesCount) {
        this.imagesCount = imagesCount;
    }

    public int getLayersCount() {
        return this.layersCount;
    }

    public void setLayersCount(int layersCount) {
        this.layersCount = layersCount;
    }

    public int getOccurencesCount() {
        return this.occurencesCount;
    }

    public void setOccurencesCount(int occurencesCount) {
        this.occurencesCount = occurencesCount;
    }

    public int getMapsCount() {
        return this.mapsCount;
    }

    public void setMapsCount(int mapsCount) {
        this.mapsCount = mapsCount;
    }

    public String getImagesKey() {
        return this.imagesKey;
    }

    public void setImagesKey(String imagesKey) {
        this.imagesKey = imagesKey;
    }

    public String getLayersKey() {
        return this.layersKey;
    }

    public void setLayersKey(String layersKey) {
        this.layersKey = layersKey;
    }

    public String getOccurencesKey() {
        return this.occurencesKey;
    }

    public void setOccurencesKey(String occurencesKey) {
        this.occurencesKey = occurencesKey;
    }

    public String getMapsKey() {
        return this.mapsKey;
    }

    public void setMapsKey(String mapsKey) {
        this.mapsKey = mapsKey;
    }

    public String getMatchingCredits() {
        return this.matchingCredits;
    }

    public void setMatchingCredits(String matchingCredits) {
        this.matchingCredits = matchingCredits;
    }

    public void setBaseTaxonValue(String taxonomyValue) {
        this.baseTaxonValue = taxonomyValue;
    }

    public String getBaseTaxonValue() {
        return this.baseTaxonValue;
    }

    public boolean existsCommonName() {
        return this.existsCommonName;
    }

    public void setExistsCommonName(boolean existsCommonName) {
        this.existsCommonName = existsCommonName;
    }

    public List<CommonName> getCommonNames() {
        return this.commonNames;
    }

    public void setCommonNames(List<CommonName> commonNames) {
        this.commonNames = commonNames;
    }

    public String getKingdomID() {
        return this.kingdomID;
    }

    public void setKingdomID(String kingdomID) {
        this.kingdomID = kingdomID;
    }

    public String getPhylumID() {
        return this.phylumID;
    }

    public void setPhylumID(String phylumID) {
        this.phylumID = phylumID;
    }

    public String getClassID() {
        return this.classID;
    }

    public void setClassID(String classID) {
        this.classID = classID;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public String getFamilyID() {
        return this.familyID;
    }

    public void setFamilyID(String familyID) {
        this.familyID = familyID;
    }

    public String getGenusID() {
        return this.genusID;
    }

    public void setGenusID(String genusID) {
        this.genusID = genusID;
    }

    public String getSpeciesID() {
        return this.speciesID;
    }

    public void setSpeciesID(String speciesID) {
        this.speciesID = speciesID;
    }

    public String getServiceId() {
        return this.serviceIdField;
    }

    public void setServiceId(String serviceIdField) {
        this.serviceIdField = serviceIdField;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCredits() {
        return this.credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    public String getLsid() {
        return this.lsid;
    }

    public void setLsid(String lsid) {
        this.lsid = lsid;
    }

    public void setExistsProperties(boolean b) {
        this.existsProperties = b;
    }

    public boolean existsProperties() {
        return this.existsProperties;
    }

    public List<Taxon> getParents() {
        Collections.sort(this.matchingTaxon);
        return this.matchingTaxon;
    }

    public void setMatchingTaxon(List<Taxon> matchingTaxon) {
        this.matchingTaxon = matchingTaxon;
    }

    public String getServiceIdField() {
        return this.serviceIdField;
    }

    public boolean isExistsCommonName() {
        return this.existsCommonName;
    }

    public List<ItemParameter> getProperties() {
        return this.properties;
    }

    public boolean isExistsProperties() {
        return this.existsProperties;
    }

    public void setProperties(List<ItemParameter> properties) {
        this.properties = properties;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResultRow [id=");
        builder.append(this.id);
        builder.append(", selected=");
        builder.append(this.selected);
        builder.append(", dataSourceId=");
        builder.append(this.dataSourceId);
        builder.append(", dataSourceName=");
        builder.append(this.dataSourceName);
        builder.append(", dataProviderId=");
        builder.append(this.dataProviderId);
        builder.append(", dataProviderName=");
        builder.append(this.dataProviderName);
        builder.append(", serviceIdField=");
        builder.append(this.serviceIdField);
        builder.append(", dataSetId=");
        builder.append(this.dataSetId);
        builder.append(", dataSetName=");
        builder.append(this.dataSetName);
        builder.append(", dataSetCitation=");
        builder.append(this.dataSetCitation);
        builder.append(", matchingCredits=");
        builder.append(this.matchingCredits);
        builder.append(", existsCommonName=");
        builder.append(this.existsCommonName);
        builder.append(", commonNames=");
        builder.append(this.commonNames);
        builder.append(", matchingTaxon=");
        builder.append(this.matchingTaxon);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", imagesCount=");
        builder.append(this.imagesCount);
        builder.append(", imagesKey=");
        builder.append(this.imagesKey);
        builder.append(", layersCount=");
        builder.append(this.layersCount);
        builder.append(", layersKey=");
        builder.append(this.layersKey);
        builder.append(", occurencesCount=");
        builder.append(this.occurencesCount);
        builder.append(", occurencesKey=");
        builder.append(this.occurencesKey);
        builder.append(", mapsCount=");
        builder.append(this.mapsCount);
        builder.append(", mapsKey=");
        builder.append(this.mapsKey);
        builder.append(", baseTaxonValue=");
        builder.append(this.baseTaxonValue);
        builder.append(", kingdomID=");
        builder.append(this.kingdomID);
        builder.append(", phylumID=");
        builder.append(this.phylumID);
        builder.append(", classID=");
        builder.append(this.classID);
        builder.append(", orderID=");
        builder.append(this.orderID);
        builder.append(", familyID=");
        builder.append(this.familyID);
        builder.append(", genusID=");
        builder.append(this.genusID);
        builder.append(", speciesID=");
        builder.append(this.speciesID);
        builder.append(", author=");
        builder.append(this.author);
        builder.append(", credits=");
        builder.append(this.credits);
        builder.append(", lsid=");
        builder.append(this.lsid);
        builder.append(", existsProperties=");
        builder.append(this.existsProperties);
        builder.append("]");
        return builder.toString();
    }
}

