/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.job;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.spd.stubs.types.Status;
import org.gcube.portlets.user.speciesdiscovery.server.job.KeyStringList;
import org.gcube.portlets.user.speciesdiscovery.server.job.OccurrenceKeys;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.DaoSession;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.service.SpeciesService;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingSession;
import org.gcube.portlets.user.speciesdiscovery.server.session.SelectableFetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.util.DateUtil;
import org.gcube.portlets.user.speciesdiscovery.server.util.XStreamUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.JobOccurrencesModel;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesJob;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesSaveEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.SaveFileFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class OccurrenceJobUtil {
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String RUNNING = "RUNNING";
    public static final String PENDING = "PENDING";
    private static final String ALIASKEY = "key";
    protected static Logger logger = Logger.getLogger(OccurrenceJobUtil.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat;

    public static JobOccurrencesModel convertJob(OccurrencesJob job, Status statusResponse, OccurrenceJobPersistence occurrencesJobDao) {
        DownloadState downloadState = null;
        long endTime = 0L;
        String status = statusResponse.getStatus();
        downloadState = OccurrenceJobUtil.getDownloadState((String)status);
        logger.trace((Object)("jobId: " + job.getId() + " download state: " + downloadState));
        if (downloadState == null) {
            return null;
        }
        long submitTime = job.getSubmitTime();
        Date submit = DateUtil.millisecondsToDate((long)submitTime);
        int completedEntry = 0;
        if (statusResponse.getCompletedEntries() > 0) {
            completedEntry = statusResponse.getCompletedEntries();
        }
        boolean changeStatus = false;
        if (downloadState.equals((Object)DownloadState.COMPLETED) && job.getState().compareTo(DownloadState.SAVED.toString()) == 0) {
            downloadState = DownloadState.SAVED;
            changeStatus = true;
        }
        JobOccurrencesModel jobOccurrenceModel = new JobOccurrencesModel(job.getId(), job.getName(), job.getDescription(), downloadState, job.getScientificName(), job.getDataSources(), submit, null, completedEntry, job.getExpectedOccurrence());
        try {
            boolean changeEndTime = false;
            if ((downloadState.equals((Object)DownloadState.FAILED) || downloadState.equals((Object)DownloadState.COMPLETED)) && statusResponse.getEndDate() != null && job.getEndTime() == 0L) {
                logger.trace((Object)("UPDATE end time first time only - " + downloadState));
                endTime = statusResponse.getEndDate().getTimeInMillis();
                job.setEndTime(endTime);
                changeEndTime = true;
            }
            boolean changeStartTime = false;
            long startTime = job.getStartTime();
            if (statusResponse.getStartDate() != null && startTime == 0L) {
                Date start = DateUtil.millisecondsToDate((long)statusResponse.getStartDate().getTimeInMillis());
                jobOccurrenceModel.setStartTime(start);
                changeStartTime = true;
            }
            if (changeStatus || changeEndTime || changeStartTime) {
                job.setState(downloadState.toString());
                occurrencesJobDao.update((Object)job);
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred on update the  occurrencesJobDao ", (Throwable)e);
        }
        endTime = job.getEndTime();
        long elapsedTime = 0L;
        if (endTime != 0L) {
            Date end = DateUtil.millisecondsToDate((long)endTime);
            jobOccurrenceModel.setEndTime(end);
            elapsedTime = endTime;
        } else {
            elapsedTime = Calendar.getInstance().getTimeInMillis();
        }
        jobOccurrenceModel.setElapsedTime(DateUtil.getDifference((long)submitTime, (long)elapsedTime));
        jobOccurrenceModel.setFileFormat(OccurrenceJobUtil.converFileFormat((String)job.getFileFormat()));
        jobOccurrenceModel.setCsvType(OccurrenceJobUtil.convertCsvType((String)job.getCsvType()));
        jobOccurrenceModel.setByDataSource(job.isByDataSource());
        return jobOccurrenceModel;
    }

    public static DownloadState getDownloadState(String status) {
        if (status != null) {
            if (status.compareToIgnoreCase("PENDING") == 0) {
                return DownloadState.PENDING;
            }
            if (status.compareToIgnoreCase("RUNNING") == 0) {
                return DownloadState.ONGOING;
            }
            if (status.compareToIgnoreCase("FAILED") == 0) {
                return DownloadState.FAILED;
            }
            if (status.compareToIgnoreCase("COMPLETED") == 0) {
                return DownloadState.COMPLETED;
            }
        }
        return null;
    }

    public static OccurrencesSaveEnum convertCsvType(String csvType) {
        if (csvType != null) {
            if (csvType.compareToIgnoreCase(OccurrencesSaveEnum.STANDARD.toString()) == 0) {
                return OccurrencesSaveEnum.STANDARD;
            }
            if (csvType.compareToIgnoreCase(OccurrencesSaveEnum.OPENMODELLER.toString()) == 0) {
                return OccurrencesSaveEnum.OPENMODELLER;
            }
        }
        return null;
    }

    public static SaveFileFormat converFileFormat(String fileFormat) {
        if (fileFormat != null) {
            if (fileFormat.compareToIgnoreCase(SaveFileFormat.CSV.toString()) == 0) {
                return SaveFileFormat.CSV;
            }
            if (fileFormat.compareToIgnoreCase(SaveFileFormat.DARWIN_CORE.toString()) == 0) {
                return SaveFileFormat.DARWIN_CORE;
            }
        }
        return null;
    }

    public static int deleteOccurrenceJobById(String jobIdentifier, OccurrenceJobPersistence occurrencesJobDao) {
        logger.trace((Object)("Delete occurrence job id: " + jobIdentifier));
        try {
            int removed = occurrencesJobDao.deleteItemByIdField(jobIdentifier);
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)("An error occured deleteOccurrenceJobById  jobId: " + jobIdentifier + " exception: " + e), (Throwable)e);
            logger.trace((Object)("job not exists : " + jobIdentifier));
            return 0;
        }
    }

    public static int changeStatusOccurrenceJobById(String jobIdentifier, DownloadState state, OccurrenceJobPersistence occurrencesJobDao) {
        logger.trace((Object)("Change status occurrence job id: " + jobIdentifier));
        int result = 0;
        CriteriaBuilder queryBuilder = occurrencesJobDao.getCriteriaBuilder();
        CriteriaQuery cq = queryBuilder.createQuery();
        Predicate pr1 = queryBuilder.equal((Expression)occurrencesJobDao.rootFrom(cq).get("id"), (Object)jobIdentifier);
        cq.where((Expression)pr1);
        Iterator iterator = occurrencesJobDao.executeCriteriaQuery(cq).iterator();
        if (!iterator.hasNext()) {
            return 0;
        }
        OccurrencesJob job = (OccurrencesJob)iterator.next();
        try {
            job.setState(state.toString());
            occurrencesJobDao.update((Object)job);
        }
        catch (Exception e) {
            logger.error((Object)("An error occured in change status  jobId: " + jobIdentifier + " exception: " + e), (Throwable)e);
        }
        return result;
    }

    public static List<String> getListOfSelectedKey(FetchingSession<ResultRow> searchSession) throws Exception {
        List selectedRows = ((SelectableFetchingBuffer)searchSession.getBuffer()).getSelected();
        logger.trace((Object)("found " + selectedRows.size() + " selected rows"));
        int count = 0;
        ArrayList<String> keys = new ArrayList<String>(selectedRows.size());
        for (ResultRow row : selectedRows) {
            if (row.getOccurencesKey() == null || row.getOccurencesKey().length() <= 0) continue;
            keys.add(row.getOccurencesKey());
            count += row.getOccurencesCount();
        }
        logger.trace((Object)("found " + count + " occurrence points"));
        return keys;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OccurrenceKeys getListOfSelectedKeyByDataSource(String dataSource, ASLSession session) {
        block8: {
            OccurrenceJobUtil.logger.trace((Object)"getListOfSelectedKeyByDataSource...");
            occurrenceKeys = new OccurrenceKeys();
            keys = new ArrayList<String>();
            resulRowIt = null;
            count = 0;
            try {
                OccurrenceJobUtil.logger.trace((Object)("datasource name: " + dataSource));
                resultRowDao = DaoSession.getResultRowDAO((ASLSession)session);
                em = resultRowDao.createNewManager();
                try {
                    try {
                        query = em.createQuery("select t from ResultRow t where t.dataSourceName = '" + dataSource + "' AND t." + "selected" + " = true");
                        resulRowIt = query.getResultList().iterator();
                        ** GOTO lbl22
                    }
                    catch (Exception e) {
                        OccurrenceJobUtil.logger.error((Object)("Error in update: " + e.getMessage()), (Throwable)e);
                        em.close();
                        return null;
                    }
                }
                finally {
                    em.close();
lbl22:
                    // 1 sources

                    if (true) ** GOTO lbl31
                }
            }
            catch (Exception e) {
                OccurrenceJobUtil.logger.error((Object)("error in getListOfSelectedKeyByDataSource " + e));
                break block8;
            }
            do {
                if ((row = (ResultRow)resulRowIt.next()).getOccurencesKey() == null || row.getOccurencesKey().length() <= 0) continue;
                keys.add(row.getOccurencesKey());
                count += row.getOccurencesCount();
lbl31:
                // 3 sources

            } while (resulRowIt.hasNext());
            occurrenceKeys.setListKey(keys);
            occurrenceKeys.setTotalOccurrence(count);
        }
        OccurrenceJobUtil.logger.trace((Object)("found " + count + " occurrence points"));
        return occurrenceKeys;
    }

    /*
     * Exception decompiling
     */
    public static JobOccurrencesModel createOccurrenceJobOnServiceByKeys(JobOccurrencesModel jobModel, SpeciesService taxonomyService, OccurrenceJobPersistence occurrencesJobDao, List<String> keys, List<DataSource> dataSources, SaveFileFormat saveFileFormat, OccurrencesSaveEnum csvType, int expectedOccurrence) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String convertListKeyIntoStoreXMLString(List<String> keys) {
        String storeKeys = "";
        KeyStringList keyStringList = new KeyStringList();
        XStreamUtil xstreamUtil = new XStreamUtil("key", KeyStringList.class);
        for (String key : keys) {
            System.out.println("key :" + key);
            keyStringList.addKey(key);
        }
        storeKeys = xstreamUtil.toXML((Object)keyStringList);
        return storeKeys;
    }

    public static List<String> revertListKeyFromStoredXMLString(String storedKeysAsXml) {
        ArrayList<String> listKey = new ArrayList<String>();
        XStreamUtil xstreamUtil = new XStreamUtil("key", KeyStringList.class);
        KeyStringList keyStringList = (KeyStringList)xstreamUtil.fromXML(storedKeysAsXml);
        for (String key : keyStringList.getListKeys()) {
            listKey.add(key);
        }
        return listKey;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat() {
        if ($SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat != null) {
            return $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat;
        }
        int[] nArray = new int[SaveFileFormat.values().length];
        try {
            nArray[SaveFileFormat.CSV.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SaveFileFormat.DARWIN_CORE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SaveFileFormat.DARWIN_CORE_ARCHIVE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat = nArray;
        return nArray;
    }
}

