/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Converter;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class TaxonomyItemConverter
implements Converter<TaxonomyItem, TaxonomyRow> {
    protected Logger logger = Logger.getLogger(TaxonomyItemConverter.class);
    protected int id = 0;
    private ASLSession session;

    public TaxonomyItemConverter(ASLSession session) {
        this.session = session;
    }

    public TaxonomyRow convert(TaxonomyItem input) throws Exception {
        TaxonomyRow taxonomy = this.createTaxonomyRow(input);
        taxonomy.setParent(this.convertParentsTaxonomy(input));
        taxonomy.setBaseTaxonValue(NormalizeString.lowerCaseUpFirstChar((String)this.getTaxonomyValue("Kingdom", taxonomy)));
        if (taxonomy.getParents() != null && taxonomy.getParents().size() > 0) {
            taxonomy.setParentID("" + ((TaxonomyRow)taxonomy.getParents().get(0)).getId());
        }
        return taxonomy;
    }

    protected TaxonomyRow createTaxonomyRow(TaxonomyItem input) throws Exception {
        TaxonomyRow tax = new TaxonomyRow(this.id++);
        List listProperties = input.getProperties();
        if (listProperties != null) {
            for (ElementProperty elementProperty : listProperties) {
                tax.getProperties().add(new ItemParameter(elementProperty.getName(), elementProperty.getValue()));
            }
            tax.setExistsProperties(true);
        }
        if (input.getId() != null) {
            tax.setServiceId(input.getId());
        }
        if (input.getAuthor() != null && !input.getAuthor().isEmpty()) {
            tax.setAuthor(input.getAuthor());
        } else {
            tax.setAuthor("not found");
        }
        if (input.getCredits() != null && !input.getCredits().isEmpty()) {
            tax.setCredits(input.getCredits());
        } else {
            tax.setCredits("not found");
        }
        if (input.getLsid() != null && !input.getLsid().isEmpty()) {
            tax.setLsid(input.getLsid());
        } else {
            tax.setLsid("not found");
        }
        if (input.getProvider() != null && !input.getProvider().isEmpty()) {
            tax.setDataProviderId(input.getProvider());
            tax.setDataProviderName(input.getProvider());
        } else {
            tax.setDataProviderId("not found");
            tax.setDataProviderName("not found");
        }
        if (input.getCitation() != null && !input.getCitation().isEmpty()) {
            tax.setDataSetCitation(input.getCitation());
        } else {
            tax.setDataSetCitation("not found");
        }
        if (input.getRank() != null && !input.getRank().isEmpty()) {
            tax.setRank(NormalizeString.lowerCaseUpFirstChar((String)input.getRank()));
        } else {
            tax.setRank("not found");
        }
        if (input.getScientificName() != null && !input.getScientificName().isEmpty()) {
            tax.setName(input.getScientificName());
        } else {
            tax.setName("not found");
        }
        if (input.getStatus() != null) {
            if (input.getStatus().getRefId() != null && !input.getStatus().getRefId().isEmpty()) {
                tax.setStatusRefId(input.getStatus().getRefId());
            } else {
                tax.setStatusRefId("");
            }
            if (input.getStatus().getStatusAsString() != null && !input.getStatus().getStatusAsString().isEmpty()) {
                tax.setStatusRemarks(input.getStatus().getStatusAsString());
            } else {
                tax.setStatusRemarks("not found");
            }
            if (input.getStatus().getStatus() != null) {
                if (input.getStatus().getStatus().name() != null && !input.getStatus().getStatus().name().isEmpty()) {
                    tax.setStatusName(input.getStatus().getStatus().name());
                } else {
                    tax.setStatusName("not found");
                }
            }
        }
        if (input.getModified() != null) {
            tax.setDateModified(input.getModified().getTime().toString());
        }
        if (input.getCommonNames() != null) {
            for (org.gcube.data.spd.model.CommonName commonName : input.getCommonNames()) {
                CommonName com = new CommonName(commonName.getName(), commonName.getLanguage(), tax.getId());
                tax.getCommonNames().add(com);
                tax.setExistsCommonName(true);
            }
        }
        return tax;
    }

    private String getTaxonomyValue(String rank, TaxonomyRow taxon) {
        List listTaxonomy = taxon.getParents();
        for (TaxonomyRow taxonomyRow : listTaxonomy) {
            if (taxonomyRow.getRank().compareToIgnoreCase(rank) != 0) continue;
            return taxonomyRow.getName();
        }
        return "Unknown";
    }

    protected List<TaxonomyRow> convertParentsTaxonomy(TaxonomyItem taxon) throws Exception {
        if (taxon == null) {
            return null;
        }
        ArrayList<TaxonomyRow> listTaxonomy = new ArrayList<TaxonomyRow>();
        int i = 0;
        for (TaxonomyItem parent = taxon.getParent(); parent != null; parent = parent.getParent()) {
            TaxonomyRow row = this.createTaxonomyRow(parent);
            row.setParent(true);
            row.setParentIndex(i++);
            listTaxonomy.add(row);
        }
        return listTaxonomy;
    }
}

