/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.cluster;

import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.cluster.TablesForTaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.TaxonomyGridField;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class TabItemForTaxonomyRow {
    private TabPanel tabPanel;
    private AbstractImagePrototype imageLoading = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.loadingBalls());
    private EventBus eventBus;
    private TablesForTaxonomyRow tablesForTaxonomyRow;
    private TaxonomyRow currentTaxonomy;

    public void setCurrentTaxonomy(TaxonomyRow taxonomy) {
        this.currentTaxonomy = taxonomy;
    }

    public TabItemForTaxonomyRow(TablesForTaxonomyRow tablesForTaxonomyRow, TabPanel tabPanel2, EventBus eventBus2) {
        this.tablesForTaxonomyRow = tablesForTaxonomyRow;
        this.tabPanel = tabPanel2;
        this.eventBus = eventBus2;
    }

    public VerticalPanel getPanelClassificationForTaxonomy(TaxonomyRow taxonomy, String dataSource, boolean isNewTab) {
        VerticalPanel vpClassification = new VerticalPanel();
        vpClassification.setSpacing(5);
        if (taxonomy != null) {
            int parentsSize = taxonomy.getParents().size();
            int i = parentsSize - 1;
            while (i >= 0) {
                this.createPanelForParentTaxonomy((TaxonomyRow)taxonomy.getParents().get(i), vpClassification, taxonomy.getServiceId(), isNewTab, dataSource, i + 1);
                --i;
            }
            this.createPanelForParentTaxonomy(taxonomy, vpClassification, taxonomy.getServiceId(), isNewTab, dataSource, 0);
        }
        return vpClassification;
    }

    public void createPanelForParentTaxonomy(TaxonomyRow taxon, VerticalPanel vpClassification, String taxonomyServiceId, boolean isNewTab, String dataSource, int parentIndex) {
        if (taxon == null) {
            return;
        }
        HorizontalPanel hp = new HorizontalPanel();
        Text labelRank = !NormalizeString.isUndefined((String)taxon.getRank()) ? new Text(String.valueOf(taxon.getRank()) + ":") : new Text("Rank not found:");
        hp.add((Widget)labelRank);
        hp.setCellWidth((Widget)labelRank, "120px");
        Anchor anchor = this.getAnchorByTaxonomy(taxon, dataSource, parentIndex);
        hp.add((Widget)anchor);
        hp.setCellHorizontalAlignment((Widget)anchor, HorizontalPanel.ALIGN_LEFT);
        vpClassification.add((Widget)hp);
        if (taxon.getServiceId().compareTo(taxonomyServiceId) == 0 && isNewTab) {
            this.loadChildrenListOfItem(vpClassification, taxon, dataSource, taxon.getName(), -1);
        }
    }

    private void loadChildrenListOfItem(VerticalPanel vpClassification, TaxonomyRow taxonomyItem, String dataSource, String parentName, int parentIndex) {
        ContentPanel cp = new ContentPanel();
        cp.setId("cp" + taxonomyItem.getId());
        cp.setHeaderVisible(false);
        cp.setBodyBorder(false);
        cp.add((Widget)this.imageLoading.createImage());
        vpClassification.add((Widget)cp);
        System.out.println("Load child of item name: " + parentName + " parent id: " + taxonomyItem.getServiceId());
        SpeciesDiscovery.taxonomySearchService.loadListChildByParentId(taxonomyItem.getServiceId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        vpClassification.layout();
    }

    private boolean replaceLabelRank(HorizontalPanel hp, Text oldLabelRank, String rank) {
        if (!NormalizeString.isUndefined((String)rank)) {
            hp.remove((Widget)oldLabelRank);
            Text setlabelRank = new Text(String.valueOf(rank) + ":");
            hp.add((Widget)setlabelRank);
            hp.setCellWidth((Widget)setlabelRank, "120px");
            return true;
        }
        return false;
    }

    private Anchor getAnchorByTaxonomy(TaxonomyRow taxon, String dataSource, int parentIndex) {
        Anchor anchor = null;
        if (taxon != null) {
            anchor = new Anchor("<nobr>" + taxon.getName() + "</nobr>", true);
            anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return anchor;
    }

    void printParents(TaxonomyRow taxon) {
        System.out.println("principal " + taxon.getName());
        int i = 0;
        for (TaxonomyRow tax : taxon.getParents()) {
            System.out.println(String.valueOf(++i) + " parent name " + tax.getName());
        }
    }

    private Text getLabelByTaxonomy(TaxonomyRow taxon) {
        Text label = null;
        if (taxon != null) {
            label = !NormalizeString.isUndefined((String)taxon.getName()) ? new Text(taxon.getName()) : new Text("Name not found");
        }
        return label;
    }

    public Html getHTMLTableForTaxonomy(TaxonomyRow row, boolean isNewTab) {
        String dataProviderName = "";
        String dataSetCitation = "";
        String matchingAccordionTo = "";
        String rank = "";
        String statusName = "";
        String dateModified = "";
        String statusRemark = "";
        String author = "";
        String lsid = "";
        String credits = "";
        String propertiesHtml = "";
        if (row.getDataProviderName() != null) {
            dataProviderName = row.getDataProviderName();
        }
        if (row.getStatusName() != null) {
            statusName = row.getStatusName();
        }
        if (row.getDateModified() != null) {
            dateModified = row.getDateModified();
        }
        if (row.getDataSetCitation() != null) {
            dataSetCitation = row.getDataSetCitation();
        }
        if (row.getRank() != null) {
            rank = row.getRank();
        }
        if (row.getAccordingTo() != null) {
            matchingAccordionTo = row.getAccordingTo();
        }
        if (row.getStatusRemarks() != null) {
            statusRemark = row.getStatusRemarks();
        }
        if (row.getAuthor() != null) {
            author = row.getAuthor();
        }
        if (row.getLsid() != null) {
            lsid = row.getLsid();
        }
        if (row.getCredits() != null) {
            credits = row.getCredits();
        }
        if (row.getProperties() != null) {
            List hashProperties = row.getProperties();
            Collections.sort(hashProperties, ItemParameter.COMPARATOR);
            propertiesHtml = String.valueOf(propertiesHtml) + "<table class=\"parameters\">";
            for (ItemParameter itemParameter : hashProperties) {
                propertiesHtml = String.valueOf(propertiesHtml) + "<tr>\t<td class=\"title\">" + itemParameter.getKey() + "</td>" + "\t<td>" + itemParameter.getValue() + "</td>" + "</tr>";
            }
            propertiesHtml = String.valueOf(propertiesHtml) + "</table>";
        }
        String commonNames = "";
        if (row.getCommonNames() != null) {
            for (CommonName comName : row.getCommonNames()) {
                commonNames = String.valueOf(commonNames) + "<b>" + comName.getName() + "</b>" + " (" + comName.getLanguage() + ") - ";
            }
        }
        String table = "<table class=\"imagetable\">";
        table = String.valueOf(table) + "<tr>\t<td class=\"title\">" + TaxonomyGridField.COMMON_NAMES.getName() + " (Language)</td>" + "\t<td>" + commonNames + "</td>" + "</tr>";
        table = String.valueOf(table) + "<tr>\t<td class=\"title\">" + TaxonomyGridField.STATUSREFNAME.getName() + "</td>" + "\t<td>" + statusName + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.STATUS_REMARKS.getName() + "</td>" + "\t<td>" + statusRemark + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.DATASOURCE.getName() + "</td>" + "\t<td>" + dataProviderName + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.DATEMODIFIED.getName() + "</td>" + "\t<td>" + dateModified + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.MATCHING_RANK.getName() + "</td>" + "\t<td>" + rank + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.CITATION.getName() + "</td>" + "\t<td>" + dataSetCitation + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.LSID.getName() + "</td>" + "\t<td>" + lsid + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.AUTHOR.getName() + "</td>" + "\t<td>" + author + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.CREDITS.getName() + "</td>" + "\t<td>" + credits + "</td>" + "</tr>" + "<tr>" + "\t<td class=\"title\">" + TaxonomyGridField.PROPERTIES.getName() + "</td>" + "\t<td>" + propertiesHtml + "</td>" + "</tr>" + "</table>";
        return new Html(table);
    }

    public FlexTable getHTMLTableForTaxonomyWithRef(TaxonomyRow row, boolean isNewTab, String dataSource) {
        String dataProviderName = "";
        String dataSetCitation = "";
        String matchingAccordionTo = "";
        String rank = "";
        String statusName = "";
        String dateModified = "";
        String statusRemark = "";
        String author = "";
        String lsid = "";
        String credits = "";
        String refId = null;
        String propertiesHtml = "";
        if (row.getDataProviderName() != null) {
            dataProviderName = row.getDataProviderName();
        }
        if (row.getStatusName() != null) {
            statusName = row.getStatusName();
        }
        if (row.getDateModified() != null) {
            dateModified = row.getDateModified();
        }
        if (row.getDataSetCitation() != null) {
            dataSetCitation = row.getDataSetCitation();
        }
        if (row.getRank() != null) {
            rank = row.getRank();
        }
        if (row.getAccordingTo() != null) {
            matchingAccordionTo = row.getAccordingTo();
        }
        if (row.getStatusRemarks() != null) {
            statusRemark = row.getStatusRemarks();
        }
        if (row.getAuthor() != null) {
            author = row.getAuthor();
        }
        if (row.getLsid() != null) {
            lsid = row.getLsid();
        }
        if (row.getCredits() != null) {
            credits = row.getCredits();
        }
        if (row.getStatusRefId() != null && !row.getStatusRefId().isEmpty()) {
            refId = row.getStatusRefId();
        }
        if (row.getProperties() != null) {
            List hashProperties = row.getProperties();
            Collections.sort(hashProperties, ItemParameter.COMPARATOR);
            propertiesHtml = String.valueOf(propertiesHtml) + "<table class=\"parameters\">";
            for (ItemParameter itemParameter : hashProperties) {
                propertiesHtml = String.valueOf(propertiesHtml) + "<tr>\t<td class=\"title\">" + itemParameter.getKey() + "</td>" + "\t<td>" + itemParameter.getValue() + "</td>" + "</tr>";
            }
            propertiesHtml = String.valueOf(propertiesHtml) + "</table>";
        }
        String commonNames = "";
        if (row.getCommonNames() != null) {
            for (CommonName comName : row.getCommonNames()) {
                commonNames = String.valueOf(commonNames) + "<b>" + comName.getName() + "</b>" + " (" + comName.getLanguage() + ") - ";
            }
        }
        FlexTable flexTable = new FlexTable();
        flexTable.setStyleName("imagetable");
        flexTable.setWidget(0, 0, (Widget)new Label(TaxonomyGridField.COMMON_NAMES.getName()));
        flexTable.setWidget(0, 1, (Widget)new Html(commonNames));
        flexTable.setWidget(1, 0, (Widget)new Label(TaxonomyGridField.STATUSREFNAME.getName()));
        flexTable.setWidget(1, 1, (Widget)new Label(statusName));
        if (refId != null) {
            String status = !statusRemark.isEmpty() ? statusRemark : statusName;
            String referenceId = refId;
            flexTable.setWidget(2, 0, (Widget)new Label(TaxonomyGridField.STATUS_REMARKS.getName()));
            AbstractImagePrototype synonyms = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSearch());
            Image imageStatusRemark = synonyms.createImage();
            imageStatusRemark.setStyleName("image-load-synonyms");
            imageStatusRemark.setAltText("show accepted name");
            imageStatusRemark.setTitle("show accepted name");
            LayoutContainer layoutContainer = new LayoutContainer();
            Label labelStatusRemark = new Label(statusRemark);
            labelStatusRemark.addStyleName("status-of");
            layoutContainer.add((Widget)labelStatusRemark);
            imageStatusRemark.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            layoutContainer.add((Widget)labelStatusRemark);
            layoutContainer.add((Widget)imageStatusRemark);
            flexTable.setWidget(2, 1, (Widget)layoutContainer);
        } else {
            flexTable.setWidget(2, 0, (Widget)new Label(TaxonomyGridField.STATUS_REMARKS.getName()));
            flexTable.setWidget(2, 1, (Widget)new Label(statusRemark));
        }
        flexTable.setWidget(3, 0, (Widget)new Label(TaxonomyGridField.SYNONYMS.getName()));
        AbstractImagePrototype synonyms = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSearch());
        Image imageSynonyms = synonyms.createImage();
        imageSynonyms.setStyleName("image-load-synonyms");
        imageSynonyms.setAltText("show synonyms");
        imageSynonyms.setTitle("show synonyms");
        imageSynonyms.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        flexTable.setWidget(3, 1, (Widget)imageSynonyms);
        flexTable.setWidget(4, 0, (Widget)new Label(TaxonomyGridField.DATASOURCE.getName()));
        flexTable.setWidget(4, 1, (Widget)new Label(dataProviderName));
        flexTable.setWidget(5, 0, (Widget)new Label(TaxonomyGridField.DATEMODIFIED.getName()));
        flexTable.setWidget(5, 1, (Widget)new Label(dateModified));
        flexTable.setWidget(6, 0, (Widget)new Label(TaxonomyGridField.MATCHING_RANK.getName()));
        flexTable.setWidget(6, 1, (Widget)new Label(rank));
        flexTable.setWidget(7, 0, (Widget)new Label(TaxonomyGridField.CITATION.getName()));
        flexTable.setWidget(7, 1, (Widget)new Label(dataSetCitation));
        flexTable.setWidget(8, 0, (Widget)new Label(TaxonomyGridField.LSID.getName()));
        flexTable.setWidget(8, 1, (Widget)new Label(lsid));
        flexTable.setWidget(9, 0, (Widget)new Label(TaxonomyGridField.AUTHOR.getName()));
        flexTable.setWidget(9, 1, (Widget)new Label(author));
        flexTable.setWidget(10, 0, (Widget)new Label(TaxonomyGridField.CREDITS.getName()));
        flexTable.setWidget(10, 1, (Widget)new Label(credits));
        flexTable.setWidget(11, 0, (Widget)new Label(TaxonomyGridField.PROPERTIES.getName()));
        flexTable.setWidget(11, 1, (Widget)new Html(propertiesHtml));
        int i = 0;
        while (i < flexTable.getRowCount()) {
            flexTable.getFlexCellFormatter().setStyleName(i, 0, "title");
            ++i;
        }
        return flexTable;
    }

    public void getSynonymsByReferenceId(FlexTable flexTable, int row, int col, String refId, String dataSource, List<TaxonomyRow> parents) {
        LayoutContainer layoutContainer = new LayoutContainer();
        Image loading = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.loadingBalls()).createImage();
        layoutContainer.add((Widget)loading);
        flexTable.setWidget(row, col, (Widget)layoutContainer);
        SpeciesDiscovery.taxonomySearchService.retrieveSynonymsByRefId(refId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getTaxonomyByReferenceId(FlexTable flexTable, int row, int col, String statusRemark, String refId, String dataSource, List<TaxonomyRow> parents) {
        LayoutContainer layoutContainer = new LayoutContainer();
        Label status = new Label(statusRemark);
        layoutContainer.add((Widget)status);
        Image loading = AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.loadingBalls()).createImage();
        layoutContainer.add((Widget)loading);
        flexTable.setWidget(row, col, (Widget)layoutContainer);
        ArrayList<String> listId = new ArrayList<String>();
        listId.add(refId);
        SpeciesDiscovery.taxonomySearchService.retrieveTaxonomyByIds(listId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ boolean access$0(TabItemForTaxonomyRow tabItemForTaxonomyRow, HorizontalPanel horizontalPanel, Text text, String string) {
        return tabItemForTaxonomyRow.replaceLabelRank(horizontalPanel, text, string);
    }

    static /* synthetic */ Anchor access$1(TabItemForTaxonomyRow tabItemForTaxonomyRow, TaxonomyRow taxonomyRow, String string, int n) {
        return tabItemForTaxonomyRow.getAnchorByTaxonomy(taxonomyRow, string, n);
    }

    static /* synthetic */ TaxonomyRow access$2(TabItemForTaxonomyRow tabItemForTaxonomyRow) {
        return tabItemForTaxonomyRow.currentTaxonomy;
    }

    static /* synthetic */ TablesForTaxonomyRow access$3(TabItemForTaxonomyRow tabItemForTaxonomyRow) {
        return tabItemForTaxonomyRow.tablesForTaxonomyRow;
    }
}

