/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResult;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterCommonNameDataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class ClusterStructuresForTaxonomyRow
implements Serializable {
    private static final String DATA_SOURCE_NOT_FOUND = "Data Source not found";
    private static final long serialVersionUID = 2680552140187511057L;
    private Map<String, TaxonomyRow> hashResult = new HashMap();
    private HashMap<String, ClusterCommonNameDataSource<TaxonomyRow>> hashClusterCommonNamesDataSources = new HashMap();
    private HashMap<String, ArrayList<String>> hashClusterScientificNameTaxonomyRowID = new HashMap();
    private ArrayList<String> listFoundDataSources = new ArrayList();
    private ArrayList<String> listTaxonomyRowID;
    private boolean isReduced;
    private int totalRow;

    public ClusterStructuresForTaxonomyRow() {
    }

    public ClusterStructuresForTaxonomyRow(SearchResult<TaxonomyRow> result, boolean isReduced, int totalRow) {
        for (TaxonomyRow row : result.getResults()) {
            this.hashResult.put(row.getIdToString(), row);
        }
        this.isReduced = isReduced;
        this.totalRow = totalRow;
        this.createStructures(result.getResults());
        this.createStructuresForCommonName();
    }

    public void createStructures(ArrayList<TaxonomyRow> arrayListTax) {
        if (arrayListTax.size() > 0) {
            for (TaxonomyRow row : arrayListTax) {
                String keyScientificName;
                String dataSource = row.getDataProviderName();
                if (dataSource == null || dataSource.isEmpty()) {
                    dataSource = DATA_SOURCE_NOT_FOUND;
                }
                keyScientificName = (keyScientificName = row.getName()) == null || keyScientificName.isEmpty() ? "Undefined" : NormalizeString.lowerCaseUpFirstChar((String)keyScientificName);
                this.listTaxonomyRowID = this.hashClusterScientificNameTaxonomyRowID.get(keyScientificName) == null ? new ArrayList() : (ArrayList)this.hashClusterScientificNameTaxonomyRowID.get(keyScientificName);
                if (this.listFoundDataSources.indexOf(dataSource) == -1) {
                    this.listFoundDataSources.add(dataSource);
                }
                this.listTaxonomyRowID.add(row.getIdToString());
                this.hashClusterScientificNameTaxonomyRowID.put(keyScientificName, this.listTaxonomyRowID);
            }
        }
    }

    public void createStructuresForCommonName() {
        if (this.hashClusterScientificNameTaxonomyRowID.size() > 0) {
            for (String scientificName : this.hashClusterScientificNameTaxonomyRowID.keySet()) {
                ArrayList listTaxonomyRowID = (ArrayList)this.hashClusterScientificNameTaxonomyRowID.get(scientificName);
                ClusterCommonNameDataSource cluster = new ClusterCommonNameDataSource();
                int i = 0;
                while (i < listTaxonomyRowID.size()) {
                    TaxonomyRow row = (TaxonomyRow)this.hashResult.get(listTaxonomyRowID.get(i));
                    cluster.updateHashCommonNamesDataSources((FetchingElement)row);
                    ++i;
                }
                this.hashClusterCommonNamesDataSources.put(scientificName, cluster);
            }
        }
    }

    public ArrayList<String> getListFoundDataSources() {
        return this.listFoundDataSources;
    }

    public HashMap<String, ArrayList<String>> getHashClusterScientificNameTaxonomyRowID() {
        return this.hashClusterScientificNameTaxonomyRowID;
    }

    public HashMap<String, ClusterCommonNameDataSource<TaxonomyRow>> getHashClusterCommonNamesDataSources() {
        return this.hashClusterCommonNamesDataSources;
    }

    public ArrayList<TaxonomyRow> getResult() {
        return new ArrayList<TaxonomyRow>(this.hashResult.values());
    }

    public TaxonomyRow getTaxonomyRowByKey(String key) {
        return (TaxonomyRow)this.hashResult.get(key);
    }

    public boolean isReduced() {
        return this.isReduced;
    }

    public void setReduced(boolean isReduced) {
        this.isReduced = isReduced;
    }

    public int getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(int totalRow) {
        this.totalRow = totalRow;
    }
}

