/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.util.stream;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.util.Format;
import com.extjs.gxt.ui.client.util.IconHelper;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingLoader;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingLoaderListener;

public class StreamPagingToolBar
extends ToolBar {
    protected static final String DISPLAY_TEXT_COUNTING = "Displaying {0} - {1} of {2} and counting...";
    protected static final String DISPLAY_TEXT = "Displaying {0} - {1} of {2}";
    protected static final String PAGE_TEXT = "Page {0} of {1}";
    protected Button prev;
    protected Button next;
    protected LabelToolItem pageText;
    protected LabelToolItem displayText;
    protected AbstractImagePrototype prevImage = GXT.isHighContrastMode ? IconHelper.create((String)"gxt/themes/access/images/grid/page-prev.gif") : GXT.IMAGES.paging_toolbar_prev();
    protected AbstractImagePrototype prevImageDisabled = GXT.IMAGES.paging_toolbar_prev_disabled();
    protected AbstractImagePrototype nextImage = GXT.isHighContrastMode ? IconHelper.create((String)"gxt/themes/access/images/grid/page-next.gif") : GXT.IMAGES.paging_toolbar_next();
    protected AbstractImagePrototype nextImageDisabled = GXT.IMAGES.paging_toolbar_next_disabled();
    protected String nextText = GXT.MESSAGES.pagingToolBar_nextText();
    protected String prevText = GXT.MESSAGES.pagingToolBar_prevText();
    protected int currentPage = 0;
    protected int numPages = 0;
    protected boolean counting = false;
    protected int currentStartItem = 0;
    protected int currentEndItem = 0;
    protected int numItems = 0;
    protected int pageSize;
    protected StreamPagingLoader loader;
    protected Listener<ComponentEvent> componentListener = new /* Unavailable Anonymous Inner Class!! */;

    public StreamPagingToolBar() {
        this.init();
        this.update();
    }

    public void bind(StreamPagingLoader loader) {
        this.loader = loader;
        this.pageSize = loader.getPageSize();
        loader.addListener((StreamPagingLoaderListener)new /* Unavailable Anonymous Inner Class!! */);
        loader.getStore().addStoreListener((StoreListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void reset() {
        this.currentPage = 0;
        this.numPages = 0;
        this.counting = true;
        this.currentStartItem = 0;
        this.currentEndItem = 0;
        this.numItems = 0;
        this.update();
    }

    protected void beforeDataChange() {
        this.prev.setEnabled(false);
        this.next.setEnabled(false);
    }

    public void setStreamSize(int count) {
        this.numItems = count;
        this.update();
    }

    public void setStreamLoadingComplete(boolean counting) {
        this.counting = counting;
        this.update();
    }

    public void setCurrent(int currentStartItem, int currentEndItem) {
        this.currentStartItem = currentStartItem;
        this.currentEndItem = currentEndItem;
        this.update();
    }

    protected void init() {
        this.prev = new Button();
        this.prev.setToolTip(this.prevText);
        this.prev.addListener(Events.Disable, this.componentListener);
        this.prev.addListener(Events.Enable, this.componentListener);
        this.prev.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)this.prev);
        this.add((Component)new SeparatorToolItem());
        this.pageText = new LabelToolItem();
        this.pageText.setStyleName("my-paging-text");
        this.add((Component)this.pageText);
        this.add((Component)new SeparatorToolItem());
        this.next = new Button();
        this.next.setToolTip(this.nextText);
        this.next.addListener(Events.Disable, this.componentListener);
        this.next.addListener(Events.Enable, this.componentListener);
        this.next.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)this.next);
        this.add((Component)new FillToolItem());
        this.displayText = new LabelToolItem();
        this.displayText.setId(String.valueOf(this.getId()) + "-display");
        this.displayText.setStyleName("my-paging-display");
        this.add((Component)this.displayText);
    }

    protected void update() {
        this.updateSizes();
        this.updateButtons();
        this.updateImages();
        this.updateText();
    }

    protected void updateSizes() {
        this.currentPage = (int)Math.ceil((double)(this.currentStartItem + this.pageSize) / (double)this.pageSize);
        this.numPages = this.numItems < this.pageSize ? 1 : (int)Math.ceil((double)this.numItems / (double)this.pageSize);
    }

    protected void updateButtons() {
        this.next.setEnabled(this.currentPage != this.numPages);
        this.prev.setEnabled(this.currentPage != 1 && this.currentPage != 0);
    }

    protected void updateImages() {
        this.prev.setIcon(this.prev.isEnabled() ? this.prevImage : this.prevImageDisabled);
        this.next.setIcon(this.next.isEnabled() ? this.nextImage : this.nextImageDisabled);
    }

    protected void updateText() {
        Object[] params = new Object[]{this.currentPage, this.numPages};
        String page = Format.substitute((String)PAGE_TEXT, (Object[])params);
        this.pageText.setLabel(page);
        params = new Object[]{this.currentStartItem, this.currentEndItem, this.numItems};
        String display = Format.substitute((String)(this.counting ? DISPLAY_TEXT_COUNTING : DISPLAY_TEXT), (Object[])params);
        this.displayText.setLabel(display);
    }

    protected void previous() {
        if (this.loader != null) {
            this.loader.prevPage();
        }
    }

    protected void next() {
        if (this.loader != null) {
            this.loader.nextPage();
        }
    }
}

