/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.filterresult;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.ModelIconProvider;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.extjs.gxt.ui.client.widget.treepanel.TreePanel;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.portlets.user.speciesdiscovery.client.filterresult.ResultFilterPanelEnum;
import org.gcube.portlets.user.speciesdiscovery.client.filterresult.ResultFilterPanelInterface;
import org.gcube.portlets.user.speciesdiscovery.client.model.ClassificationModel;
import org.gcube.portlets.user.speciesdiscovery.shared.MainTaxonomicRankEnum;

public class ClassificationFilter
implements ResultFilterPanelInterface {
    private ContentPanel classifPanel = new ContentPanel();
    private TreePanel<ClassificationModel> treePanel;
    private TreeStore<ClassificationModel> store;
    private final String NORANK = "NO RANK";
    private SimpleComboBox<String> scbGroupByRank;
    private EventBus eventBus;
    private ToolBar toolbar = new ToolBar();
    private String currentRank;

    public ClassificationFilter() {
        this.setHeaderTitle();
        this.init();
        this.setAlphanumericStoreSorter();
        this.addDefaultNodes();
        this.addListners();
        this.setExpandTreeLevel("BiotaID", true);
        this.initComboGroupRankFilter();
        this.initToolBar();
        this.classifPanel.setTopComponent((Component)this.toolbar);
    }

    private SimpleComboBox<String> initComboGroupRankFilter() {
        ArrayList<String> ls = new ArrayList<String>();
        for (String rank : MainTaxonomicRankEnum.getListLabels()) {
            ls.add(rank);
        }
        this.scbGroupByRank = new SimpleComboBox();
        this.scbGroupByRank.setTypeAhead(true);
        this.scbGroupByRank.setEditable(false);
        this.scbGroupByRank.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.scbGroupByRank.add(ls);
        this.scbGroupByRank.setSimpleValue((Object)MainTaxonomicRankEnum.CLASS.getLabel());
        this.addListnerOnChangeClassificationFilter();
        return this.scbGroupByRank;
    }

    public String getGroupRank() {
        return (String)this.scbGroupByRank.getSimpleValue();
    }

    public void addListnerOnChangeClassificationFilter() {
        this.scbGroupByRank.addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initToolBar() {
        this.toolbar = new ToolBar();
        this.toolbar.setStyleName("toolbar-filter");
        this.toolbar.setStyleAttribute("padding-right", "1px");
        Html textGroupBy = new Html("Group by: ");
        textGroupBy.setStyleAttribute("font-style", "italic");
        textGroupBy.setStyleAttribute("font-size", "10px");
        textGroupBy.setStyleAttribute("padding-left", "5px");
        textGroupBy.setStyleAttribute("padding-right", "5px");
        this.scbGroupByRank.setStyleAttribute("margin-right", "2px");
        this.toolbar.add((Component)textGroupBy);
        this.toolbar.add((Component)textGroupBy);
        this.toolbar.add((Component)this.scbGroupByRank);
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    private void addDefaultNodes() {
        this.store.insert((ModelData)this.createRoot(), 0, false);
    }

    private void init() {
        this.store = new TreeStore();
        this.treePanel = new /* Unavailable Anonymous Inner Class!! */;
        this.treePanel.setIconProvider((ModelIconProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.treePanel.setStateful(false);
        this.treePanel.setId("treeClassification");
        this.treePanel.setDisplayProperty("name");
        this.treePanel.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.classifPanel.add((Widget)this.treePanel);
    }

    public ContentPanel getPanel() {
        return this.classifPanel;
    }

    public String getName() {
        return ResultFilterPanelEnum.CLASSIFICATION.getLabel();
    }

    public void setHeaderTitle() {
        this.classifPanel.setHeading(this.getName());
    }

    private ClassificationModel createRoot() {
        return new ClassificationModel("BiotaID", "Biota", null, null, false);
    }

    private void setAlphanumericStoreSorter() {
        this.store.setStoreSorter((StoreSorter)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setExpandTreeLevel(String identifier, boolean bool) {
        ClassificationModel item = this.getFileModelByIdentifier(identifier);
        if (item != null) {
            this.treePanel.setExpanded((ModelData)item, bool);
        }
    }

    public ClassificationModel getFileModelByIdentifier(String id) {
        return (ClassificationModel)this.treePanel.getStore().findModel("id", (Object)id);
    }

    public boolean renameItem(String identifier, String newName, Integer counter) {
        ClassificationModel fileTarget = this.getFileModelByIdentifier(identifier);
        return this.renameItem(fileTarget, newName, counter);
    }

    public boolean updateItemCounter(String parentId, String itemIdentifier, String itemName, String rank, String itemBaseTaxonId, String baseTaxonName, int counter) {
        ClassificationModel fileTarget = this.getFileModelByIdentifier(itemIdentifier);
        if (fileTarget == null) {
            ClassificationModel parent = this.getFileModelByIdentifier(parentId);
            this.store.add((ModelData)parent, (ModelData)new ClassificationModel(itemIdentifier, itemName, rank, itemBaseTaxonId, baseTaxonName, true, counter), false);
            fileTarget = this.getFileModelByIdentifier(itemIdentifier);
        } else {
            fileTarget.setCountOf(counter);
        }
        return this.renameItem(fileTarget, itemName, Integer.valueOf(counter));
    }

    private boolean renameItem(ClassificationModel fileTarget, String newName, Integer counter) {
        if (fileTarget != null) {
            Record record = this.treePanel.getStore().getRecord((ModelData)fileTarget);
            if (record != null) {
                if (counter != null) {
                    if (newName != null) {
                        record.set("name", (Object)(String.valueOf(newName) + "(" + counter + ")"));
                    } else {
                        record.set("name", (Object)(String.valueOf(fileTarget.getName()) + "(" + counter + ")"));
                    }
                } else if (newName != null) {
                    record.set("name", (Object)newName);
                } else {
                    record.set("name", (Object)fileTarget.getName());
                }
                return true;
            }
            Log.error((String)("Record Error: file target with " + fileTarget.getId() + " identifier not exist in store"));
        } else {
            Log.error((String)"Rename Error: file target not exist in store");
        }
        return false;
    }

    public void loadDataSourceClassification(HashMap<String, ClassificationModel> result, String rank) {
        this.currentRank = rank;
        for (String key : result.keySet()) {
            ClassificationModel cm = result.get(key);
            String name = String.valueOf(cm.getClassificationRank()) + " - " + cm.getName();
            String kingdomValue = cm.getBaseTaxonName();
            if (this.getFileModelByIdentifier(kingdomValue) == null) {
                this.store.add((ModelData)((ClassificationModel)this.store.getRootItems().get(0)), (ModelData)new ClassificationModel(kingdomValue, kingdomValue, cm.getBaseTaxonId(), cm.getBaseTaxonName(), false), false);
                this.setExpandTreeLevel(kingdomValue, true);
            }
            if (cm.getBaseTaxonName().equalsIgnoreCase("Unknown")) {
                name = rank.compareToIgnoreCase(cm.getClassificationRank()) == 0 ? String.valueOf(cm.getClassificationRank()) + " - " + cm.getName() : "[NO RANK " + rank + "] - " + cm.getClassificationRank();
            }
            this.updateItemCounter(kingdomValue, cm.getId(), name, cm.getClassificationRank(), cm.getBaseTaxonId(), cm.getBaseTaxonName(), cm.getCountOf());
        }
    }

    private void addListners() {
        this.treePanel.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void reset() {
        this.store.removeAll();
        this.addDefaultNodes();
        this.setExpandTreeLevel("BiotaID", true);
    }

    public void loadDataSource(HashMap<String, Integer> result) {
    }

    static /* synthetic */ EventBus access$0(ClassificationFilter classificationFilter) {
        return classificationFilter.eventBus;
    }

    static /* synthetic */ String access$1(ClassificationFilter classificationFilter) {
        return classificationFilter.currentRank;
    }

    static /* synthetic */ TreePanel access$2(ClassificationFilter classificationFilter) {
        return classificationFilter.treePanel;
    }
}

