package org.gcube.portlets.user.speciesdiscovery.client.cluster;

import java.util.List;

import org.gcube.portlets.user.speciesdiscovery.client.ConstantsSpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.event.CreateTaxonomyJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CreateTaxonomyJobEvent.TaxonomyJobType;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.IconAlign;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlexTable;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class TablesForTaxonomyRow {
	
	private TabPanel tabPanel;
	private EventBus eventBus;
	
	private List<TaxonomyRow> parents = null;
	private TabItemForTaxonomyRow tabTR;
	
//	private HashMap<String, TabItemForTaxonomyRow> hashTR = new HashMap<String, TabItemForTaxonomyRow>();

	
	public List<TaxonomyRow> getParents() {
		return parents;
	}

	public void setParents(List<TaxonomyRow> parents) {
		this.parents = parents;
	}


	public TablesForTaxonomyRow(TabPanel tabPanel2, EventBus eventBus2) {
		this.tabPanel = tabPanel2;
		this.eventBus = eventBus2;
		
		this.tabTR = new TabItemForTaxonomyRow(this, this.tabPanel, this.eventBus);
	}


	/**
	 * 
	 * @param taxonomy
	 * @param isNewTab -  set true if has been clicked a classification link, or false otherwise
	 * @return
	 */

	public VerticalPanel getPanelClassificationForTaxonomy(TaxonomyRow taxonomy, String dataSource, boolean isNewTab){
		
//		hashTR.put(taxonomy.getIdToString(),tabTR);
		
		tabTR.setCurrentTaxonomy(taxonomy);
		
		//DEBUG
		System.out.println("in getPanelClassificationForTaxonomy...");
		System.out.println("principal "+taxonomy.getName() + " id " + taxonomy.getServiceId()+" parents");
		int i=0;
		for (TaxonomyRow tax : taxonomy.getParents()) {
			System.out.println(++i + " parent name " + tax.getName());
		}
		
		return tabTR.getPanelClassificationForTaxonomy(taxonomy, dataSource, isNewTab);
	}


	/**
	 * 
	 * @param row
	 * @param isNewTab
	 * @param dataSource
	 * @param parentIndex
	 * @return
	 */
	public FlexTable getHTMLTableForTaxonomyWithRef(final TaxonomyRow row,boolean isNewTab, final String dataSource) {
		
		return tabTR.getHTMLTableForTaxonomyWithRef(row, isNewTab, dataSource);
	}
	
	
	protected ContentPanel getPanelForTaxonomy(TaxonomyRow taxon, String dataSource, boolean isNewTab) {
		
		ContentPanel contentPanel = new ContentPanel();
//		contentPanel.setLayout(new FitLayout());
		contentPanel.setHeaderVisible(false);
		contentPanel.setBodyBorder(false);
		
		contentPanel.setStyleAttribute("padding", "5px");
		contentPanel.setStyleAttribute("margin", "5px");
		
		VerticalPanel verticaPanel = new VerticalPanel();
		verticaPanel.setSize("100%", "100%");
		
		contentPanel.add(new Html("<br/><br/><p style=\"font-size:18px;\"><b>" + taxon.getName() + "</b></p><hr>"));
		contentPanel.add(new Html("<br/><br/><p style=\"font-size:12px;\"><b>Scientific Classification</b></p><br/>"));
		
		contentPanel.add(getPanelClassificationForTaxonomy(taxon, dataSource, isNewTab));
		
		contentPanel.add(getHTMLTableForTaxonomyWithRef(taxon, isNewTab, dataSource));

		return contentPanel;
	
	}
	
	protected void addTabItem(final TaxonomyRow taxon, final String dataSource){
		
		this.tabTR = new TabItemForTaxonomyRow(this, this.tabPanel, this.eventBus);

		TabItem tabItem = new TabItem();
//		tabItem.setLayout(new FitLayout());
		tabItem.setScrollMode(Scroll.AUTO);
		tabItem.setClosable(true);
		
		
		ContentPanel cp = new ContentPanel();
		cp.setHeaderVisible(false);
		ToolBar toolbar = new ToolBar();
	
		
		Button btnSaveTaxonomyChildren = new Button(ConstantsSpeciesDiscovery.SAVE_TAXONOMY_CHILDREN);  
		Menu formatSubMenu = new Menu();
		btnSaveTaxonomyChildren.setMenu(formatSubMenu);  
		btnSaveTaxonomyChildren.setScale(ButtonScale.SMALL);  
		btnSaveTaxonomyChildren.setIconAlign(IconAlign.TOP);  
		btnSaveTaxonomyChildren.setIcon(AbstractImagePrototype.create(Resources.INSTANCE.getSaveProducts()));
		btnSaveTaxonomyChildren.setToolTip(new ToolTipConfig(ConstantsSpeciesDiscovery.SAVE_TAXONOMY_CHILDREN, ConstantsSpeciesDiscovery.SAVES_TAXONOMY_CHILDREN_FROM_RESULT));
		
		MenuItem darwinCoreArchiveItem = new MenuItem(ConstantsSpeciesDiscovery.DARWIN_CORE_ARCHIVE);
		darwinCoreArchiveItem.setToolTip(new ToolTipConfig(ConstantsSpeciesDiscovery.SAVES_IN_DARWIN_CORE_ARCHIVE_FORMAT));
		darwinCoreArchiveItem.addSelectionListener(new SelectionListener<MenuEvent>() {

			@Override
			public void componentSelected(MenuEvent ce) {
				eventBus.fireEvent(new CreateTaxonomyJobEvent(taxon, dataSource, TaxonomyJobType.BYCHILDREN));			
			}
		});
		
		formatSubMenu.add(darwinCoreArchiveItem);
		toolbar.add(btnSaveTaxonomyChildren);
		
		cp.setTopComponent(toolbar);
		cp.setBodyBorder(false);
//		cp.setScrollMode(Scroll.AUTOY);
		
		String tabName = taxon.getName() + " ("+ dataSource + ")";
		tabItem.setText(tabName);
		
		cp.add(getPanelForTaxonomy(taxon, dataSource, true));
		
		tabItem.add(cp);
		
		tabPanel.add(tabItem);
			
	}
	

}
