/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.job.gislayer;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerGridJob;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerJobSpeciesProgressBar;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerWindowInfoJobsSpecies;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.JobGisLayerModel;

public class GisLayerJobSpeciesPanel
extends ContentPanel {
    private static GisLayerJobSpeciesPanel instance;
    private static ContentPanel cp;
    private ContentPanel vp;
    private static HashMap<String, GisLayerJobSpeciesProgressBar> hashProgressBars;
    private static HashMap<String, Boolean> hashLoadCompletedNotify;
    private static HashMap<String, ContentPanel> hashTableContentPanels;
    private static String LASTOPERATION;
    private Html lastOperation = new Html(LASTOPERATION);
    private LayoutContainer lc;
    private static String WINDOWTITLE;
    private static final String FAILED = "failed";
    private static final String COMPLETED = "completed";
    private static final String LOADING = "loading";
    private static final String PENDING = "pending";
    private static final String OPERATIONONE = "none";
    private static final String SAVING = "saving";
    private GisLayerGridJob gridJob;
    private EventBus eventBus;
    protected Window gisLayerJobWindow = new Window();

    public static synchronized GisLayerJobSpeciesPanel getInstance(EventBus eventBus) {
        if (instance == null) {
            instance = new GisLayerJobSpeciesPanel(eventBus);
        }
        return instance;
    }

    private GisLayerJobSpeciesPanel(EventBus eventBus) {
        this.eventBus = eventBus;
        this.gridJob = new GisLayerGridJob(eventBus);
        this.setHeaderVisible(false);
        this.setLayout((Layout)new FitLayout());
        this.createSpeciesJobWindow();
    }

    private void createSpeciesJobWindow() {
        this.lc = new LayoutContainer();
        this.lc.setStyleAttribute("margin", "5px");
        cp = new ContentPanel();
        cp.setBodyBorder(true);
        cp.setStyleAttribute("padding", "5px");
        cp.setLayout((Layout)new FitLayout());
        cp.add((Widget)this.gridJob);
        cp.setHeight(550);
        cp.setHeaderVisible(false);
        hashProgressBars = new HashMap();
        hashTableContentPanels = new HashMap();
        hashLoadCompletedNotify = new HashMap();
        cp.setScrollMode(Style.Scroll.AUTO);
        this.lastOperation.setHtml(LASTOPERATION + OPERATIONONE);
        this.lc.add((Widget)this.lastOperation);
        this.lc.add((Widget)cp);
        this.gisLayerJobWindow.setHeading(WINDOWTITLE);
        this.gisLayerJobWindow.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace16px()));
        this.gisLayerJobWindow.setSize(1020, 600);
        this.gisLayerJobWindow.setResizable(true);
        this.gisLayerJobWindow.setScrollMode(Style.Scroll.AUTOX);
        this.gisLayerJobWindow.add((Widget)this.lc);
    }

    public void addListJob(List<JobGisLayerModel> jobsModel) {
        for (JobGisLayerModel jobModel : jobsModel) {
            this.addJob(jobModel);
        }
    }

    public boolean addJob(JobGisLayerModel jobModel) {
        boolean isLoading = false;
        GisLayerJobSpeciesProgressBar jobsBar = (GisLayerJobSpeciesProgressBar)hashProgressBars.get(jobModel.getJobIdentifier());
        if (jobsBar != null) {
            GisLayerWindowInfoJobsSpecies win = (GisLayerWindowInfoJobsSpecies)jobsBar.getData("win");
            if (win != null) {
                win.updateDescription(jobModel);
                win.layout();
                jobsBar.setData("win", (Object)win);
            }
            if (jobsBar.isCompleted()) {
                return true;
            }
            this.updateProgressBarView(jobsBar, jobModel);
            this.gridJob.updateStatus(jobModel, jobsBar);
        } else {
            GisLayerJobSpeciesProgressBar jobProgressBar = new GisLayerJobSpeciesProgressBar(jobModel.getJobIdentifier(), jobModel.getDownloadState().toString());
            this.gridJob.addJobIntoGrid(jobModel, jobProgressBar);
            this.updateProgressBarView(jobProgressBar, jobModel);
            hashProgressBars.put(jobModel.getJobIdentifier(), jobProgressBar);
            hashLoadCompletedNotify.put(jobModel.getJobIdentifier(), false);
        }
        this.gridJob.layout();
        cp.layout();
        return isLoading;
    }

    private boolean updateProgressBarView(GisLayerJobSpeciesProgressBar jobsBar, JobGisLayerModel jobModel) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$DownloadState[jobModel.getDownloadState().ordinal()]) {
            case 1: {
                jobsBar.setProgressText(PENDING);
                break;
            }
            case 2: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getJobName() + " saving");
                jobsBar.getElement().getStyle().setBorderColor("#7093DB");
                jobsBar.setProgressText(SAVING);
                break;
            }
            case 3: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getJobName() + " completed");
                jobsBar.getElement().getStyle().setBorderColor("#000000");
                jobsBar.updateProgressWithoutPercentage(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(COMPLETED);
                break;
            }
            case 4: {
                if (jobModel.getPercentage() < 100.0f) {
                    jobsBar.setProgressText(LOADING);
                } else {
                    jobsBar.setProgressText(SAVING);
                }
                jobsBar.updateProgressWithPercentage(jobModel.getPercentage());
                return true;
            }
            case 5: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getJobName() + " saved");
                jobsBar.getElement().getStyle().setBorderColor("#000000");
                jobsBar.updateProgressWithoutPercentage(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(COMPLETED);
                break;
            }
            case 6: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.updateText("loading " + jobModel.getJobName() + " with failures");
                break;
            }
            case 7: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.setProgressText(FAILED);
                jobsBar.updateProgressWithPercentage(jobModel.getPercentage());
                jobsBar.setCompleted(true);
                jobsBar.updateText(FAILED);
                break;
            }
            case 8: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.updateText("loading " + jobModel.getJobName() + " with failures");
                jobsBar.updateProgressWithoutPercentage(100.0f);
                jobsBar.setCompleted(true);
            }
        }
        return false;
    }

    public void removeSpeciesJob(String hashHPKey) {
        ContentPanel cp = (ContentPanel)hashTableContentPanels.get(hashHPKey);
        this.vp.remove((Widget)cp);
        this.lastOperation.setHtml(LASTOPERATION + cp.getId() + " deleted");
        hashProgressBars.remove(hashHPKey);
        hashTableContentPanels.remove(hashHPKey);
        hashLoadCompletedNotify.remove(hashHPKey);
        this.vp.layout();
    }

    private void deleteProgressCompleted(List<String> progressIdFound) {
        GisLayerJobSpeciesProgressBar bulkPB;
        ArrayList<String> progressIdNotFound = new ArrayList<String>();
        for (String key : hashTableContentPanels.keySet()) {
            if (progressIdFound.contains(key)) continue;
            bulkPB = (GisLayerJobSpeciesProgressBar)hashProgressBars.get(key);
            this.lastOperation.setHtml(LASTOPERATION + bulkPB.getProgressText() + " uploading completed");
            progressIdNotFound.add(key);
        }
        for (String key : progressIdNotFound) {
            bulkPB = (GisLayerJobSpeciesProgressBar)hashProgressBars.get(key);
            this.lastOperation.setHtml(LASTOPERATION + bulkPB.getProgressText() + " uploading completed");
            hashProgressBars.remove(key);
            hashTableContentPanels.remove(key);
        }
        this.vp.layout();
        cp.layout();
    }

    public Window getGisLayerJobWindow() {
        return this.gisLayerJobWindow;
    }

    public void resetStructures() {
        this.gridJob.resetStore();
        hashProgressBars.clear();
        this.lastOperation.setHtml(LASTOPERATION);
        hashTableContentPanels.clear();
        hashLoadCompletedNotify.clear();
    }

    public GisLayerGridJob getGridJob() {
        return this.gridJob;
    }

    static {
        LASTOPERATION = "Last Operation: ";
        WINDOWTITLE = "Gis Layer Jobs";
    }
}

