/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.job;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.RenderTextFieldUtil;

public class SpeciesJobPanel
extends ContentPanel {
    protected static final String EMPTY = "Empty";
    protected static final String CURRENT_QUERY = "Current query: ";
    private ToolBar toolbar = new ToolBar();
    private TaxonomyJobSpeciesPanel taxonomyJobPanelInstance;
    private OccurrenceJobSpeciesPanel occurrenceJobPanelInstance;
    private GisLayerJobSpeciesPanel gisLayerJobPanelInstance;
    private Button btnTaxonomyJobs;
    private Button btnOccurrenceJobs;
    private Button btnGisLayerJobs;
    private int jobOccurrenceCount = 0;
    private int jobTaxonomyCount = 0;
    private int jobGisLayerCount = 0;
    private TextField<String> currentQuery;

    public SpeciesJobPanel(EventBus eventBus) {
        this.setTopComponent((Component)this.toolbar);
        this.setLayout((Layout)new FitLayout());
        this.setHeaderVisible(false);
        this.taxonomyJobPanelInstance = TaxonomyJobSpeciesPanel.getInstance((EventBus)eventBus);
        this.occurrenceJobPanelInstance = OccurrenceJobSpeciesPanel.getInstance((EventBus)eventBus);
        this.gisLayerJobPanelInstance = GisLayerJobSpeciesPanel.getInstance((EventBus)eventBus);
        this.createOccurrencesToolBar();
        this.toolbar.add((Component)new SeparatorToolItem());
        this.createTaxonomyToolBar();
        this.toolbar.add((Component)new SeparatorToolItem());
        this.createGisLayerToolBar();
        Text txtLastQuery = new Text(CURRENT_QUERY);
        txtLastQuery.setStyleAttribute("padding-right", "2px");
        txtLastQuery.setStyleAttribute("color", "gray");
        this.currentQuery = new TextField();
        this.currentQuery.setReadOnly(true);
        this.currentQuery.setWidth(400);
        this.currentQuery.setValue((Object)EMPTY);
        this.toolbar.add((Component)new FillToolItem());
        this.toolbar.add((Component)txtLastQuery);
        this.toolbar.add((Component)this.currentQuery);
        RenderTextFieldUtil.setTextFieldAttr((Field)this.currentQuery, (String)"background", (String)"none");
    }

    private void createOccurrencesToolBar() {
        this.btnTaxonomyJobs = new Button("Species Taxonomy Jobs");
        this.btnTaxonomyJobs.setScale(Style.ButtonScale.MEDIUM);
        this.setIconTaxonomyByCounter(0);
        this.btnTaxonomyJobs.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.btnTaxonomyJobs);
    }

    private void resetTaxonoyCouter() {
        this.jobTaxonomyCount = 0;
        this.setIconTaxonomyByCounter(0);
    }

    private void createTaxonomyToolBar() {
        this.btnOccurrenceJobs = new Button("Species Occurrence Jobs");
        this.btnOccurrenceJobs.setScale(Style.ButtonScale.MEDIUM);
        this.setIconOccurrenceByCounter(0);
        this.btnOccurrenceJobs.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.btnOccurrenceJobs);
    }

    private void createGisLayerToolBar() {
        this.btnGisLayerJobs = new Button("Gis Layer Jobs");
        this.btnGisLayerJobs.setScale(Style.ButtonScale.MEDIUM);
        this.setIconGisLayerByCounter(0);
        this.btnGisLayerJobs.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.btnGisLayerJobs);
    }

    public void setLastQuery(String query) {
        this.currentQuery.setValue((Object)query);
    }

    public void setLastQueryAsEmpty() {
        this.currentQuery.setValue((Object)EMPTY);
    }

    private void resetOccurrenceCounter() {
        this.jobOccurrenceCount = 0;
        this.setIconOccurrenceByCounter(0);
    }

    private void resetGisLayerCounter() {
        this.jobGisLayerCount = 0;
        this.setIconGisLayerByCounter(0);
    }

    public void setIconOccurrenceByCounter(int count) {
        this.jobOccurrenceCount += count;
        switch (this.jobOccurrenceCount) {
            case 0: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace()));
                break;
            }
            case 1: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace1()));
                break;
            }
            case 2: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace2()));
                break;
            }
            case 3: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace3()));
                break;
            }
            case 4: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace4()));
                break;
            }
            default: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace4More()));
            }
        }
        this.toolbar.layout();
    }

    public void setIconGisLayerByCounter(int count) {
        this.jobGisLayerCount += count;
        switch (this.jobGisLayerCount) {
            case 0: {
                this.btnGisLayerJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe()));
                break;
            }
            case 1: {
                this.btnGisLayerJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe1()));
                break;
            }
            case 2: {
                this.btnGisLayerJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe2()));
                break;
            }
            case 3: {
                this.btnGisLayerJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe3()));
                break;
            }
            case 4: {
                this.btnGisLayerJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe4()));
                break;
            }
            default: {
                this.btnGisLayerJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getGlobe4More()));
            }
        }
        this.toolbar.layout();
    }

    public void setIconTaxonomyByCounter(int count) {
        this.jobTaxonomyCount += count;
        switch (this.jobTaxonomyCount) {
            case 0: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy()));
                break;
            }
            case 1: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy1()));
                break;
            }
            case 2: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy2()));
                break;
            }
            case 3: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy3()));
                break;
            }
            case 4: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy4()));
                break;
            }
            default: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy4More()));
            }
        }
        this.toolbar.layout();
    }

    static /* synthetic */ void access$000(SpeciesJobPanel x0) {
        x0.resetTaxonoyCouter();
    }

    static /* synthetic */ TaxonomyJobSpeciesPanel access$100(SpeciesJobPanel x0) {
        return x0.taxonomyJobPanelInstance;
    }

    static /* synthetic */ void access$200(SpeciesJobPanel x0) {
        x0.resetOccurrenceCounter();
    }

    static /* synthetic */ OccurrenceJobSpeciesPanel access$300(SpeciesJobPanel x0) {
        return x0.occurrenceJobPanelInstance;
    }

    static /* synthetic */ void access$400(SpeciesJobPanel x0) {
        x0.resetGisLayerCounter();
    }

    static /* synthetic */ GisLayerJobSpeciesPanel access$500(SpeciesJobPanel x0) {
        return x0.gisLayerJobPanelInstance;
    }
}

