/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyGridJob;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyJobSpeciesProgressBar;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyWindowInfoJobsSpecies;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.JobTaxonomyModel;

public class TaxonomyJobSpeciesPanel
extends ContentPanel {
    private static TaxonomyJobSpeciesPanel instance;
    private static ContentPanel cp;
    private ContentPanel vp;
    private static HashMap<String, TaxonomyJobSpeciesProgressBar> hashProgressBars;
    private static HashMap<String, Boolean> hashLoadCompletedNotify;
    private static HashMap<String, ContentPanel> hashTableContentPanels;
    private static String LASTOPERATION;
    private Html lastOperation = new Html(LASTOPERATION);
    private LayoutContainer lc;
    private static String WINDOWTITLE;
    private static final String FAILED = "failed";
    private static final String COMPLETED = "completed";
    private static final String LOADING = "loading";
    private static final String PENDING = "pending";
    private static final String OPERATIONONE = "none";
    private static final String SAVING = "saving";
    private TaxonomyGridJob gridJob;
    private EventBus eventBus;
    protected Window speciesJobWindow = new Window();

    public static synchronized TaxonomyJobSpeciesPanel getInstance(EventBus eventBus) {
        if (instance == null) {
            instance = new TaxonomyJobSpeciesPanel(eventBus);
        }
        return instance;
    }

    private TaxonomyJobSpeciesPanel(EventBus eventBus) {
        this.eventBus = eventBus;
        this.gridJob = new TaxonomyGridJob(eventBus);
        this.speciesJobWindow.setSize(1020, 600);
        this.setHeaderVisible(false);
        this.setLayout((Layout)new FitLayout());
        this.createSpeciesJobWindow();
    }

    private void createSpeciesJobWindow() {
        this.lc = new LayoutContainer();
        this.lc.setStyleAttribute("margin", "5px");
        cp = new ContentPanel();
        cp.setBodyBorder(true);
        cp.setStyleAttribute("padding", "5px");
        cp.setLayout((Layout)new FitLayout());
        cp.add((Widget)this.gridJob);
        cp.setHeight(550);
        cp.setHeaderVisible(false);
        hashProgressBars = new HashMap();
        hashTableContentPanels = new HashMap();
        hashLoadCompletedNotify = new HashMap();
        cp.setScrollMode(Style.Scroll.AUTO);
        this.lastOperation.setHtml(LASTOPERATION + OPERATIONONE);
        this.lc.add((Widget)this.lastOperation);
        this.lc.add((Widget)cp);
        this.speciesJobWindow.setHeading(WINDOWTITLE);
        this.speciesJobWindow.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy16px()));
        this.speciesJobWindow.setResizable(false);
        this.speciesJobWindow.add((Widget)this.lc);
    }

    public boolean addListJob(List<JobTaxonomyModel> jobsModel) {
        boolean isLoading = false;
        for (JobTaxonomyModel jobModel : jobsModel) {
            isLoading = this.addJob(jobModel);
        }
        return isLoading;
    }

    public boolean addJob(JobTaxonomyModel jobModel) {
        boolean isLoading = false;
        TaxonomyJobSpeciesProgressBar jobsBar = (TaxonomyJobSpeciesProgressBar)hashProgressBars.get(jobModel.getIdentifier());
        if (jobsBar != null) {
            TaxonomyWindowInfoJobsSpecies win = (TaxonomyWindowInfoJobsSpecies)jobsBar.getData("win");
            if (win != null) {
                win.updateListStore(jobModel);
                win.layout();
                jobsBar.setData("win", (Object)win);
            }
            if (jobsBar.isCompleted()) {
                return true;
            }
            this.updateProgressBarView(jobsBar, jobModel);
            this.gridJob.updateStatus(jobModel, jobsBar);
        } else {
            TaxonomyJobSpeciesProgressBar jobProgressBar = new TaxonomyJobSpeciesProgressBar(jobModel.getIdentifier(), jobModel.getDownloadState().toString());
            this.gridJob.addJobIntoGrid(jobModel, jobProgressBar);
            this.updateProgressBarView(jobProgressBar, jobModel);
            hashProgressBars.put(jobModel.getIdentifier(), jobProgressBar);
            hashLoadCompletedNotify.put(jobModel.getIdentifier(), false);
        }
        this.gridJob.layout();
        cp.layout();
        return isLoading;
    }

    private boolean updateProgressBarView(TaxonomyJobSpeciesProgressBar jobsBar, JobTaxonomyModel jobModel) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$DownloadState[jobModel.getDownloadState().ordinal()]) {
            case 1: {
                jobsBar.setProgressText(PENDING);
                break;
            }
            case 2: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getName() + " saving");
                jobsBar.getElement().getStyle().setBorderColor("#7093DB");
                jobsBar.progressStart();
                jobsBar.setProgressText(SAVING);
                break;
            }
            case 3: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getName() + " completed");
                jobsBar.getElement().getStyle().setBorderColor("#000000");
                jobsBar.progressStop();
                jobsBar.updateProgress(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(COMPLETED);
                break;
            }
            case 4: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getName() + " saved");
                jobsBar.getElement().getStyle().setBorderColor("#000000");
                jobsBar.progressStop();
                jobsBar.updateProgress(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(COMPLETED);
                break;
            }
            case 5: {
                jobsBar.setProgressText(LOADING);
                jobsBar.progressStart();
                return true;
            }
            case 6: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                String job = jobModel.getFailuresNumbers() == 1 ? "job" : "jobs";
                jobsBar.updateText("loading " + jobModel.getName() + " with " + jobModel.getFailuresNumbers() + " " + job + " " + FAILED);
                break;
            }
            case 7: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.progressStop();
                jobsBar.updateProgress(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(FAILED);
                break;
            }
            case 8: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                String job = jobModel.getFailuresNumbers() == 1 ? "job" : "jobs";
                jobsBar.updateText("job completed with " + jobModel.getFailuresNumbers() + " " + job + " " + FAILED);
                jobsBar.updateProgress(100.0f);
                jobsBar.setCompleted(true);
                break;
            }
        }
        return false;
    }

    public void removeSpeciesJob(String hashHPKey) {
        ContentPanel cp = (ContentPanel)hashTableContentPanels.get(hashHPKey);
        this.vp.remove((Widget)cp);
        this.lastOperation.setHtml(LASTOPERATION + cp.getId() + " deleted");
        hashProgressBars.remove(hashHPKey);
        hashTableContentPanels.remove(hashHPKey);
        hashLoadCompletedNotify.remove(hashHPKey);
        this.vp.layout();
    }

    private void deleteProgressCompleted(List<String> progressIdFound) {
        TaxonomyJobSpeciesProgressBar bulkPB;
        ArrayList<String> progressIdNotFound = new ArrayList<String>();
        for (String key : hashTableContentPanels.keySet()) {
            if (progressIdFound.contains(key)) continue;
            bulkPB = (TaxonomyJobSpeciesProgressBar)hashProgressBars.get(key);
            this.lastOperation.setHtml(LASTOPERATION + bulkPB.getProgressText() + " uploading completed");
            progressIdNotFound.add(key);
        }
        for (String key : progressIdNotFound) {
            bulkPB = (TaxonomyJobSpeciesProgressBar)hashProgressBars.get(key);
            this.lastOperation.setHtml(LASTOPERATION + bulkPB.getProgressText() + " uploading completed");
            hashProgressBars.remove(key);
            hashTableContentPanels.remove(key);
        }
        this.vp.layout();
        cp.layout();
    }

    public Window getSpeciesJobWindow() {
        return this.speciesJobWindow;
    }

    public void resetStructures() {
        this.gridJob.resetStore();
        hashProgressBars.clear();
        this.lastOperation.setHtml(LASTOPERATION);
        hashTableContentPanels.clear();
        hashLoadCompletedNotify.clear();
    }

    public TaxonomyGridJob getGridJob() {
        return this.gridJob;
    }

    static {
        LASTOPERATION = "Last Operation: ";
        WINDOWTITLE = "Species Taxonomy Jobs";
    }
}

