/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.cluster;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.cluster.TabItemForTaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;

public class TablesForTaxonomyRow {
    private TabPanel tabPanel;
    private EventBus eventBus;
    private List<TaxonomyRow> parents = null;
    private TabItemForTaxonomyRow tabTR;

    public List<TaxonomyRow> getParents() {
        return this.parents;
    }

    public void setParents(List<TaxonomyRow> parents) {
        this.parents = parents;
    }

    public TablesForTaxonomyRow(TabPanel tabPanel2, EventBus eventBus2) {
        this.tabPanel = tabPanel2;
        this.eventBus = eventBus2;
        this.tabTR = new TabItemForTaxonomyRow(this, this.tabPanel, this.eventBus);
    }

    public VerticalPanel getPanelClassificationForTaxonomy(TaxonomyRow taxonomy, String dataSource, boolean isNewTab) {
        this.tabTR.setCurrentTaxonomy(taxonomy);
        return this.tabTR.getPanelClassificationForTaxonomy(taxonomy, dataSource, isNewTab);
    }

    public FlexTable getHTMLTableForTaxonomyWithRef(TaxonomyRow row, boolean isNewTab, String dataSource) {
        return this.tabTR.getHTMLTableForTaxonomyWithRef(row, isNewTab, dataSource);
    }

    protected ContentPanel getPanelForTaxonomy(TaxonomyRow taxon, String dataSource, boolean isNewTab) {
        ContentPanel contentPanel = new ContentPanel();
        contentPanel.setHeaderVisible(false);
        contentPanel.setBodyBorder(false);
        contentPanel.setStyleAttribute("padding", "5px");
        contentPanel.setStyleAttribute("margin", "5px");
        VerticalPanel verticaPanel = new VerticalPanel();
        verticaPanel.setSize("100%", "100%");
        contentPanel.add((Widget)new Html("<br/><br/><p style=\"font-size:18px;\"><b>" + taxon.getName() + "</b></p><hr>"));
        contentPanel.add((Widget)new Html("<br/><br/><p style=\"font-size:12px;\"><b>Scientific Classification</b></p><br/>"));
        contentPanel.add((Widget)this.getPanelClassificationForTaxonomy(taxon, dataSource, isNewTab));
        contentPanel.add((Widget)this.getHTMLTableForTaxonomyWithRef(taxon, isNewTab, dataSource));
        return contentPanel;
    }

    protected void addTabItem(TaxonomyRow taxon, String dataSource) {
        this.tabTR = new TabItemForTaxonomyRow(this, this.tabPanel, this.eventBus);
        TabItem tabItem = new TabItem();
        tabItem.setScrollMode(Style.Scroll.AUTO);
        tabItem.setClosable(true);
        ContentPanel cp = new ContentPanel();
        cp.setHeaderVisible(false);
        ToolBar toolbar = new ToolBar();
        Button btnSaveTaxonomyChildren = new Button("Save Taxonomy Children");
        Menu formatSubMenu = new Menu();
        btnSaveTaxonomyChildren.setMenu(formatSubMenu);
        btnSaveTaxonomyChildren.setScale(Style.ButtonScale.SMALL);
        btnSaveTaxonomyChildren.setIconAlign(Style.IconAlign.TOP);
        btnSaveTaxonomyChildren.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSaveProducts()));
        btnSaveTaxonomyChildren.setToolTip(new ToolTipConfig("Save Taxonomy Children", "Saves taxonomy children from result."));
        MenuItem darwinCoreArchiveItem = new MenuItem("Darwin Core Archive");
        darwinCoreArchiveItem.setToolTip(new ToolTipConfig("Saves in Darwin Core Archive format"));
        darwinCoreArchiveItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        formatSubMenu.add((Component)darwinCoreArchiveItem);
        toolbar.add((Component)btnSaveTaxonomyChildren);
        cp.setTopComponent((Component)toolbar);
        cp.setBodyBorder(false);
        String tabName = taxon.getName() + " (" + dataSource + ")";
        tabItem.setText(tabName);
        cp.add((Widget)this.getPanelForTaxonomy(taxon, dataSource, true));
        tabItem.add((Widget)cp);
        this.tabPanel.add(tabItem);
    }

    static /* synthetic */ EventBus access$000(TablesForTaxonomyRow x0) {
        return x0.eventBus;
    }
}

