/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.asl;

import javax.persistence.EntityManagerFactory;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.ResultRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.service.SpeciesService;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingSession;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.Occurrence;

public class SessionUtil {
    public static final String SPECIES_SERVICE = "SPECIES_SERVICE";
    public static final String SEARCH_SESSION = "SEARCH_SESSION";
    public static final String TAXONOMY_OCCURRENCE = "TAXONOMY_OCCURRENCE";
    public static final String CONNECTION_SOURCE = "CONNECTION_SOURCE";
    public static final String USERNAME_ATTRIBUTE = "username";
    public static final String ENTITY_FACTORY = "ENTITY_FACTORY";
    public static final String EJB_RESULT_ROW = "EJB_RESULT_ROW";
    public static final String EJB_TAXON_ROW = "EJB_TAXON_ROW";
    public static final String EJB_OCCURENCE = "EJB_OCCURENCE";
    public static final String EJB_TAXONOMY = "EJB_TAXONOMY";
    public static final String EJB_OCCURRENCES_JOB = "EJB_OCCURRENCES_JOB";
    public static final String EJB_TAXONOMY_JOB = "EJB_TAXONOMY_JOB";
    protected static Logger logger = Logger.getLogger(SessionUtil.class);

    public static EntityManagerFactory getEntityManagerFactory(ASLSession session) {
        return (EntityManagerFactory)session.getAttribute(ENTITY_FACTORY);
    }

    public static void setEntityManagerFactory(ASLSession session, EntityManagerFactory factory) {
        session.setAttribute(ENTITY_FACTORY, (Object)factory);
    }

    public static SpeciesService getService(ASLSession session) throws Exception {
        SpeciesService service = (SpeciesService)session.getAttribute(SPECIES_SERVICE);
        if (service == null) {
            logger.trace((Object)"Service not found, creating it");
            GCUBEScope scope = session.getScope();
            service = new SpeciesService(scope, session);
            session.setAttribute(SPECIES_SERVICE, (Object)service);
        }
        return service;
    }

    public static FetchingSession<? extends FetchingElement> getCurrentSearchSession(ASLSession session) {
        return (FetchingSession)session.getAttribute(SEARCH_SESSION);
    }

    public static void setCurrentSearchSession(ASLSession session, FetchingSession<? extends FetchingElement> searchSession) {
        session.setAttribute(SEARCH_SESSION, searchSession);
    }

    public static FetchingSession<Occurrence> getCurrentOccurrenceSession(ASLSession session) {
        return (FetchingSession)session.getAttribute(TAXONOMY_OCCURRENCE);
    }

    public static void setCurrentOccurrenceSession(ASLSession session, FetchingSession<Occurrence> searchSession) {
        session.setAttribute(TAXONOMY_OCCURRENCE, searchSession);
    }

    public static ASLSession getAslSession(HttpSession httpSession) {
        String sessionID = httpSession.getId();
        String user = (String)httpSession.getAttribute(USERNAME_ATTRIBUTE);
        if (user == null) {
            logger.error((Object)"TaxonomySearchServiceImpl STARTING IN TEST MODE - NO USER FOUND");
            user = "test.user";
            httpSession.setAttribute(USERNAME_ATTRIBUTE, (Object)user);
            ASLSession session = SessionManager.getInstance().getASLSession(sessionID, user);
            session.setScope("/gcube/devsec");
            return session;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public static void setCurrentEJBResultRow(ASLSession session, ResultRowPersistence resultRowPersistence) {
        session.setAttribute(EJB_RESULT_ROW, (Object)resultRowPersistence);
    }

    public static ResultRowPersistence getCurrentEJBResultRow(ASLSession session) {
        return (ResultRowPersistence)session.getAttribute(EJB_RESULT_ROW);
    }

    public static void setCurrentEJBTaxonRow(ASLSession session, TaxonRowPersistence taxonRowPersistence) {
        session.setAttribute(EJB_TAXON_ROW, (Object)taxonRowPersistence);
    }

    public static TaxonRowPersistence getCurrentEJBTaxonRow(ASLSession session) {
        return (TaxonRowPersistence)session.getAttribute(EJB_TAXON_ROW);
    }

    public static void setCurrentEJBOccurrence(ASLSession session, OccurrenceRowPersistence occurrenceRowPersistence) {
        session.setAttribute(EJB_OCCURENCE, (Object)occurrenceRowPersistence);
    }

    public static OccurrenceRowPersistence getCurrentEJBOccurrence(ASLSession session) {
        return (OccurrenceRowPersistence)session.getAttribute(EJB_OCCURENCE);
    }

    public static TaxonomyRowPersistence getCurrentEJBTaxonomyItem(ASLSession session) {
        return (TaxonomyRowPersistence)session.getAttribute(EJB_TAXONOMY);
    }

    public static void setCurrentEJBTaxonomyItem(ASLSession session, TaxonomyRowPersistence taxonomyItemDAO) {
        session.setAttribute(EJB_TAXONOMY, (Object)taxonomyItemDAO);
    }

    public static void setCurrentEJBOccurrencesJob(ASLSession session, OccurrenceJobPersistence occurrenceJobPersistence) {
        session.setAttribute(EJB_OCCURRENCES_JOB, (Object)occurrenceJobPersistence);
    }

    public static OccurrenceJobPersistence getCurrentDaoOccurrencesJob(ASLSession session) {
        return (OccurrenceJobPersistence)session.getAttribute(EJB_OCCURRENCES_JOB);
    }

    public static TaxonomyJobPersistence getCurrentDAOTaxonomyJob(ASLSession session) {
        return (TaxonomyJobPersistence)session.getAttribute(EJB_TAXONOMY_JOB);
    }

    public static void setCurrentDAOTaxonomyJob(ASLSession session, TaxonomyJobPersistence taxonomyJobPeristence) {
        session.setAttribute(EJB_TAXONOMY_JOB, (Object)taxonomyJobPeristence);
    }
}

