/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.OccurrencePoint;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Converter;
import org.gcube.portlets.user.speciesdiscovery.server.util.XStreamUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.Occurrence;

/*
 * Exception performing whole class analysis ignored.
 */
public class OccurrenceConverter
implements Converter<OccurrencePoint, Occurrence> {
    protected static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    protected int id = 0;
    private XStreamUtil<ItemParameter> xstreamUtil = new XStreamUtil(XStreamUtil.AliasItem.OCCURRECENCE, ItemParameter.class);

    public Occurrence convert(OccurrencePoint input) throws Exception {
        Occurrence occurrence = new Occurrence();
        occurrence.setId(this.id++);
        occurrence.setServiceId(input.getId());
        List listProperties = input.getProperties();
        if (listProperties != null) {
            for (ElementProperty elementProperty : listProperties) {
                occurrence.getProperties().add(new ItemParameter(elementProperty.getName(), elementProperty.getValue()));
            }
            occurrence.setExistsProperties(true);
        }
        if (input.getAuthor() != null && !input.getAuthor().isEmpty()) {
            occurrence.setAuthor(StringEscapeUtils.escapeSql((String)input.getAuthor()));
        } else {
            occurrence.setAuthor("not found");
        }
        if (input.getCredits() != null && !input.getCredits().isEmpty()) {
            occurrence.setCredits(StringEscapeUtils.escapeSql((String)input.getCredits()));
        } else {
            occurrence.setCredits("not found");
        }
        if (input.getDataSet() != null) {
            occurrence.setDataSet(OccurrenceConverter.cleanValueEscapeSql((String)input.getDataSet().getName()));
            if (input.getDataSet().getDataProvider() != null) {
                occurrence.setDataProvider(OccurrenceConverter.cleanValueEscapeSql((String)input.getDataSet().getDataProvider().getName()));
            } else {
                occurrence.setDataProvider("not found");
            }
        } else {
            occurrence.setDataSet("not found");
            occurrence.setDataProvider("not found");
        }
        occurrence.setDataSource(OccurrenceConverter.cleanValueEscapeSql((String)input.getProvider()));
        occurrence.setInstitutionCode(OccurrenceConverter.cleanValueEscapeSql((String)input.getInstitutionCode()));
        occurrence.setCollectionCode(OccurrenceConverter.cleanValueEscapeSql((String)input.getCollectionCode()));
        occurrence.setCatalogueNumber(OccurrenceConverter.cleanValueEscapeSql((String)input.getCatalogueNumber()));
        occurrence.setRecordedBy(OccurrenceConverter.cleanValueEscapeSql((String)input.getRecordedBy()));
        occurrence.setEventDate(OccurrenceConverter.cleanValue((Calendar)input.getEventDate()));
        occurrence.setModified(OccurrenceConverter.cleanValue((Calendar)input.getModified()));
        occurrence.setScientificName(OccurrenceConverter.cleanValueEscapeSql((String)input.getScientificName()));
        occurrence.setKingdom(OccurrenceConverter.cleanValueEscapeSql((String)input.getKingdom()));
        occurrence.setFamily(OccurrenceConverter.cleanValueEscapeSql((String)input.getFamily()));
        occurrence.setLocality(OccurrenceConverter.cleanValueEscapeSql((String)input.getLocality()));
        occurrence.setCountry(OccurrenceConverter.cleanValueEscapeSql((String)input.getCountry()));
        occurrence.setCitation(OccurrenceConverter.cleanValueEscapeSql((String)input.getCitation()));
        occurrence.setDecimalLatitude(String.valueOf(input.getDecimalLatitude()));
        occurrence.setDecimalLongitude(String.valueOf(input.getDecimalLongitude()));
        occurrence.setCoordinateUncertaintyInMeters(OccurrenceConverter.cleanValueEscapeSql((String)input.getCoordinateUncertaintyInMeters()));
        occurrence.setMaxDepth(String.valueOf(input.getMaxDepth()));
        occurrence.setMinDepth(String.valueOf(input.getMinDepth()));
        occurrence.setBasisOfRecord(OccurrenceConverter.cleanValue((BasisOfRecord)input.getBasisOfRecord()));
        return occurrence;
    }

    protected static String cleanValue(BasisOfRecord basisOfRecord) {
        if (basisOfRecord == null) {
            return "";
        }
        return basisOfRecord.toString();
    }

    protected static String cleanValue(Calendar value) {
        if (value == null) {
            return "";
        }
        return FORMAT.format(value.getTime());
    }

    protected static String cleanValueEscapeSql(String value) {
        if (value == null || value.isEmpty()) {
            return "not found";
        }
        return StringEscapeUtils.escapeSql((String)value);
    }
}

