/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.socialprofile.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.socialprofile.client.SocialService;
import org.gcube.portlets.user.socialprofile.server.SocialServiceImpl;
import org.gcube.portlets.user.socialprofile.shared.UserContext;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialServiceImpl
extends RemoteServiceServlet
implements SocialService {
    private static final Logger logger = LoggerFactory.getLogger(SocialServiceImpl.class);
    private static final String LINKEDIN_HOST_SERVICE_NAME = "host";
    private static final String LINKEDIN_CLIEND_ID_PROPNAME = "client_id";
    private static final String LINKEDIN_CLIEND_SECRET_PROPNAME = "client_secret";
    private static final String LINKEDIN_API_REQUEST = "https://api.linkedin.com/v2/me?projection=(id,firstName,lastName,profilePicture(displayImage~:playableStreams))";

    private GCubeUser getCurrentUser(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest is null!");
        }
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser user = pContext.getCurrentUser(request);
        logger.debug("Returning user " + user);
        return user;
    }

    private String getCurrentContext(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("HttpServletRequest is null!");
        }
        PortalContext pContext = PortalContext.getConfiguration();
        String context = pContext.getCurrentScope(request);
        logger.debug("Returning context " + context);
        return context;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            logger.trace("Development Mode ON");
            return false;
        }
    }

    public UserContext getUserContext(String userid) {
        if (userid == null || userid.equals("") || userid.equals(this.getCurrentUser(this.getThreadLocalRequest()).getUsername())) {
            logger.debug("Own Profile");
            return this.getOwnProfile();
        }
        logger.debug(userid + " Reading Profile of " + userid);
        return this.getUserProfile(userid);
    }

    public String saveProfessionalBackground(String summary) {
        String username = this.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String toReturn = this.transformSummary(summary);
        if (this.isWithinPortal()) {
            LiferayUserManager um = new LiferayUserManager();
            try {
                GCubeUser user = um.getUserByUsername(username);
                um.setUserProfessionalBackground(user.getUserId(), summary);
                return toReturn;
            }
            catch (Exception e) {
                logger.error("Unable to save the professional background " + summary + " for user " + username);
                return null;
            }
        }
        return toReturn;
    }

    private UserContext getUserProfile(String username) {
        String email = username + "@isti.cnr.it";
        String fullName = username + " FULL";
        String thumbnailURL = "images/Avatar_default.png";
        PortalContext pContext = PortalContext.getConfiguration();
        String contextName = pContext.getCurrentGroupName(this.getThreadLocalRequest());
        if (this.isWithinPortal()) {
            try {
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser user = um.getUserByUsername(username);
                thumbnailURL = user.getUserAvatarURL();
                fullName = user.getFullname();
                email = user.getEmail();
                HashMap vreNames = new HashMap();
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmail(), "", true, false, vreNames);
                String headline = user.getJobTitle();
                String company = user.getLocation_industry();
                String summary = this.transformSummary(um.getUserProfessionalBackground(user.getUserId()));
                String MessageAppPageURL = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest()) + "/messages";
                return new UserContext(userInfo, headline, company, summary, contextName, this.isInfrastructureScope(), false, MessageAppPageURL);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new UserContext();
            }
        }
        logger.info("Returning test USER");
        HashMap<String, String> fakeVreNames = new HashMap<String, String>();
        fakeVreNames.put("/gcube/devsec/devVRE", "devVRE");
        UserInfo user = new UserInfo(username, username + "FULL", thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
        return new UserContext(user, "", "", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.", contextName, false, this.isInfrastructureScope(), "URLFINTO");
    }

    private UserContext getOwnProfile() {
        try {
            PortalContext pContext = PortalContext.getConfiguration();
            String contextName = pContext.getCurrentGroupName(this.getThreadLocalRequest());
            String username = this.getCurrentUser(this.getThreadLocalRequest()).getUsername();
            String email = username + "@isti.cnr.it";
            String fullName = username + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.isWithinPortal()) {
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser user = um.getUserByUsername(username);
                thumbnailURL = user.getUserAvatarURL();
                fullName = user.getFullname();
                email = user.getEmail();
                String accountURL = "";
                HashMap vreNames = new HashMap();
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmail(), accountURL, true, false, vreNames);
                String headline = user.getJobTitle();
                String company = user.getLocation_industry();
                String summary = this.transformSummary(um.getUserProfessionalBackground(user.getUserId()));
                return new UserContext(userInfo, headline, company, summary, contextName, this.isInfrastructureScope(), true, "");
            }
            logger.info("Returning test USER");
            HashMap<String, String> fakeVreNames = new HashMap<String, String>();
            fakeVreNames.put("/gcube/devsec/devVRE", "devVRE");
            UserInfo user = new UserInfo(username, fullName, thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
            return new UserContext(user, "", "", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.", contextName, this.isInfrastructureScope(), true, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserContext();
        }
    }

    private String transformSummary(String professionalBackground) {
        String toReturn = this.escapeHtml(professionalBackground);
        toReturn = toReturn.replaceAll("(\r\n|\n)", " <br/> ");
        toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
        return toReturn;
    }

    public Boolean saveHeadline(String newHeadline) {
        try {
            LiferayUserManager um = new LiferayUserManager();
            return um.updateJobTitle(um.getUserId(this.getCurrentUser(this.getThreadLocalRequest()).getUsername()), newHeadline);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Boolean saveIsti(String institution) {
        try {
            LiferayUserManager um = new LiferayUserManager();
            um.saveCustomAttr(um.getUserId(this.getCurrentUser(this.getThreadLocalRequest()).getUsername()), CustomAttributeKeys.USER_LOCATION_INDUSTRY.getKeyName(), (Serializable)((Object)institution));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchUserProfile(String authCode, String redirectURI) {
        try {
            HashMap infoMap = this.getLinkedInUASInfo();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost((String)infoMap.get(LINKEDIN_HOST_SERVICE_NAME));
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(5);
            params.add(new BasicNameValuePair("grant_type", "authorization_code"));
            params.add(new BasicNameValuePair("code", authCode));
            params.add(new BasicNameValuePair("redirect_uri", redirectURI));
            params.add(new BasicNameValuePair(LINKEDIN_CLIEND_ID_PROPNAME, (String)infoMap.get(LINKEDIN_CLIEND_ID_PROPNAME)));
            params.add(new BasicNameValuePair(LINKEDIN_CLIEND_SECRET_PROPNAME, (String)infoMap.get(LINKEDIN_CLIEND_SECRET_PROPNAME)));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) return null;
            try (InputStream myInputStream = entity.getContent();){
                String jsonText = IOUtils.toString((InputStream)myInputStream, (String)"UTF-8");
                logger.debug("LinkedIn response: " + jsonText);
                if (jsonText == null) {
                    String string = null;
                    return string;
                }
                JSONParser parser = new JSONParser();
                1 containerFactory = new /* Unavailable Anonymous Inner Class!! */;
                Map json = (Map)parser.parse(jsonText, (ContainerFactory)containerFactory);
                if (json.get("error") != null) {
                    String string = null;
                    return string;
                }
                String token = (String)json.get("access_token");
                if (token == null) {
                    String string = null;
                    return string;
                }
                String string = this.parseProfile((HttpClient)httpClient, token);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseProfile(HttpClient httpClient, String token) {
        HttpGet request = new HttpGet(LINKEDIN_API_REQUEST);
        request.addHeader("Authorization", "Bearer " + token);
        request.addHeader("cache-control", "no-cache ");
        request.addHeader("X-Restli-Protocol-Version", "2.0.0");
        try {
            logger.debug("Asking LinkedIn profile via http GET for " + this.getCurrentUser(this.getThreadLocalRequest()).getUsername());
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) return null;
            try (InputStream myInputStream = entity.getContent();){
                String string;
                String jsonResponse = IOUtils.toString((InputStream)myInputStream, (String)"UTF-8");
                logger.debug("LinkedIn jsonResponse: " + jsonResponse);
                GCubeUser currUser = this.getCurrentUser(this.getThreadLocalRequest());
                JSONParser parser = new JSONParser();
                logger.info("Parsing LinkedIn profile jsonResponse for " + currUser.getUsername());
                String pictureURL = null;
                JSONObject jsonObject = (JSONObject)parser.parse(jsonResponse);
                JSONObject profilePictureObject = (JSONObject)jsonObject.get((Object)"profilePicture");
                JSONObject displayImageObj = (JSONObject)profilePictureObject.get((Object)"displayImage~");
                JSONArray displayImageElems = (JSONArray)displayImageObj.get((Object)"elements");
                int size = displayImageElems.size();
                if (displayImageElems != null && size > 0) {
                    JSONObject elements1 = null;
                    elements1 = size > 1 ? (JSONObject)displayImageElems.get(1) : (JSONObject)displayImageElems.get(0);
                    JSONArray identifiers = (JSONArray)elements1.get((Object)"identifiers");
                    JSONObject identifier0 = (JSONObject)identifiers.get(0);
                    pictureURL = identifier0.get((Object)"identifier").toString();
                }
                if (this.isWithinPortal()) {
                    byte[] pictureData;
                    logger.debug("LinkedIn Profile gotten correctly for " + this.getCurrentUser(this.getThreadLocalRequest()).getUsername() + " attempting to write into DB ...");
                    if (pictureURL.compareTo("") != 0 && pictureURL.startsWith("http") && (pictureData = this.getUserPictureFromURL(httpClient, pictureURL)) != null) {
                        logger.debug("Updating Image Profile with this one: " + pictureURL);
                        UserLocalServiceUtil.updatePortrait((long)currUser.getUserId(), (byte[])pictureData);
                    }
                    if (pictureURL != null) {
                        string = pictureURL;
                        return string;
                    }
                    string = null;
                    return string;
                }
                logger.warn("Development Mode ON, not attempting to write into DB");
                string = "fakePublicURL";
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] getUserPictureFromURL(HttpClient httpClient, String pictureURL) {
        HttpGet request = new HttpGet(pictureURL);
        try {
            return IOUtils.toByteArray((InputStream)httpClient.execute((HttpUriRequest)request).getEntity().getContent());
        }
        catch (Exception e) {
            logger.error("Could not get bytes from picture URL " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private HashMap<String, String> getLinkedInUASInfo() {
        String scope = this.getCurrentContext(this.getThreadLocalRequest());
        logger.info("Looking for a LinkedIn UAS in " + scope);
        String previousScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/string() eq 'Service'");
        query.addCondition("$resource/Profile/Name/string() eq 'LinkedIn-user-authorization'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List list = client.submit((Query)query);
        ScopeProvider.instance.set(previousScope);
        if (list.size() > 1) {
            logger.warn("Multiple LinkedIn-user-authorization Service Endpoints available in the scope, should be only one.");
            return null;
        }
        if (list.size() == 1) {
            ServiceEndpoint se = (ServiceEndpoint)list.get(0);
            ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)se.profile().accessPoints().iterator().next();
            String authServiceURL = ap.address();
            String clientId = "";
            String clientSecret = "";
            try {
                for (ServiceEndpoint.Property property : ap.properties()) {
                    if (property.name().compareTo(LINKEDIN_CLIEND_ID_PROPNAME) == 0) {
                        clientId = StringEncrypter.getEncrypter().decrypt(property.value(), new Key[0]);
                    }
                    if (property.name().compareTo(LINKEDIN_CLIEND_SECRET_PROPNAME) != 0) continue;
                    clientSecret = StringEncrypter.getEncrypter().decrypt(property.value(), new Key[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(LINKEDIN_HOST_SERVICE_NAME, authServiceURL);
            map.put(LINKEDIN_CLIEND_ID_PROPNAME, clientId);
            map.put(LINKEDIN_CLIEND_SECRET_PROPNAME, clientSecret);
            return map;
        }
        return null;
    }

    private boolean isInfrastructureScope() {
        ScopeBean scope = new ScopeBean(this.getCurrentContext(this.getThreadLocalRequest()));
        return scope.is(ScopeBean.Type.INFRASTRUCTURE);
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

