/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.socialprofile.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.socialprofile.client.SocialProfile;
import org.gcube.portlets.user.socialprofile.client.SocialService;
import org.gcube.portlets.user.socialprofile.client.SocialServiceAsync;
import org.gcube.portlets.user.socialprofile.client.ui.DisplayProfile;
import org.gcube.portlets.user.socialprofile.shared.UserContext;

public class DisplayProfile
extends Composite {
    protected static final String HEADLINE_TEXT = "Professional Headline";
    protected static final String HEADLINE_ERROR = "Your Headline please";
    protected static final String ISTI_TEXT = "Location and/or industry";
    protected static final String ISTI_ERROR = "Your Company please";
    private static final String OAUTH2_SERVICE = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code";
    private static final String EDIT_PROFILE_LR_URL = "/group/control_panel/manage?p_p_id=2#_LFR_FN_comments";
    private static final String D4S_APP_ID = "77n7r4c9nwuwk2";
    private static DisplayProfileUiBinder uiBinder = (DisplayProfileUiBinder)GWT.create(DisplayProfileUiBinder.class);
    public static final String avatar_default = GWT.getModuleBaseURL() + "../images/Avatar_default.png";
    public static final String loading = GWT.getModuleBaseURL() + "../images/avatarLoader.gif";
    public static final String savingImage = GWT.getModuleBaseURL() + "../images/saving.gif";
    public static final String GET_OID_PARAMETER = "oid";
    public static final String CONTROL_SEQUENCE_COOKIE = "CSRF-check-d4science";
    private final SocialServiceAsync socialService = (SocialServiceAsync)GWT.create(SocialService.class);
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Image avatarImage;
    @UiField
    HTML userFullName;
    @UiField
    TextBox headlineBox;
    @UiField
    TextBox institutionBox;
    @UiField
    HTML editHeadline;
    @UiField
    HTML editIsti;
    @UiField
    HTML headlineLabel;
    @UiField
    HTML institutionLabel;
    @UiField
    Image savingHeadline;
    @UiField
    Button saveHead;
    @UiField
    Button cancelHead;
    @UiField
    Button saveIsti;
    @UiField
    Button cancelIsti;
    @UiField
    Button messageButton;
    @UiField
    Button editButton;
    @UiField
    Button importButton;
    private String currHeadLine;
    private String currInstitution;
    private UserInfo myUserInfo;

    public DisplayProfile() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.avatarImage.setUrl(loading);
        this.mainPanel.addStyleName("profile-section");
        this.savingHeadline.setUrl(savingImage);
    }

    public void show(UserContext result) {
        this.myUserInfo = result.getUserInfo();
        this.avatarImage.getElement().getParentElement().setAttribute("href", this.myUserInfo.getAccountURL());
        this.avatarImage.setSize("100px", "100px");
        this.avatarImage.setUrl(this.myUserInfo.getAvatarId());
        this.userFullName.setText(this.myUserInfo.getFullName());
        if (SocialProfile.getUserToShowId() == null) {
            String head = result.getHeadline() == null || result.getHeadline().compareTo("") == 0 ? HEADLINE_TEXT : result.getHeadline();
            String isti = result.getInstitution() == null || result.getInstitution().compareTo("") == 0 ? ISTI_TEXT : result.getInstitution();
            this.headlineLabel.setText(head);
            this.institutionLabel.setText(isti);
            this.editHeadline.setStyleName("editImage");
            this.editHeadline.setTitle("Edit your Professional Headline (e.g. Researcher at University of ...");
            this.editIsti.setStyleName("editImage");
            this.editIsti.setTitle("Edit location or industry");
            this.headlineBox.setMaxLength(100);
            this.institutionBox.setMaxLength(100);
            this.messageButton.removeFromParent();
            this.currHeadLine = head;
            if (result.getHeadline() == null || result.getHeadline().compareTo("") == 0) {
                this.headlineLabel.getElement().getStyle().setOpacity(0.5);
                this.institutionLabel.getElement().getStyle().setOpacity(0.5);
            }
            this.editButton.setVisible(true);
            this.editButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.importButton.setVisible(true);
            this.importButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            String head = result.getHeadline() == null || result.getHeadline().compareTo("") == 0 ? "" : result.getHeadline();
            String isti = result.getInstitution() == null || result.getInstitution().compareTo("") == 0 ? "" : result.getInstitution();
            this.headlineLabel.setText(head);
            this.institutionLabel.setText(isti);
            this.avatarImage.getElement().getParentElement().setAttribute("href", "");
            this.avatarImage.setTitle(this.myUserInfo.getFullName());
            this.messageButton.setVisible(true);
        }
    }

    public static String getRedirectURI() {
        String redirectURI = Window.Location.getProtocol() + "//" + Window.Location.getHost() + Window.Location.getPath();
        if (Window.Location.getParameter((String)"gwt.codesvr") != null) {
            return redirectURI + "?gwt.codesvr=127.0.0.1:9997";
        }
        return redirectURI;
    }

    @UiHandler(value={"editHeadline"})
    void onEditHeadlineClick(ClickEvent e) {
        this.headlineLabel.setVisible(false);
        this.headlineBox.setText(this.headlineLabel.getText());
        this.headlineBox.addStyleName("edit");
        this.headlineBox.setVisible(true);
        this.headlineBox.setFocus(true);
        this.headlineBox.selectAll();
        this.editHeadline.setVisible(false);
        this.saveHead.setVisible(true);
        this.cancelHead.setVisible(true);
    }

    @UiHandler(value={"editIsti"})
    void onEditInstitutionClick(ClickEvent e) {
        this.institutionLabel.setVisible(false);
        this.institutionBox.setText(this.institutionLabel.getText());
        this.institutionBox.addStyleName("edit");
        this.institutionBox.setVisible(true);
        this.institutionBox.setFocus(true);
        this.institutionBox.selectAll();
        this.editIsti.setVisible(false);
        this.saveIsti.setVisible(true);
        this.cancelIsti.setVisible(true);
    }

    @UiHandler(value={"cancelHead"})
    void onCancelHeadlineClick(ClickEvent e) {
        this.cancelHeadline();
    }

    @UiHandler(value={"cancelIsti"})
    void onCancelIstiClick(ClickEvent e) {
        this.cancelInsti();
    }

    @UiHandler(value={"saveHead"})
    void onSaveHeadlineClick(ClickEvent e) {
        String toShare = this.escapeHtml(this.headlineBox.getText());
        if (toShare.equals("") || toShare.equals(HEADLINE_TEXT) || toShare.equals(HEADLINE_ERROR)) {
            this.headlineBox.setText(HEADLINE_ERROR);
        } else {
            this.currHeadLine = toShare;
            this.saveHead.setVisible(false);
            this.cancelHead.setVisible(false);
            this.savingHeadline.setVisible(true);
            this.socialService.saveHeadline(this.currHeadLine, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @UiHandler(value={"saveIsti"})
    void onSaveInstitutionClick(ClickEvent e) {
        String toShare = this.escapeHtml(this.institutionBox.getText());
        if (toShare.equals("") || toShare.equals(ISTI_TEXT) || toShare.equals(ISTI_ERROR)) {
            this.institutionBox.setText(ISTI_ERROR);
        } else {
            this.currInstitution = toShare;
            this.saveIsti.setVisible(false);
            this.cancelIsti.setVisible(false);
            this.savingHeadline.setVisible(true);
            this.socialService.saveIsti(this.currInstitution, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @UiHandler(value={"messageButton"})
    void onSendPrivateMessageClick(ClickEvent e) {
        ArrayList<String> listToLogin = new ArrayList<String>();
        listToLogin.add(SocialProfile.getUserToShowId());
        GWT.runAsync((RunAsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cancelHeadline() {
        this.editHeadline.setVisible(true);
        this.saveHead.setVisible(false);
        this.cancelHead.setVisible(false);
        this.headlineBox.setVisible(false);
        this.headlineLabel.setVisible(true);
    }

    private void cancelInsti() {
        this.editIsti.setVisible(true);
        this.saveIsti.setVisible(false);
        this.cancelIsti.setVisible(false);
        this.institutionBox.setVisible(false);
        this.institutionLabel.setVisible(true);
    }

    public void showError(String message) {
        Window.alert((String)("Failure: " + message));
        this.avatarImage.setSize("100px", "100px");
        this.avatarImage.setUrl(avatar_default);
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private String getRandomString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 20; ++i) {
            sb.append(97 + Random.nextInt((int)26));
        }
        return sb.toString();
    }

    static /* synthetic */ String access$000(DisplayProfile x0) {
        return x0.getRandomString();
    }

    static /* synthetic */ void access$100(DisplayProfile x0) {
        x0.cancelHeadline();
    }

    static /* synthetic */ String access$200(DisplayProfile x0) {
        return x0.currHeadLine;
    }

    static /* synthetic */ String access$300(DisplayProfile x0) {
        return x0.currInstitution;
    }
}

