package org.gcube.portlets.user.socialprofile.server;

import java.util.HashMap;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.socialprofile.client.SocialService;
import org.gcube.portlets.user.socialprofile.shared.UserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class SocialServiceImpl extends RemoteServiceServlet implements SocialService {

	private static final Logger _log = LoggerFactory.getLogger(SocialServiceImpl.class);

	/**
	 * used for debugging in eclipse
	 */
	private boolean withinPortal = false;

	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			_log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
			user = getDevelopmentUser();
			withinPortal = false;
		}
		else {
			withinPortal = true;
		}
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	/**
	 * when packaging test will fail if the user is not set to test.user
	 * @return .
	 */
	public String getDevelopmentUser() {
		String user = "test.user";
		//user = "massimiliano.assante";
		return user;
	}
	@Override
	public UserContext getUserContext(String userid) {
		if (userid == null || userid.equals("")) {
			System.out.println("Own Profile");
			_log.info("Own Profile");
			return getOwnProfile();
		}
		else {
			System.out.println("Reading Profile");
			_log.info(userid + " Reading Profile");
			return getUserProfile(userid);
		}
	}

	private UserContext getUserProfile(String username) {
		ASLSession session = getASLSession();
		String email = username+"@isti.cnr.it";
		String fullName = username+" FULL";
		String thumbnailURL = "images/Avatar_default.png";
		if (withinPortal) {		
			try {
				com.liferay.portal.model.UserModel user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), username);
				thumbnailURL = "/image/user_male_portrait?img_id="+user.getPortraitId();
				fullName = user.getFirstName() + " " + user.getLastName();
				email = user.getEmailAddress();
				HashMap<String, String> vreNames = new HashMap<String, String>();
				UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), "", true, false, vreNames);
				return new UserContext(userInfo, getHeadline(username), getInstitution(username), session.getScopeName(), true);

			} catch (Exception e) {
				e.printStackTrace();
				return new UserContext();
			} 
		} else {
			_log.info("Returning test USER");
			HashMap<String, String> fakeVreNames = new  HashMap<String, String>();
			fakeVreNames.put("/gcube/devsec/devVRE","devVRE");
			//fakeVreNames.put("/gcube/devNext/NexNext","NexNext");

			UserInfo user =  new UserInfo(username, username+ "FULL", thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
			return new UserContext(user, null, "Institution", session.getScopeName(), true);
		}		
	}

	private UserContext getOwnProfile() {
		try {
			ASLSession session = getASLSession();
			String username = session.getUsername();
			String email = username+"@isti.cnr.it";
			String fullName = username+" FULL";
			String thumbnailURL = "images/Avatar_default.png";

			if (withinPortal) {

				com.liferay.portal.model.UserModel user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), username);
				thumbnailURL = "/image/user_male_portrait?img_id="+user.getPortraitId();
				fullName = user.getFirstName() + " " + user.getLastName();
				email = user.getEmailAddress();
				ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);
				String accountURL = themeDisplay.getURLMyAccount().toString();
				HashMap<String, String> vreNames = new HashMap<String, String>();

				UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, false, vreNames);
				return new UserContext(userInfo, getHeadline(session.getUsername()), getInstitution(session.getUsername()), session.getScopeName(), true);
			}
			else {
				_log.info("Returning test USER");
				HashMap<String, String> fakeVreNames = new  HashMap<String, String>();
				fakeVreNames.put("/gcube/devsec/devVRE","devVRE");
				//fakeVreNames.put("/gcube/devNext/NexNext","NexNext");

				UserInfo user =  new UserInfo(getASLSession().getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
				return new UserContext(user, "", "", session.getScopeName(), true);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return new UserContext();
	}

	private String getHeadline(String userid) throws PortalException, SystemException {
		User user = OrganizationsUtil.validateUser(userid);
		return user.getJobTitle();
	}

	private String getInstitution(String userid) throws PortalException, SystemException {
		User user = OrganizationsUtil.validateUser(userid);
		return user.getComments();
	}

	@Override
	public Boolean saveHeadline(String newHeadline) {
		com.liferay.portal.model.User user;
		try {
			user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), getASLSession().getUsername());
			user.setJobTitle(escapeHtml(newHeadline));
			return (UserLocalServiceUtil.updateUser(user) != null);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		} 

	}
	@Override
	public Boolean saveIsti(String institution) {
		com.liferay.portal.model.User user;
		try {
			user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), getASLSession().getUsername());
			user.setComments(escapeHtml(institution));
			return (UserLocalServiceUtil.updateUser(user) != null);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		} 
	}

	/**
	 * Escape an html string. Escaping data received from the client helps to
	 * prevent cross-site script vulnerabilities.
	 * 
	 * @param html the html string to escape
	 * @return the escaped string
	 */
	private String escapeHtml(String html) {
		if (html == null) {
			return null;
		}
		return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;");
	}


}
