/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.fileupload.util.Streams;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gcube.applicationsupportlayer.social.storage.FTPManager;
import org.gcube.portal.databook.shared.ImageType;
import org.gcube.portlets.user.shareupdates.server.ShareUpdateServiceImpl;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilePreviewer {
    private static Logger _log = LoggerFactory.getLogger(FilePreviewer.class);
    private static final String PDF_DEFAULT_IMAGE = "default/pdf.png";
    private static final String GENERICFILE_DEFAULT_IMAGE = "default/default_generic.png";
    private static final String UPLOAD_LOCATION_LOCAL = System.getProperty("java.io.tmpdir");
    private static final String[] handledextensionImages = new String[]{"css", "csv", "doc", "docx", "java", "mdb", "mp3", "pdf", "ppt", "pptx", "psd", "rar", "tex", "txt", "xls", "xlsx", "zip"};

    private static FTPManager getFTPManager(String context) {
        return FTPManager.getInstance((String)context);
    }

    protected static LinkPreview getPdfPreview(String fileName, String path2Pdf, String httpUrl, String mimeType, String context) throws Exception {
        ArrayList<String> imagesUrl = new ArrayList<String>();
        String desc = null;
        try {
            desc = FilePreviewer.getPDFDescription((String)path2Pdf);
        }
        catch (Exception ex) {
            _log.warn("PDF Parse exception, returning no description");
            desc = "";
        }
        File pdfFile = new File(path2Pdf);
        RandomAccessFile raf = new RandomAccessFile(pdfFile, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        PDFFile pdf = null;
        try {
            pdf = new PDFFile((ByteBuffer)buf);
        }
        catch (PDFParseException ex) {
            raf.close();
            _log.error("PDF Parse exception, returning default pdf image");
            imagesUrl.add(FilePreviewer.getFTPManager((String)context).getBaseURL() + "default/pdf.png");
            return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
        }
        PDFPage page = pdf.getPage(0);
        int width = (int)page.getBBox().getWidth();
        int height = (int)page.getBBox().getHeight();
        int scaledWidth = width / 8;
        int scaledHeight = height / 8;
        Rectangle rect = new Rectangle(0, 0, width, height);
        BufferedImage bufferedImage = new BufferedImage(scaledWidth, scaledHeight, 1);
        Image image = page.getImage(scaledWidth, scaledHeight, (Rectangle2D)rect, null, true, true);
        Graphics2D bufImageGraphics = bufferedImage.createGraphics();
        bufImageGraphics.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean result = ImageIO.write((RenderedImage)bufferedImage, "JPG", out);
        raf.close();
        if (result) {
            String httpLink = FilePreviewer.getFTPManager((String)context).uploadImageOnFTPServer((InputStream)new ByteArrayInputStream(out.toByteArray()), ImageType.JPG);
            _log.debug("PDF thumbnail available at: " + httpLink);
            imagesUrl.add(httpLink);
            return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
        }
        throw new IOException("Could not process pdf file");
    }

    protected static LinkPreview getImagePreview(String fileName, String path2Image, String httpUrl, String mimeType, String context) {
        ArrayList<String> imagesUrl = new ArrayList<String>();
        ByteArrayOutputStream out = null;
        String desc = "";
        try {
            Dimension dim = FilePreviewer.extractDimension((String)path2Image);
            desc = (int)dim.getWidth() + "x" + (int)dim.getHeight() + " pixels";
            out = new ByteArrayOutputStream();
            BufferedImage bufferedImage = Thumbnails.of((String[])new String[]{path2Image}).scale(1.0).asBufferedImage();
            bufferedImage = FilePreviewer.changeBackgroundColorToWhite((BufferedImage)bufferedImage);
            Thumbnails.fromImages(Arrays.asList(bufferedImage)).width(80).outputFormat("jpg").toOutputStream((OutputStream)out);
        }
        catch (IOException e) {
            _log.warn("Thumbnail extraction failed for this reason: " + e.getMessage());
        }
        String httpLink = FilePreviewer.getFTPManager((String)context).uploadImageOnFTPServer((InputStream)new ByteArrayInputStream(out.toByteArray()), ImageType.JPG);
        _log.debug("\nFlushed, Image thumbnail available at: " + httpLink);
        imagesUrl.add(httpLink);
        return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
    }

    private static BufferedImage changeBackgroundColorToWhite(BufferedImage bufferedImage) {
        BufferedImage changedImage = null;
        try {
            if (bufferedImage.getColorModel().getTransparency() != 1) {
                _log.debug("Background color is going to be changed to white for the thumbnail");
                int w = bufferedImage.getWidth();
                int h = bufferedImage.getHeight();
                changedImage = new BufferedImage(w, h, 1);
                Graphics2D g = changedImage.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, w, h);
                g.drawRenderedImage(bufferedImage, null);
                g.dispose();
            }
        }
        catch (Exception e) {
            _log.warn("Failed to change the transparent background to white for image");
        }
        return changedImage == null ? bufferedImage : changedImage;
    }

    protected static LinkPreview getUnhandledTypePreview(String fileName, String path2Pdf, String httpUrl, String mimeType, String context) throws Exception {
        ArrayList<String> imagesUrl = new ArrayList<String>();
        String extension = FilePreviewer.getExtension((String)fileName);
        String desc = "";
        if (extension == null) {
            imagesUrl.add(FilePreviewer.getFTPManager((String)context).getBaseURL() + "default/default_generic.png");
        } else {
            int foundIndex = Arrays.binarySearch(handledextensionImages, extension);
            if (foundIndex < 0) {
                imagesUrl.add(FilePreviewer.getFTPManager((String)context).getBaseURL() + "default/default_generic.png");
            } else {
                imagesUrl.add(FilePreviewer.getFTPManager((String)context).getBaseURL() + "default/" + extension + ".png");
            }
        }
        return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
    }

    private static String getExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        String extension = fileName.substring(lastDot + 1);
        _log.debug("EXTENSION FOUND =  " + extension);
        return extension;
    }

    private static String getPDFDescription(String path2File) throws Exception {
        PDDocument doc = PDDocument.load((String)path2File);
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setStartPage(1);
        stripper.setEndPage(1);
        String text = stripper.getText(doc);
        String toReturn = text.length() > 300 ? text.substring(0, 295) + " ... " : text;
        doc.close();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dimension extractDimension(String path2Image) throws IOException {
        try (ImageInputStream in = ImageIO.createImageInputStream(new File(path2Image));){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                    reader.dispose();
                    return dimension;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        return null;
    }

    protected static String getMimeType(File file, String filenameWithExtension) throws IOException {
        TikaConfig config = TikaConfig.getDefaultConfig();
        Detector detector = config.getDetector();
        TikaInputStream stream = TikaInputStream.get((File)file);
        Metadata metadata = new Metadata();
        metadata.add("resourceName", filenameWithExtension);
        MediaType mediaType = detector.detect((InputStream)stream, metadata);
        return mediaType.getBaseType().toString();
    }

    public static File storeAndGetFile(String urlThumbnail) {
        try {
            HttpURLConnection.setFollowRedirects(true);
            HttpURLConnection con = (HttpURLConnection)new URL(urlThumbnail).openConnection();
            con.setRequestMethod("HEAD");
            if (con.getResponseCode() == 200) {
                File theRandomDir = new File(UPLOAD_LOCATION_LOCAL + File.separator + UUID.randomUUID().toString());
                theRandomDir.mkdir();
                theRandomDir.deleteOnExit();
                _log.debug("Created temp upload directory in: " + theRandomDir);
                File file = new File(theRandomDir, UUID.randomUUID().toString().substring(0, 10));
                file.deleteOnExit();
                URL url = new URL(urlThumbnail);
                Streams.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(file), (boolean)true);
                _log.debug("File is at " + file.getAbsolutePath());
                return file;
            }
            return null;
        }
        catch (Exception e) {
            _log.error("The resource at url " + urlThumbnail + " doesn't exist");
            return null;
        }
    }

    public static String saveThumbnailOnFTPAndGetUrl(String urlThumbnail, String context) {
        File localFile = FilePreviewer.storeAndGetFile((String)urlThumbnail);
        if (localFile != null) {
            String mimeType = null;
            if (ShareUpdateServiceImpl.isWithinPortal()) {
                try {
                    mimeType = FilePreviewer.getMimeType((File)localFile, (String)localFile.getName());
                    String thumbnailUrlFTP = null;
                    switch (mimeType) {
                        case "image/png": 
                        case "image/gif": 
                        case "image/tiff": 
                        case "image/jpg": 
                        case "image/jpeg": 
                        case "image/bmp": {
                            thumbnailUrlFTP = (String)FilePreviewer.getImagePreview((String)localFile.getName(), (String)localFile.getAbsolutePath(), null, (String)mimeType, (String)context).getImageUrls().get(0);
                            break;
                        }
                    }
                    return thumbnailUrlFTP;
                }
                catch (IOException e) {
                    _log.error("Error while saving thumbnail on ftp", (Throwable)e);
                }
            }
        } else {
            _log.warn("the file at url " + urlThumbnail + " doesn't exist");
        }
        return null;
    }
}

