/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadToWorkspaceThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(UploadToWorkspaceThread.class);
    public static final String ATTACHMENT_FOLDER = "Shared attachments";
    private String username;
    private String fullName;
    private String fileName;
    private String fileabsolutePathOnServer;

    public UploadToWorkspaceThread(String fullName, String username, String fileName, String fileabsolutePathOnServer) {
        this.username = username;
        this.fullName = fullName;
        this.fileName = fileName;
        this.fileabsolutePathOnServer = fileabsolutePathOnServer;
    }

    @Override
    public void run() {
        try {
            String currScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(this.username).getWorkspace();
            _log.info("File to upload=" + this.fileabsolutePathOnServer);
            File file = new File(this.fileabsolutePathOnServer);
            FileInputStream fileData = new FileInputStream(file);
            _log.info("Trying to get Group folder for scope=" + currScope);
            WorkspaceSharedFolder folder = ws.getVREFolderByScope(currScope);
            Workspace ownerWS = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(folder.getOwner().getPortalLogin()).getWorkspace();
            WorkspaceFolder attachment = null;
            try {
                attachment = (WorkspaceFolder)ownerWS.getItemByPath(String.valueOf(folder.getPath()) + "/" + ATTACHMENT_FOLDER);
            }
            catch (ItemNotFoundException e) {
                _log.info("Shared attachments Workspace Folder does not exists, creating it for " + currScope);
                attachment = ownerWS.createFolder(ATTACHMENT_FOLDER, "Folder created automatically by the System", folder.getId());
                attachment.setACL(folder.getUsers(), ACLType.WRITE_OWNER);
            }
            WorkspaceFolder theFolderToWriteIn = (WorkspaceFolder)ws.getItemByPath(String.valueOf(folder.getPath()) + "/" + ATTACHMENT_FOLDER);
            String itemName = WorkspaceUtil.getUniqueName((String)this.fileName, (WorkspaceFolder)theFolderToWriteIn);
            FolderItem item = WorkspaceUtil.createExternalFile((WorkspaceFolder)theFolderToWriteIn, (String)itemName, (String)("File shared by " + this.fullName + "(" + this.username + ")"), null, (InputStream)fileData);
            _log.debug("Uploaded " + item.getName() + " - Returned Workspace id=" + item.getId());
            ScopeProvider.instance.set(currScope);
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error("Something wrong while uploading " + this.fileName + " in Workspace " + e.getMessage());
        }
    }
}

