/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.storage.UriResolverReaderParameter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.ClientFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.server.FilePreviewer;
import org.gcube.portlets.user.shareupdates.server.MentionNotificationsThread;
import org.gcube.portlets.user.shareupdates.server.PostNotificationsThread;
import org.gcube.portlets.user.shareupdates.server.UploadToStorageThread;
import org.gcube.portlets.user.shareupdates.server.UploadToWorkspaceThread;
import org.gcube.portlets.user.shareupdates.server.metaseeker.MetaSeeker;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraph;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.gcube.portlets.user.shareupdates.shared.UserSettings;
import org.gcube.portlets.widgets.pickuser.shared.PickingUser;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlparser.beans.StringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShareUpdateServiceImpl
extends RemoteServiceServlet
implements ShareUpdateService {
    private static final String ADMIN_ROLE = "Administrator";
    private static final String STORAGE_OWNER = "gCubeSocialFramework";
    public static final String UPLOAD_DIR = "/social-framework-uploads";
    private static final String NEWS_FEED_PORTLET_CLASSNAME = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";
    private static Logger _log = LoggerFactory.getLogger(ShareUpdateServiceImpl.class);
    private DatabookStore store;
    private boolean withinPortal = false;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
            this.withinPortal = false;
        } else {
            this.withinPortal = true;
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    public ClientFeed share(String postText, FeedType feedType, PrivacyLevel pLevel, String vreId, LinkPreview preview, String urlThumbnail, ArrayList<String> mentionedUserFullNames, String fileName, String filePathOnServer, boolean notifyGroup) {
        Thread thread;
        ApplicationNotificationsManager nm;
        String escapedFeedText = this.escapeHtml(postText);
        ArrayList mentionedUsers = null;
        if (mentionedUserFullNames != null && !mentionedUserFullNames.isEmpty()) {
            mentionedUsers = this.getSelectedUserIds(mentionedUserFullNames);
            escapedFeedText = this.convertMentionPeopleAnchorHTML(escapedFeedText, mentionedUsers);
        }
        ASLSession session = this.getASLSession();
        String username = session.getUsername();
        String email = username + "@isti.cnr.it";
        String fullName = username + " FULL";
        String thumbnailURL = "images/Avatar_default.png";
        if (this.withinPortal) {
            try {
                UserInfo user = this.getUserSettings().getUserInfo();
                email = user.getEmailaddress();
                fullName = user.getFullName();
                thumbnailURL = user.getAvatarId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String linkTitle = preview.getTitle();
        String linkDesc = preview.getDescription();
        String host = preview.getHost();
        String url = preview.getUrl();
        Date feedDate = new Date();
        String textToPost = "";
        textToPost = escapedFeedText.compareTo("_N0_73X7_SH4R3_") == 0 ? this.convertFileNameAnchorHTML(url) : this.transformUrls(escapedFeedText);
        ScopeBean scope = new ScopeBean(session.getScope());
        String vreId2Set = scope.is(ScopeBean.Type.VRE) ? scope.toString() : "";
        Feed toShare = new Feed(UUID.randomUUID().toString(), feedType, username, feedDate, vreId2Set, url, urlThumbnail, textToPost, pLevel, fullName, email, thumbnailURL, linkTitle, linkDesc, host);
        _log.trace("Attempting to save Feed with text: " + escapedFeedText + " Level: " + pLevel);
        boolean result = this.store.saveUserFeed(toShare);
        if (pLevel == PrivacyLevel.VRES) {
            _log.trace("PrivacyLevel was set to VRES attempting to write onto User's VRES Timelines");
            for (GroupModel vre : this.getUserVREs(username)) {
                String vreScope = this.getScopeByOrganizationId(vre.getGroupId());
                _log.trace("Attempting to write onto " + vreScope);
                try {
                    this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
                }
                catch (FeedIDNotFoundException e) {
                    _log.error("Error writing onto VRES Time Line" + vreScope);
                }
                _log.trace("Success writing onto " + vreScope);
            }
        } else if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0) {
            String vreScope = this.withinPortal ? this.getScopeByOrganizationId(vreId) : "/gcube/devsec/devVRE";
            _log.trace("Attempting to write onto " + vreScope);
            try {
                this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
            }
            catch (FeedIDNotFoundException e) {
                _log.error("Error writing onto VRES Time Line" + vreScope);
            }
            _log.trace("Success writing onto " + vreScope);
        }
        if (!result) {
            return null;
        }
        ClientFeed cf = new ClientFeed(toShare.getKey(), toShare.getType().toString(), username, feedDate, toShare.getUri(), this.replaceAmpersand(toShare.getDescription()), fullName, email, thumbnailURL, toShare.getLinkTitle(), toShare.getLinkDescription(), toShare.getUriThumbnail(), toShare.getLinkHost());
        if (pLevel == PrivacyLevel.SINGLE_VRE && vreId != null && vreId.compareTo("") != 0 && notifyGroup) {
            nm = new ApplicationNotificationsManager(session, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
            thread = new Thread((Runnable)new PostNotificationsThread(toShare.getKey(), escapedFeedText, "" + session.getGroupId(), (NotificationsManager)nm));
            thread.start();
        }
        if (mentionedUsers != null && mentionedUsers.size() > 0) {
            nm = new ApplicationNotificationsManager(session);
            thread = new Thread((Runnable)new MentionNotificationsThread(toShare.getKey(), escapedFeedText, (NotificationsManager)nm, mentionedUsers));
            thread.start();
        }
        if (fileName != null && filePathOnServer != null) {
            Thread thread2 = new Thread((Runnable)new UploadToWorkspaceThread(username, fileName, filePathOnServer));
            thread2.start();
        }
        return cf;
    }

    private String convertMentionPeopleAnchorHTML(String escapedFeedText, ArrayList<PickingUser> taggedPeople) {
        for (PickingUser tagged : taggedPeople) {
            String taggedHTML = "<a class=\"link\" style=\"font-size:14px;\" href=\"/group/data-e-infrastructure-gateway/profile?" + new String(Base64.encodeBase64((byte[])"userIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])tagged.getUsername().getBytes())) + "\">" + tagged.getFullName() + "</a> ";
            escapedFeedText = escapedFeedText.replace(tagged.getFullName(), taggedHTML);
        }
        return escapedFeedText;
    }

    private void setUserSettingsInSession(UserSettings user) {
        this.getASLSession().setAttribute("USER_INFO_ATTR", (Object)user);
    }

    private String replaceAmpersand(String toReplace) {
        String toReturn = toReplace.replaceAll("&amp;", "&");
        return toReturn;
    }

    private String transformUrls(String feedText) {
        StringBuilder sb = new StringBuilder();
        String[] parts = feedText.split("\\s");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("http")) {
                try {
                    URL url = new URL(parts[i]);
                    if (i == 0 && parts.length == 1) {
                        return sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a link.").append("</a> ").toString();
                    }
                    sb.append("<a class=\"link\" style=\"font-size:14px;\" href=\"").append(url).append("\" target=\"_blank\">").append(url).append("</a> ");
                    continue;
                }
                catch (MalformedURLException e) {
                    _log.error("MalformedURLException returning... ");
                    return feedText;
                }
            }
            sb.append(parts[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    private String convertFileNameAnchorHTML(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("<span style=\"color:gray; font-size:12px;\">shared </span><a class=\"link\" href=\"").append(url).append("\" target=\"_blank\">").append("a file.").append("</a> ").toString();
        return sb.toString();
    }

    public UserSettings getUserSettings() {
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            String email = username + "@isti.cnr.it";
            String fullName = username + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.withinPortal) {
                this.getUserVREs(username);
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = user.getFirstName() + " " + user.getLastName();
                email = user.getEmailAddress();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                String accountURL = themeDisplay.getURLMyAccount().toString();
                HashMap vreNames = this.getUserVreNames(username);
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, this.isAdmin(), vreNames);
                UserSettings toReturn = new UserSettings(userInfo, 0, session.getScopeName(), this.isInfrastructureScope());
                this.setUserSettingsInSession(toReturn);
                return toReturn;
            }
            _log.info("Returning test USER = " + session.getUsername());
            HashMap fakeVreNames = new HashMap();
            UserInfo user = new UserInfo(session.getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, fakeVreNames);
            return new UserSettings(user, 0, session.getScopeName(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserSettings();
        }
    }

    public LinkPreview checkUploadedFile(String fileName, String fileabsolutePathOnServer) {
        LinkPreview toReturn = null;
        String randomUploadFolderName = UUID.randomUUID().toString();
        String remoteFilePath = "/social-framework-uploads/" + randomUploadFolderName + "/" + fileName;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set("/" + PortalContext.getConfiguration().getInfrastructureName());
        IClient storageClient = new StorageClient("gCubeSocialFramework", AccessType.SHARED, MemoryType.PERSISTENT).getClient();
        ScopeProvider.instance.set(currScope);
        String httpURL = "";
        String smpURI = storageClient.getUrl().RFile(remoteFilePath);
        Thread thread = new Thread((Runnable)new UploadToStorageThread(storageClient, fileName, fileabsolutePathOnServer, remoteFilePath));
        thread.start();
        try {
            String mimeType = ShareUpdateServiceImpl.getMimeType((File)new File(fileabsolutePathOnServer), (String)fileName);
            UriResolverReaderParameter resolver = new UriResolverReaderParameter();
            httpURL = resolver.resolveAsUriRequest(smpURI, fileName, mimeType, true);
            switch (mimeType) {
                case "application/pdf": {
                    toReturn = FilePreviewer.getPdfPreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                    break;
                }
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
                    mimeType = "application/wordprocessor";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                    mimeType = "application/spreadsheet";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
                case "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
                    mimeType = "application/presentation";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
                case "image/png": 
                case "image/gif": 
                case "image/tiff": 
                case "image/jpg": 
                case "image/jpeg": 
                case "image/bmp": {
                    toReturn = FilePreviewer.getImagePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                    break;
                }
                default: {
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType);
                }
            }
        }
        catch (Exception e) {
            _log.error("Error while resolving or previewing file");
            e.printStackTrace();
        }
        _log.debug("smpURI=" + smpURI);
        _log.debug("Returning httpURL=" + httpURL);
        return toReturn;
    }

    protected static String getMimeType(File file, String filenameWithExtension) throws IOException {
        TikaConfig config = TikaConfig.getDefaultConfig();
        Detector detector = config.getDetector();
        TikaInputStream stream = TikaInputStream.get((File)file);
        Metadata metadata = new Metadata();
        metadata.add("resourceName", filenameWithExtension);
        MediaType mediaType = detector.detect((InputStream)stream, metadata);
        return mediaType.getBaseType().toString();
    }

    private HashMap<String, String> getUserVreNames(String username) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        if (this.isInfrastructureScope()) {
            for (GroupModel vre : this.getUserVREs(username)) {
                toReturn.put(vre.getGroupId(), vre.getGroupName());
            }
        } else {
            for (GroupModel vre : this.getUserVREs(username)) {
                if (vre.getGroupName().compareTo(this.getASLSession().getGroupName()) != 0) continue;
                toReturn.put(vre.getGroupId(), vre.getGroupName());
            }
        }
        return toReturn;
    }

    private boolean isAdmin() throws PortalException, SystemException {
        User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        Organization rootOrganization = null;
        for (Organization organization : organizations) {
            if (!organization.getName().equals(OrganizationsUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        try {
            _log.trace("root: " + rootOrganization.getName());
            return this.hasRole("Administrator", rootOrganization.getName(), currUser);
        }
        catch (NullPointerException e) {
            _log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder");
            return false;
        }
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename) != 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<GroupModel> getUserVREs(String username) {
        ArrayList<GroupModel> toReturn = new ArrayList<GroupModel>();
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            User currUser = OrganizationsUtil.validateUser((String)username);
            for (Organization org : currUser.getOrganizations()) {
                if (!gm.isVRE(org.getOrganizationId() + "").booleanValue()) continue;
                GroupModel toAdd = gm.getGroup("" + org.getOrganizationId());
                toReturn.add(toAdd);
            }
        }
        catch (Exception e) {
            _log.error("Failed reading User VREs for : " + username);
            e.printStackTrace();
            return toReturn;
        }
        return toReturn;
    }

    private String getScopeByOrganizationId(String vreid) {
        LiferayGroupManager gm = new LiferayGroupManager();
        try {
            return gm.getScope(vreid);
        }
        catch (Exception e) {
            _log.error("Could not find a scope for this VREid: " + vreid);
            return null;
        }
    }

    private String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        String toReturn = html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        toReturn = toReturn.replaceAll("(\r\n|\n)", "<br />");
        toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
        return toReturn;
    }

    public String extractURL(String feedText) {
        String[] parts;
        for (String item : parts = feedText.split("\\s")) {
            if (!item.startsWith("http")) continue;
            try {
                new URL(item);
                return item;
            }
            catch (MalformedURLException e) {
                _log.error("MalformedURLException returning... ");
                return null;
            }
        }
        return null;
    }

    public LinkPreview checkLink(String linkToCheck) {
        URL pageURL;
        LinkPreview toReturn = null;
        _log.info("to check " + linkToCheck);
        linkToCheck = this.extractURL(linkToCheck);
        if (linkToCheck == null) {
            return null;
        }
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (!urlValidator.isValid(linkToCheck)) {
            _log.warn("url is NOT valid, returning nothing");
            return null;
        }
        _log.debug("url is valid");
        HttpURLConnection siteConnection = null;
        try {
            pageURL = new URL(linkToCheck);
            if (pageURL.getProtocol().equalsIgnoreCase("https")) {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                this.trustAllHTTPSConnections();
                siteConnection = (HttpsURLConnection)pageURL.openConnection();
            } else {
                siteConnection = (HttpURLConnection)pageURL.openConnection();
            }
        }
        catch (MalformedURLException e) {
            _log.error("url is not valid");
            return null;
        }
        catch (IOException e) {
            _log.error("url is not reachable");
            return null;
        }
        siteConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        ArrayList imageUrls = new ArrayList();
        String host = pageURL.getHost().replaceAll("www.", "");
        OpenGraph ogLink = null;
        try {
            ogLink = new OpenGraph(linkToCheck, true, (URLConnection)siteConnection);
            if (ogLink != null && ogLink.getContent("title") != null) {
                _log.info("OpenGraph Found");
                String title = ogLink.getContent("title");
                String description = ogLink.getContent("description") != null ? ogLink.getContent("description") : "";
                String string = description = description.length() > 256 ? description.substring(0, 256) + "..." : description;
                if (ogLink.getContent("image") != null) {
                    String imageUrl = this.getImageUrlFromSrcAttribute(pageURL, ogLink.getContent("image"));
                    imageUrls.add(imageUrl);
                    _log.trace("OpenGraph getImage = " + imageUrl);
                } else {
                    _log.trace("OpenGraph No Image, trying manuale parsing");
                    ArrayList images = this.getImagesWithCleaner(pageURL);
                    if (!images.isEmpty()) {
                        imageUrls = images;
                    }
                }
                toReturn = new LinkPreview(title, description, linkToCheck, host, imageUrls);
                return toReturn;
            }
            _log.info("No OpenGraph Found, going Best guess from page content");
            toReturn = this.getInfoFromHTML((URLConnection)siteConnection, pageURL, linkToCheck, host);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private LinkPreview getInfoFromHTML(URLConnection connection, URL pageUrl, String link, String host) throws Exception {
        LinkPreview toReturn = null;
        String title = "";
        String description = "";
        URLConnection conn = pageUrl.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        MetaSeeker ms = null;
        try {
            title = this.getTitleFromHeader(pageUrl);
            ms = new MetaSeeker(connection, pageUrl);
            description = ms.getContent("description") != null && !ms.getContent("description").isEmpty() ? ms.getContent("description") : this.createDescriptionFromContent(link);
            ArrayList images = new ArrayList();
            images = this.getImagesWithCleaner(pageUrl);
            toReturn = new LinkPreview(title, description, link, host, images);
        }
        catch (Exception e) {
            _log.error("[MANUAL-PARSE] Something wrong with the meta seeker returning ... ");
            return toReturn;
        }
        return toReturn;
    }

    private String getTitleFromHeader(URL pageURL) throws IOException {
        String headContentsStr;
        HtmlCleaner cleaner;
        TagNode pageData;
        TagNode[] title;
        String inputLine;
        URLConnection conn = pageURL.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        Charset charset = OpenGraph.getConnectionCharset((URLConnection)conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            if (inputLine.contains("</head>")) {
                inputLine = inputLine.substring(0, inputLine.indexOf("</head>") + 7);
                inputLine = inputLine.concat("<body></body></html>");
                headContents.append(inputLine + "\r\n");
                break;
            }
            headContents.append(inputLine + "\r\n");
        }
        if ((title = (pageData = (cleaner = new HtmlCleaner()).clean(headContentsStr = headContents.toString())).getElementsByName("title", true)) != null && title.length > 0) {
            String theTitle = title[0].getChildren().get(0).toString();
            _log.trace("theTitle: " + theTitle);
            return theTitle;
        }
        return null;
    }

    private ArrayList<String> getImagesWithCleaner(URL pageURL) throws IOException {
        String inputLine;
        ArrayList<String> images = new ArrayList<String>();
        URLConnection conn = pageURL.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        Charset charset = OpenGraph.getConnectionCharset((URLConnection)conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer headContents = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            headContents.append(inputLine + "\r\n");
        }
        HtmlCleaner cleaner = new HtmlCleaner();
        String headContentsStr = headContents.toString();
        TagNode pageData = cleaner.clean(headContentsStr);
        TagNode[] imgs = pageData.getElementsByName("img", true);
        int upTo = imgs.length > 15 ? 15 : imgs.length;
        for (int i = 0; i < upTo; ++i) {
            if (!imgs[i].hasAttribute("src")) continue;
            String imageUrl = this.getImageUrlFromSrcAttribute(pageURL, imgs[i].getAttributeByName("src"));
            images.add(imageUrl);
            _log.trace("[FOUND image] " + imageUrl);
        }
        return images;
    }

    private String getImageUrlFromSrcAttribute(URL pageURL, String srcAttr) {
        String imageUrl = srcAttr;
        if (imageUrl.startsWith("/")) {
            imageUrl = pageURL.getProtocol() + "://" + pageURL.getHost() + imageUrl;
        } else if (imageUrl.startsWith("../")) {
            imageUrl = pageURL.toExternalForm().endsWith("/") ? pageURL.toExternalForm() + imageUrl : pageURL.toExternalForm() + "/" + imageUrl;
        } else if (!imageUrl.contains("/")) {
            String imageFolder = pageURL.toString().substring(0, pageURL.toString().lastIndexOf("/"));
            imageUrl = imageFolder + "/" + imageUrl;
        } else if (!imageUrl.startsWith("http")) {
            imageUrl = pageURL.toExternalForm().endsWith("/") ? pageURL.toExternalForm() + imageUrl : pageURL.toExternalForm() + "/" + imageUrl;
        }
        return imageUrl;
    }

    private String createDescriptionFromContent(String link) {
        StringBean sb = new StringBean();
        sb.setURL(link);
        sb.setLinks(false);
        String description = sb.getStrings();
        description = description.length() > 256 ? description.substring(0, 256) + "..." : description;
        return description;
    }

    private void trustAllHTTPSConnections() {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)sc.getSocketFactory());
        }
        catch (Exception e) {
            System.out.println("Error" + e);
        }
    }

    private boolean isInfrastructureScope() {
        ScopeBean scope = new ScopeBean(this.getASLSession().getScope());
        return scope.is(ScopeBean.Type.INFRASTRUCTURE);
    }

    public ArrayList<PickingUser> getSelectedUserIds(ArrayList<String> fullNames) {
        if (fullNames == null) {
            return new ArrayList<PickingUser>();
        }
        ArrayList allUsers = this.getPortalUsers();
        ArrayList<PickingUser> toReturn = new ArrayList<PickingUser>();
        block0: for (String fullName : fullNames) {
            for (PickingUser puser : allUsers) {
                if (puser.getFullName().compareTo(fullName) != 0) continue;
                toReturn.add(puser);
                continue block0;
            }
        }
        return toReturn;
    }

    public ArrayList<PickingUser> getPortalUsers() {
        ArrayList<PickingUser> portalUsers = new ArrayList<PickingUser>();
        String currUser = this.getASLSession().getUsername();
        try {
            if (this.withinPortal) {
                LiferayUserManager um = new LiferayUserManager();
                LiferayGroupManager gm = new LiferayGroupManager();
                List users = um.listUsersByGroup(gm.getRootVO().getGroupId());
                for (UserModel user : users) {
                    if (user.getScreenName().compareTo("test.user") == 0 || user.getScreenName().compareTo(currUser) == 0) continue;
                    String thumbnailURL = "";
                    User lifeUser = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)user.getScreenName());
                    thumbnailURL = "/image/user_male_portrait?img_id=" + lifeUser.getPortraitId();
                    portalUsers.add(new PickingUser(user.getUserId(), user.getScreenName(), user.getFullname(), thumbnailURL));
                }
            } else {
                portalUsers.add(new PickingUser("12111", "massimiliano.assante", "Test User #1", ""));
                portalUsers.add(new PickingUser("14111", "massimiliano.assante", "Test Second User #2", ""));
                portalUsers.add(new PickingUser("11511", "massimiliano.assante", "Test Third User", ""));
                portalUsers.add(new PickingUser("11611", "massimiliano.assante", "Test Fourth User", ""));
                portalUsers.add(new PickingUser("11711", "massimiliano.assante", "Test Fifth User", ""));
                portalUsers.add(new PickingUser("11811", "massimiliano.assante", "Test Sixth User", ""));
                portalUsers.add(new PickingUser("15811", "massimiliano.assante", "Ninth Testing User", ""));
                portalUsers.add(new PickingUser("15811", "massimiliano.assante", "Eighth Testing User", ""));
                portalUsers.add(new PickingUser("11211", "giogio.giorgi", "Seventh Test User", ""));
                portalUsers.add(new PickingUser("2222", "pino.pinetti", "Tenth Testing User", ""));
            }
        }
        catch (Exception e) {
            _log.error("Error in server get all contacts ", (Throwable)e);
        }
        return portalUsers;
    }
}

