/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.gcube.applicationsupportlayer.social.storage.FTPManager;
import org.gcube.portal.databook.shared.ImageType;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilePreviewer {
    private static Logger _log = LoggerFactory.getLogger(FilePreviewer.class);
    private static final String PDF_DEFAULT_IMAGE = "default/pdf.png";
    private static final String NOTHUMB_DEFAULT_IMAGE = "default/default_image.png";
    private static final String GENERICFILE_DEFAULT_IMAGE = "default/default_generic.png";
    private static final String[] handledextensionImages = new String[]{"css", "csv", "doc", "docx", "java", "mdb", "mp3", "pdf", "ppt", "pptx", "psd", "rar", "tex", "txt", "xls", "xlsx", "zip"};

    private static FTPManager getFTPManager() {
        return FTPManager.getInstance();
    }

    protected static LinkPreview getPdfPreview(String fileName, String path2Pdf, String httpUrl, String mimeType) throws Exception {
        ArrayList<String> imagesUrl = new ArrayList<String>();
        String desc = null;
        try {
            desc = FilePreviewer.getPDFDescription((String)path2Pdf);
        }
        catch (Exception ex) {
            _log.warn("PDF Parse exception, returning no description");
            desc = "";
        }
        File pdfFile = new File(path2Pdf);
        RandomAccessFile raf = new RandomAccessFile(pdfFile, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        PDFFile pdf = null;
        try {
            pdf = new PDFFile((ByteBuffer)buf);
        }
        catch (PDFParseException ex) {
            raf.close();
            _log.error("PDF Parse exception, returning default pdf image");
            imagesUrl.add(String.valueOf(FilePreviewer.getFTPManager().getBaseURL()) + "default/pdf.png");
            return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
        }
        PDFPage page = pdf.getPage(0);
        int width = (int)page.getBBox().getWidth();
        int height = (int)page.getBBox().getHeight();
        int scaledWidth = width / 8;
        int scaledHeight = height / 8;
        Rectangle rect = new Rectangle(0, 0, width, height);
        BufferedImage bufferedImage = new BufferedImage(scaledWidth, scaledHeight, 1);
        Image image = page.getImage(scaledWidth, scaledHeight, (Rectangle2D)rect, null, true, true);
        Graphics2D bufImageGraphics = bufferedImage.createGraphics();
        bufImageGraphics.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean result = ImageIO.write((RenderedImage)bufferedImage, "JPG", out);
        raf.close();
        if (result) {
            String httpLink = FilePreviewer.getFTPManager().uploadImageOnFTPServer((InputStream)new ByteArrayInputStream(out.toByteArray()), ImageType.JPG);
            _log.debug("PDF thumbnail available at: " + httpLink);
            imagesUrl.add(httpLink);
            return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
        }
        throw new IOException("Could not process pdf file");
    }

    protected static LinkPreview getImagePreview(String fileName, String path2Image, String httpUrl, String mimeType) throws Exception {
        ArrayList<String> imagesUrl = new ArrayList<String>();
        String desc = "";
        BufferedImage img = ImageIO.read(new File(path2Image));
        BufferedImage thumbnail = Scalr.resize((BufferedImage)img, (Scalr.Method)Scalr.Method.QUALITY, (int)80, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean result = ImageIO.write((RenderedImage)thumbnail, "JPG", out);
        out.flush();
        out.close();
        if (result) {
            String httpLink = FilePreviewer.getFTPManager().uploadImageOnFTPServer((InputStream)new ByteArrayInputStream(out.toByteArray()), ImageType.JPG);
            _log.debug("\nFlushed, Image thumbnail available at: " + httpLink);
            imagesUrl.add(httpLink);
            return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
        }
        throw new IOException("Could not process image file");
    }

    protected static LinkPreview getUnhandledTypePreview(String fileName, String path2Pdf, String httpUrl, String mimeType) throws Exception {
        ArrayList<String> imagesUrl = new ArrayList<String>();
        String extension = FilePreviewer.getExtension((String)fileName);
        String desc = "";
        if (extension == null) {
            imagesUrl.add(String.valueOf(FilePreviewer.getFTPManager().getBaseURL()) + "default/default_generic.png");
        } else {
            int foundIndex = Arrays.binarySearch(handledextensionImages, extension);
            if (foundIndex < 0) {
                imagesUrl.add(String.valueOf(FilePreviewer.getFTPManager().getBaseURL()) + "default/default_generic.png");
            } else {
                imagesUrl.add(String.valueOf(FilePreviewer.getFTPManager().getBaseURL()) + "default/" + extension + ".png");
            }
        }
        return new LinkPreview(fileName, desc, httpUrl, mimeType, imagesUrl);
    }

    private static String getExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        String extension = fileName.substring(lastDot + 1);
        _log.debug("EXTENSION FOUND =  " + extension);
        return extension;
    }

    private static String getPDFDescription(String path2File) throws Exception {
        PDDocument doc = PDDocument.load((String)path2File);
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setStartPage(1);
        stripper.setEndPage(1);
        String text = stripper.getText(doc);
        String toReturn = text.length() > 300 ? String.valueOf(text.substring(0, 295)) + " ... " : text;
        doc.close();
        return toReturn;
    }
}

