/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.shareupdates.client.view.ImageSwitcher;
import org.gcube.portlets.user.shareupdates.client.view.LinkPreviewer;
import org.gcube.portlets.user.shareupdates.client.view.Placeholder;
import org.gcube.portlets.user.shareupdates.client.view.SaveInWorkspaceBox;
import org.gcube.portlets.user.shareupdates.client.view.ShareUpdateForm;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;

public class LinkPreviewer
extends Composite {
    private static LinkPreviewUiBinder uiBinder = (LinkPreviewUiBinder)GWT.create(LinkPreviewUiBinder.class);
    private ShareUpdateForm parent;
    private LinkPreview toShow;
    private SaveInWorkspaceBox saveCopy;
    @UiField
    HTML closeImage;
    @UiField
    ImageSwitcher switcher;
    @UiField
    HTML titleArea;
    @UiField
    HTML urlText;
    @UiField
    HTML descText;
    @UiField
    CheckBox hideCheckBox;
    @UiField
    CheckBox hideImageCheckBox;
    @UiField
    Placeholder uploadInWS;

    public LinkPreviewer(ShareUpdateForm parent, LinkPreview toShow, boolean isFilePreview) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.closeImage.setStyleName("su-closeImage");
        this.closeImage.setTitle("Cancel");
        this.parent = parent;
        this.toShow = toShow;
        this.titleArea.setHTML("<a class=\"link\" target=\"_blank\" href=\"" + toShow.getUrl() + "\">" + toShow.getTitle() + "</a> <span style=\"color: #333;\"> - " + toShow.getHost() + "</span>");
        String url = toShow.getUrl();
        this.urlText.setHTML(url.length() > 80 ? String.valueOf(url.substring(0, 80)) + "..." : url);
        String desc = toShow.getDescription();
        this.descText.setHTML(desc.length() > 256 ? String.valueOf(desc.substring(0, 256)) + "..." : desc);
        this.switcher.setImages(toShow.getImageUrls());
        if (isFilePreview) {
            this.saveCopy = new SaveInWorkspaceBox();
            this.uploadInWS.add((Widget)this.saveCopy);
        }
    }

    public ImageSwitcher getSwitcher() {
        return this.switcher;
    }

    @UiHandler(value={"closeImage"})
    void onDeleteFeedClick(ClickEvent e) {
        this.parent.cancelPreview();
    }

    @UiHandler(value={"hideImageCheckBox"})
    void onHideImageClick(ClickEvent e) {
        this.switcher.setVisible(this.hideImageCheckBox.getValue() == false);
    }

    @UiHandler(value={"hideCheckBox"})
    void onClick(ClickEvent e) {
        this.descText.setVisible(this.hideCheckBox.getValue() == false);
    }

    public String getLinkTitle() {
        return this.toShow.getTitle();
    }

    public String getLinkDescription() {
        return this.hideCheckBox.getValue() != false ? "" : this.toShow.getDescription();
    }

    public String getUrl() {
        return this.toShow.getUrl();
    }

    public String getHost() {
        return this.toShow.getHost();
    }

    public String getUrlThumbnail() {
        return this.switcher.getSelectedImageURL();
    }
}

