/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.gcube.applicationsupportlayer.social.storage.FTPManager;
import org.gcube.portal.databook.shared.ImageType;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FilePreviewer {
    private static Logger _log = LoggerFactory.getLogger(FilePreviewer.class);
    private static final String PDF_DEFAULT_IMAGE = "default_pdf.png";

    private static FTPManager getFTPManager() {
        return FTPManager.getInstance();
    }

    protected static LinkPreview getPdfPreview(String fileName, String path2Pdf, String httpUrl) throws Exception {
        ArrayList<String> imagesUrl = new ArrayList<String>();
        String desc = null;
        try {
            desc = FilePreviewer.getPDFDescription((String)path2Pdf);
        }
        catch (Exception ex) {
            _log.warn("PDF Parse exception, returning no description");
            desc = "";
        }
        File pdfFile = new File(path2Pdf);
        RandomAccessFile raf = new RandomAccessFile(pdfFile, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        PDFFile pdf = null;
        try {
            pdf = new PDFFile((ByteBuffer)buf);
        }
        catch (PDFParseException ex) {
            raf.close();
            _log.error("PDF Parse exception, returning default pdf image");
            imagesUrl.add(FilePreviewer.getFTPManager().getBaseURL() + "default_pdf.png");
            return new LinkPreview(fileName, desc, httpUrl, "d4science.org", imagesUrl);
        }
        PDFPage page = pdf.getPage(0);
        int width = (int)page.getBBox().getWidth();
        int height = (int)page.getBBox().getHeight();
        int scaledWidth = width / 8;
        int scaledHeight = height / 8;
        Rectangle rect = new Rectangle(0, 0, width, height);
        BufferedImage bufferedImage = new BufferedImage(scaledWidth, scaledHeight, 1);
        Image image = page.getImage(scaledWidth, scaledHeight, (Rectangle2D)rect, null, true, true);
        Graphics2D bufImageGraphics = bufferedImage.createGraphics();
        bufImageGraphics.drawImage(image, 0, 0, scaledWidth, scaledHeight, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean result = ImageIO.write((RenderedImage)bufferedImage, "JPG", out);
        raf.close();
        if (result) {
            String httpLink = FilePreviewer.getFTPManager().uploadImageOnFTPServer((InputStream)new ByteArrayInputStream(out.toByteArray()), ImageType.JPG);
            _log.debug("PDF thumbnail available at: " + httpLink);
            imagesUrl.add(httpLink);
            return new LinkPreview(fileName, desc, httpUrl, "d4science.org", imagesUrl);
        }
        throw new IOException("Could not process pdf file");
    }

    private static String getPDFDescription(String path2File) throws Exception {
        PDDocument doc = PDDocument.load((String)path2File);
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setStartPage(1);
        stripper.setEndPage(1);
        String text = stripper.getText(doc);
        String toReturn = text.length() > 300 ? text.substring(0, 295) + " ... " : text;
        doc.close();
        return toReturn;
    }
}

