package org.gcube.portlets.user.shareupdates.client.elements;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasText;

/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 *
 */
public class ContentEditDiv extends HTML implements HasText {

	public ContentEditDiv() {
		super(DOM.createElement("div"));
		//important to make it act like a textarea
		DOM.setElementAttribute(getElement(), "contentEditable", "true"); 
		DOM.setElementAttribute(getElement(), "id", "mycontentEditableElement"); 
	}

	public ContentEditDiv(String text) {
		this();
		setText(text);
	}

	public void setEnabled(boolean enabled) {
		DOM.setElementPropertyBoolean(getElement(), "disabled", !enabled);
	}


	public static native void setEndOfContenteditable() /*-{
		var contentEditableElement = $doc.getElementById("mycontentEditableElement");
    	var range,selection;
		if($doc.createRange)//Firefox, Chrome, Opera, Safari, IE 9+
		{
			range = $doc.createRange();//Create a range (a range is a like the selection but invisible)
			range.selectNodeContents(contentEditableElement);//Select the entire contents of the element with the range
			range.collapse(false);//collapse the range to the end point. false means collapse to end rather than the start
			selection = $wnd.getSelection();//get the selection object (allows you to change selection)
			selection.removeAllRanges();//remove any selections already made
			selection.addRange(range);//make the range you have just created the visible selection
		}
		else if($doc.selection)//IE 8 and lower
		{ 
			range = $doc.body.createTextRange();//Create a range (a range is a like the selection but invisible)
			range.moveToElementText(contentEditableElement);//Select the entire contents of the element with the range
			range.collapse(false);//collapse the range to the end point. false means collapse to end rather than the start
			range.select();//Select the range (make it the visible selection
		}
  }-*/;
}
