package org.gcube.portlets.user.pickuser.client.uibinder;

import org.gcube.portlets.user.pickuser.client.dialog.PickUsersDialog;
import org.gcube.portlets.user.pickuser.shared.PickingUser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class SingleUserTemplate extends Composite {

	private static LikedTemplateUiBinder uiBinder = GWT
			.create(LikedTemplateUiBinder.class);

	interface LikedTemplateUiBinder extends UiBinder<Widget, SingleUserTemplate> {
	}
	PickUsersDialog owner;
	private int currDisplayIndex;
	
	@UiField
	FocusPanel focusDiv;
	@UiField
	Image avatarImage;
	@UiField
	HTML contentArea;
	
	public SingleUserTemplate(PickUsersDialog owner, PickingUser user, int displayIndex) {
		initWidget(uiBinder.createAndBindUi(this));
		this.owner = owner;
		currDisplayIndex = displayIndex;
		if (user.getThumbnailURL() != null)
			avatarImage.setUrl(user.getThumbnailURL());
		
		avatarImage.setPixelSize(30, 30);
		contentArea.setHTML(user.getFullName());
		
		
	}
	
	@UiHandler("focusDiv")
	void onMouseOver(MouseOverEvent e) {
		owner.select(currDisplayIndex);
	}
	
	public String getFullName() {
		return contentArea.getText();
	}
}
