package org.gcube.portlets.user.occurrencemanagement.server.tabular;

import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;
import org.gcube.portlets.user.occurrencemanagement.server.service.ReconciliationService;
import org.gcube.portlets.user.occurrencemanagement.server.util.SessionUtil;
import org.gcube.portlets.user.tdw.datasource.jdbc.JDBCDataSource;
import org.gcube.portlets.user.tdw.server.datasource.DataSource;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceException;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceFactory;
import org.gcube.portlets.user.tdw.shared.model.TableId;


/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class OccurrenceManagementDataSourceFactory implements DataSourceFactory {
	
	
	
	public static Logger logger = Logger.getLogger(OccurrenceManagementDataSourceFactory.class);

	@Override
	public String getId() {
		return ConstantsPortletOccurrence.TD_DATASOUCEFACTORY_ID;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.tdw.server.datasource.DataSourceFactory#getDataSource(org.gcube.application.framework.core.session.ASLSession, java.lang.String)
	 */
	@Override
	public DataSource openDataSource(ASLSession session, TableId tableIdentifier) throws DataSourceException {

		// the table id
		String tableId = tableIdentifier.getTableKey().toLowerCase();
		
		// get url from service
		String url = null;
		try {
			
			url = getUrlFromTableId(session, tableId);
	
		} catch (Exception e) {
			
			new DataSourceException("exception on getUrlFromTableId "+e);
		}
			
		// create the datasource, with jdbc url and table name (id)
		JDBCDataSource dataSource = new JDBCDataSource(ConstantsPortletOccurrence.TD_DATASOUCEFACTORY_ID, url, tableId);

		return dataSource;
		
	}

	/**
	 * @param tableId
	 * @return
	 * @throws Exception 
	 */
	protected String getUrlFromTableId(ASLSession session, String tableId) throws Exception {

		logger.trace("getUrlFromTableId...");
		ReconciliationService service = SessionUtil.getService(session);
		String url = service.getUrlFromTableId(tableId);

		System.out.println("TABLE URL: " +url);		
		
		logger.trace("TABLE URL..." +url);
		
		return url;
	}


	@Override
	public void closeDataSource(ASLSession session, DataSource dataSource)throws DataSourceException {
		JDBCDataSource jdatasource = (JDBCDataSource) dataSource;
		jdatasource.close();
		
	}
}
