package org.gcube.portlets.user.occurrencemanagement.client.view.panel.data;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.CsvImport;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxConfirm;
import org.gcube.portlets.user.occurrencemanagement.client.event.DeleteResourceEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.OpenTableEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.SaveResourceEvent;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.ResourceType;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GroupColumnData;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.AbstractImagePrototype;

public class GridOccurrenceDataPanel extends ContentPanel{
	
	private static final String VIEW = "View";
	private ToolBar toolbar;
	private JobManager jobManager;
	private Grid<BaseModelData> grid;
	private final static String INFO = "Info";
	private static final String CANCEL = "Cancel";
	private static final String REFRESH = "Refresh";
	private static final String IMPORT = "Import";
	private static final String SAVE = "Save";
	private Button buttonInfo;
	private Button buttonView;
	private Button buttonCancel;
	private Button buttonRefresh;
	private Button buttonImport;
	private Button buttonSave;
	private MenuItem menuView = new MenuItem(); 
	private Menu menu = new Menu();
	
	public GridOccurrenceDataPanel(final JobManager jobManager) {
		setLayout(new FitLayout());	
		setBodyBorder(false);
		
		this.jobManager = jobManager;
		
		this.grid = jobManager.getGridJob().getGrid();
		
		this.grid.getSelectionModel().addSelectionChangedListener(new SelectionChangedListener<BaseModelData>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<BaseModelData> se) {
				System.out.println("selection grid change");
				
				ModelData target = se.getSelectedItem();
				
				if(target!=null)
					enableButtonOnClick(true);
				else
					enableButtonOnClick(false);
				
			}
		});
		
		jobManager.getGridJob().getStore().groupBy(JobOccurrencesModel.ELABORATIONTYPE); 
	    GroupingView view = new GroupingView();  
	    view.setShowGroupedColumn(false);  
	 	grid.setView(view);
	    
	    view.setGroupRenderer(new GridGroupRenderer() {  
	      public String render(GroupColumnData data) {  
	        String f = grid.getColumnModel().getColumnById(data.field).getHeader();  
	        String l = data.models.size() == 1 ? "Item" : "Items";  
	        return f + ": " + data.group + " (" + data.models.size() + " " + l + ")";  
	      }  
	    });  
	    
		createGridToolBar();
		createMenuItemsOnGrid();
		
		
		menu.addListener(Events.BeforeShow, new Listener<MenuEvent>() {

			@Override
			public void handleEvent(MenuEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				resetButtonViewVisibility();
					if(!jobModel.get(JobOccurrencesModel.RESOURCETYPE).equals(ResourceType.TABULAR)){
						buttonView.setEnabled(false);
						menuView.setVisible(false);
					}
				
			}
		});

		this.add(jobManager.getGridJob());

	}
	
	private void resetButtonViewVisibility(){
		buttonView.setEnabled(true);
		menuView.setVisible(true);
	}
	
	private void createGridToolBar(){
		
		this.toolbar = new ToolBar();
		
		buttonImport = new Button(IMPORT);
		buttonImport.setScale(ButtonScale.MEDIUM);
//		buttonInfo.setIconAlign(IconAlign.LEFT);
//		buttonInfo.setArrowAlign(ButtonArrowAlign.RIGHT);
		buttonImport.setIcon(AbstractImagePrototype.create(Resources.getImageUpload()));
		buttonImport.setStyleAttribute("margin-left", "5px");
		buttonImport.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {

//				ImportOccurrencesFileWindow importOccurrences = new ImportOccurrencesFileWindow();
//				importOccurrences.show();
				
				CsvImport cswImport = new CsvImport();
			}
		});
		
		buttonInfo = new Button(INFO);
		buttonInfo.setScale(ButtonScale.MEDIUM);
//		buttonInfo.setIconAlign(IconAlign.LEFT);
//		buttonInfo.setArrowAlign(ButtonArrowAlign.RIGHT);
		buttonInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		buttonInfo.setStyleAttribute("margin-left", "5px");
		buttonInfo.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				info(jobModel);
			}
		});
		
		buttonView =  new Button(VIEW);
		buttonView.setIcon(AbstractImagePrototype.create(Resources.getImageTable()));
		buttonView.setScale(ButtonScale.MEDIUM);

		buttonView.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				view(jobModel);
			}
		});
		
		
		buttonCancel =  new Button(CANCEL);
		buttonCancel.setScale(ButtonScale.MEDIUM);
		buttonCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		buttonCancel.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);
	
			}
		});
		
		buttonRefresh =  new Button(REFRESH);
		buttonRefresh.setScale(ButtonScale.MEDIUM);
		buttonRefresh.setIcon(Resources.getIconRefresh());
		
		buttonRefresh.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				refresh();
	
			}

		});
		
		buttonSave =  new Button(SAVE);
		buttonSave.setScale(ButtonScale.MEDIUM);
		buttonSave.setIcon(Resources.getIconSave());
		
		buttonSave.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				save(jobModel);
	
			}
		});

		toolbar.add(buttonImport);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonInfo);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonView);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonCancel);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonRefresh);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonSave);
		toolbar.add(new SeparatorToolItem());
		
		setTopComponent(toolbar);
		
		enableButtonOnClick(false);
	}
	
	public void createMenuItemsOnGrid(){
	

		
		MenuItem menuInfo = new MenuItem(); 
		menuInfo.setId(INFO );
		menuInfo.setText(INFO);  
		menuInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		
		menuInfo.addSelectionListener(new SelectionListener<MenuEvent>() {

			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				info(jobModel);
			}

		});

		menu.add(menuInfo);
			
	
		menuView.setId(VIEW);
		menuView.setText(VIEW);  
		menuView.setIcon(AbstractImagePrototype.create(Resources.getImageTable()));
		
		menuView.addSelectionListener(new SelectionListener<MenuEvent>() {
			
			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				view(jobModel);
			}

		});
		
		menu.add(menuView);
		
		MenuItem menuCancel= new MenuItem(); 
		menuCancel.setId(CANCEL);
		menuCancel.setText(CANCEL);  
		menuCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		menuCancel.addSelectionListener(new SelectionListener<MenuEvent>() {
			
			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);
			}

		});

		menu.add(menuCancel);
		
		grid.setContextMenu(menu);
		
	}
	
	private void cancel(final BaseModelData baseModel){
		
		if(baseModel!=null){
			
			String name = baseModel.get(JobOccurrencesModel.JOBNAME);
			
			MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", ConstantsPortletOccurrence.MESSAGE_CONFIRM_DELETE  + " "+ name+"?");
			mbc.getMessageBoxConfirm().addCallback(new Listener<MessageBoxEvent>() {
		          
			public void handleEvent(MessageBoxEvent be) {
				
				//IF CANCELLED
				String clickedButton = be.getButtonClicked().getItemId();
				if(clickedButton.equals(Dialog.YES)){
					
					JobOccurrencesModel jobModel = (JobOccurrencesModel) baseModel.get(JobOccurrencesModel.OCCURRENCEMODEL);
					String occurrenceId  = baseModel.get(JobOccurrencesModel.JOBINDENTIFIER);
					
					
					System.out.println("computationId " +jobModel.getOperationId());
					System.out.println("occurrenceId " +occurrenceId);
					
					
					OccurrenceApplicationController.getEventBus().fireEvent(new DeleteResourceEvent(jobModel.getOperationId(), occurrenceId, ElaborationType.IMPORTED));

				}
			}	
			});
		}
		
	}
	
	private void info(BaseModelData jobModel){
		
		if(jobModel!=null){

			String id = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);
			WindowInfoJobsSpecies win = jobManager.getGridJob().getListWindowInfo().get(id);
			win.show();
		}
	}
	
	
	private void view(BaseModelData jobModel){
		
		if(jobModel!=null){
			
			String id = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);
			String name = jobModel.get(JobOccurrencesModel.JOBNAME);

			OccurrenceApplicationController.getEventBus().fireEvent(new OpenTableEvent(id,name));
		
		}
	}
		
	public void enableButtonOnClick(boolean bool){
		this.buttonCancel.setEnabled(bool);
		this.buttonInfo.setEnabled(bool);
		this.buttonView.setEnabled(bool);
		this.buttonSave.setEnabled(bool);
	}
	
	protected void save(BaseModelData baseModel) {

		if(baseModel!=null){
			
			JobOccurrencesModel jobModel = (JobOccurrencesModel) baseModel.get(JobOccurrencesModel.OCCURRENCEMODEL);
			String name = baseModel.get(JobOccurrencesModel.JOBNAME);
			ElaborationType type = (ElaborationType) baseModel.get(JobOccurrencesModel.ELABORATIONTYPE);

			OccurrenceApplicationController.getEventBus().fireEvent(new SaveResourceEvent(jobModel.getOperationId(),name,type));
		
		}
		
	}
	
	public JobManager getJobManager(){
		return jobManager;
	}
	
	public List<BaseModelData> getOccurrencesLoadedByResourceType(ResourceType resourceType){
		
		List<BaseModelData> list = new ArrayList<BaseModelData>();
		
		for (BaseModelData baseModelData : this.grid.getStore().getModels()) {
			
			if(baseModelData.get(JobOccurrencesModel.RESOURCETYPE).equals(resourceType))
				list.add(baseModelData);
		}
		
		return list;
	}
	
	public List<BaseModelData> getOccurrencesLoaded(){
		return  this.grid.getStore().getModels();
	}
	
	public void refresh() {
		this.jobManager.reset();
		OccurrenceApplicationController.getEventBus().fireEvent(new ReLoadListOccurrencesEvent(ElaborationType.IMPORTED));
	}
	
	public boolean deleteItemById(String identifier){
		
		BaseModelData baseModel = grid.getStore().findModel(JobOccurrencesModel.JOBINDENTIFIER, identifier);
		
		if(baseModel!=null)
				return deleteItem(baseModel);
	
		else
			System.out.println("Delete Error: file target with " + identifier + " identifier not exist in store" );
			
		return false;
	}


	/**
	 * 
	 * @param itemTarget (MANDATORY)
	 * @return
	 */
	private boolean deleteItem(BaseModelData itemTarget) {
	
		Record record = grid.getStore().getRecord(itemTarget);
		
		if (record != null) {
			
			BaseModelData item = (BaseModelData) record.getModel();
			grid.getStore().remove(item);
			return true;
		} else
			System.out.println("Record Error: occurrence target with "
					+ itemTarget.get(JobOccurrencesModel.JOBINDENTIFIER)
					+ " identifier not exist in store");
	
		return false;
	
	}
}
