package org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation;



import org.gcube.portlets.user.occurrencemanagement.client.view.panel.data.ToolBarDataPanel;

import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;




/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class GxtBorderLayoutComputationPanel extends ContentPanel {
	private ContentPanel north = new ContentPanel();
	private ContentPanel est = new ContentPanel();
	private ContentPanel center = new ContentPanel();
	private CenterComputationPanelMng computationPanel;
	private DetailsOperationPanelMng detailsOperationManager;

	
	public GxtBorderLayoutComputationPanel(CenterComputationPanelMng computationPanel, DetailsOperationPanelMng detailsOperationManager) {
		this.computationPanel = computationPanel;
		this.detailsOperationManager = detailsOperationManager;
		this.initLayout();
		this.createLayouts();
	}

	private void initLayout(){
			
		north.setId("NorthComputationPanel");
		north.setLayout(new FitLayout());
		north.setHeaderVisible(false);
	    north.setBodyBorder(false);
		
		est.setId("EstComputationPanel");
		est.setLayout(new FitLayout());
		est.setHeaderVisible(false);
		est.setBodyBorder(false);
		
		center.setId("CenterComputationPanel");
		center.setLayout(new FitLayout());
		center.setBodyBorder(false);
	    center.setHeaderVisible(false);
		center.setScrollMode(Scroll.AUTOX);
		center.setBorders(false);
		
	}
		
	public void createLayouts(){
		
		final BorderLayout borderLayout = new BorderLayout();
		setLayout(borderLayout);
		setHeaderVisible(false);
		
	    BorderLayoutData northData = new BorderLayoutData(LayoutRegion.NORTH, 37, 37, 37);  
	    northData.setCollapsible(false);  

	    BorderLayoutData estData = new BorderLayoutData(LayoutRegion.EAST, 373,373,500);  
	    estData.setSplit(true);  
	    estData.setCollapsible(true);  
	    estData.setMargins(new Margins(0,3,0,0));
	  
	    BorderLayoutData centerData = new BorderLayoutData(LayoutRegion.CENTER);  
	    centerData.setMargins(new Margins(0));


	    north.add(new ToolBarDataPanel());
	    est.add(detailsOperationManager);
	    center.add(computationPanel);

	    add(est, estData); 
	    add(center, centerData);  
	}

	public void updateHeight(int rootHeight) {
		setHeight(rootHeight);
	}

	public void updateWidth(int rootWidth) {
		setWidth(rootWidth);

	}
	
	public void refreshProgressSize(){
		computationPanel.getGridComputation().updateProgressSize();
	}

	public CenterComputationPanelMng getComputationPanel() {
		return computationPanel;
	}

	public DetailsOperationPanelMng getDetailsOperationManager() {
		return detailsOperationManager;
	}
}