package org.gcube.portlets.user.occurrencemanagement.client.job;

import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationStatus;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;


public class JobManager {
	
	private GridJob gridJob;
	
	private HashMap<String, JobOccurrenceProgressBar> hashProgressBars;
	
	public JobManager(JobColumnConfig colConfig) {
		hashProgressBars = new HashMap<String, JobOccurrenceProgressBar>();
		gridJob = new GridJob(colConfig);
	}

	/**
	 * 
	 * @param jobsModel
	 * @return true if almost one progress bar is ongoing
	 */
	public boolean addListJob(List<JobOccurrencesModel> jobsModel){
		
		boolean isLoading = false;
		
		for(final JobOccurrencesModel jobModel : jobsModel){
			
			isLoading = addJob(jobModel);
		}
		
		return isLoading;
		
	}
	
	
	public boolean addJob(final JobOccurrencesModel jobModel){
		
		boolean isLoading = false;
		
//		System.out.println("job :" +jobModel);
		
		JobOccurrenceProgressBar jobsBar = hashProgressBars.get(jobModel.getIdentifier());
		
		if(jobsBar!=null){ //is update

			WindowInfoJobsSpecies win = (WindowInfoJobsSpecies) jobsBar.getData("win");
			
			if(win!=null){
				win.setDescriptionByModel(jobModel);
				win.layout();
				jobsBar.setData("win", win);
			}
			
			//IF job is COMPLETED OR FAILED OR COMPLETED WITH ERROR, IS NOT UPDATE
			if(jobsBar.isCompleted()){
				System.out.println("jobsBar " +jobModel.getName() + " is completed, status "+ jobModel.getDownloadState().toString() +" return" );
				return true;
			}
		
			updateProgressBarView(jobsBar, jobModel);

			gridJob.updateStatus(jobModel, jobsBar);

		}
		else{ //create new grid item that contains new progress bar
			
			if(jobModel.getIdentifier()!=null && !jobModel.getIdentifier().isEmpty()){
				
				JobOccurrenceProgressBar jobProgressBar = new JobOccurrenceProgressBar(jobModel.getIdentifier(), jobModel.getDownloadState().toString());
				
				gridJob.addJobIntoGrid(jobModel, jobProgressBar);
				
				updateProgressBarView(jobProgressBar, jobModel);
			
	//			hashTableContentPanels.put(jobModel.getIdentifier(), panelTable); //add contentPanel into hashTableContentPanels
				hashProgressBars.put(jobModel.getIdentifier(), jobProgressBar); //add progressBar into hashProgressBars
			}
		}
		
		gridJob.layout();

	
		return isLoading;
	}
	
	
	private boolean updateProgressBarView(JobOccurrenceProgressBar jobsBar, JobOccurrencesModel jobModel){
		
		
			switch (jobModel.getDownloadState()) {
			
			case PENDING:{
				jobsBar.progressStop();
				jobsBar.updateProgress(0);
				jobsBar.setCompleted(false);
				jobsBar.setProgressText(ElaborationStatus.PENDING.getLabel());
				break;
			}
	
			case COMPLETED:{

				jobsBar.getElement().getStyle().setBorderColor("#000000");
				jobsBar.progressStop();
				jobsBar.updateProgress(100);
				jobsBar.setCompleted(true);
				jobsBar.updateText(ElaborationStatus.COMPLETED.getLabel());

				break;
			}
	
			case RUNNING:{ 

				jobsBar.setProgressText(ElaborationStatus.RUNNING.getLabel());
				jobsBar.progressStart();
	
				return true;
			}
			
			case FAILED:{ 					
	
				jobsBar.getElement().getStyle().setBorderColor("#f00");
				jobsBar.progressStop();
				jobsBar.updateProgress(100);
				jobsBar.setCompleted(true);
				jobsBar.updateText(ElaborationStatus.FAILED.getLabel());
		
				break;
			}
			
			case DEQUEUE:{
				
				jobsBar.progressStop();
				jobsBar.updateProgress(0);
				jobsBar.setCompleted(false);
				jobsBar.updateText(ElaborationStatus.DEQUEUE.getLabel());
			}
			
			case STOPPED:{
				
				jobsBar.progressStop();
				jobsBar.updateProgress(100);
				jobsBar.setCompleted(true);
				jobsBar.updateText(ElaborationStatus.STOPPED.getLabel());
			}
				
		}
			
		return false;
		
	}

	public void removeSpeciesJob(String hashHPKey) {
		
		hashProgressBars.remove(hashHPKey); //remove progress bar from hash
		
	}
	
	
	public void reset(){
		hashProgressBars.clear();
		gridJob.resetStore();
	}

	public GridJob getGridJob() {
		return gridJob;
	}

}
